#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include "diag/Trace.h"
#include <stm32f4xx.h>
#include "GPIO.h"
#include "WM8731.h"
#include "audio_proc.h"

void delay_s(void);
void I2S_send(void);
void I2S_receive(void);

static enum {RUN, FINISHED} proc_status = FINISHED;	//status variable to indicate

static int16_t ADCL_in_buff;
static int16_t ADCR_in_buff;
static int16_t DACL_out_buff;
static int16_t DACR_out_buff;

int main(){
	GPIO_init();				//initialize the LEDs
	WM8731_init();				//initialize the codec pins an commence I2S communication
	GPIO_LED_set(OFF);

	while (1){
		if( proc_status == RUN ){
			ADCL_in = ADCL_in_buff;
			ADCR_in = ADCR_in_buff;
			DACL_out_buff = DACL_out;
			DACR_out_buff = DACR_out;

			audio_proc();

			proc_status = FINISHED;
		}

	}
}


static int8_t I2S_count = 0;
static enum {LEFT, RIGHT} last_side = LEFT;

#ifdef WM8731_fs_48kHz
void SPI2_IRQHandler(void){
	//reset the counter at an edge of the word select
	if(last_side == LEFT){
		if (   SPI2->SR & SPI_SR_CHSIDE  ) I2S_count = 0;
	}else{
		if ( !(SPI2->SR & SPI_SR_CHSIDE) ) I2S_count = 0;
	}

	//prepare new output data every last sequence
	if(I2S_count == 1){
		I2S_send();
	}else{
		SPI2->DR = 0x0000;
	}

	//read new input data every first sequence
	if(I2S_count == 0){
		I2S_receive();
	}

	//update the side state variable
	if(SPI2->SR & SPI_SR_CHSIDE){
		last_side = RIGHT;
	}else{
		last_side = LEFT;
	}
	//increase the counter
	I2S_count++;
}
#endif

#ifdef WM8731_fs_8kHz
void SPI2_IRQHandler(void){
	//reset the counter at an edge of the word select
	if(last_side == LEFT){
		if (   SPI2->SR & SPI_SR_CHSIDE  ) I2S_count = 0;
	}else{
		if ( !(SPI2->SR & SPI_SR_CHSIDE) ) I2S_count = 0;
	}

	//prepare new output data every last sequence
	if(I2S_count == 11){
		I2S_send();
	}else{
		SPI2->DR = 0x0000;
	}

	//read new input data every first sequence
	if(I2S_count == 0){
		I2S_receive();
	}

	//update the side state variable
	if(SPI2->SR & SPI_SR_CHSIDE){
		last_side = RIGHT;
	}else{
		last_side = LEFT;
	}
	//increase the counter
	I2S_count++;
}
#endif


void I2S_send(void){
	if(SPI2->SR & SPI_SR_CHSIDE){
		//transmit left data (other way around, as audio jack is mounted backwards)
		SPI2->DR = DACL_out_buff;
	}else{
		//transmit right data (other way around, as audio jack is mounted backwards)
		SPI2->DR = DACR_out_buff;
	}
}

void I2S_receive(void){
	if(SPI1->SR & SPI_SR_CHSIDE){
		//receive right side data
		ADCR_in_buff = SPI1->DR;
		//set the LED yellow to indicate error: not enough time to process new data
		if (proc_status == RUN){
			GPIO_LED_set(YELLOW);
		}
		//A new set of data available, new processing can be run
		proc_status = RUN;
	}else{
		//receive left side data
		ADCL_in_buff = SPI1->DR;
	}
}

void delay_s(void){
	for(volatile uint32_t i = 0; i<6000000; i++){/*do nothing in the for loop, just keep counting to 6 000 000*/}
}
