#include "audio_proc.h"

int16_t ADCL_in;
int16_t ADCR_in;
int16_t DACL_out;
int16_t DACR_out;

/*Audio processing function
- This function is called every new audio sample
- New input data is available in ADCX_in (L for left, R for right)
- Write new output data to DACX_out (L for left, R for right)
- Keep in mind that there is limited time to process a sample; you have to be finished before
  the next sample is available. The RGB LED will become yellow to signal this error.
- When using microphone data, ADCL and ADCR are equal.
*/

void audio_proc(void){
	DACL_out = ADCL_in;
	DACR_out = ADCR_in;
}
