#include "GPIO.h"
#include <stm32f4xx.h>

void GPIO_init(){
  	//init LEDs
  	RCC->AHB1ENR |= RCC_AHB1ENR_GPIOBEN;	//enable GPIOB clock domain
  	RCC->AHB1ENR |= RCC_AHB1ENR_GPIOCEN;	//enable GPIOC clock domain
	GPIOC->MODER |= ( GPIO_MODER_MODER0_0 | GPIO_MODER_MODER1_0 | GPIO_MODER_MODER2_0 );	//configure PC0, PC1 and PC2 as general purpose output
	GPIOC->OTYPER|= ( GPIO_OTYPER_OT_0    | GPIO_OTYPER_OT_1    | GPIO_OTYPER_OT_2    );	//configure PC0, PC1 and PC2 as open drain
	GPIO_LED_set(OFF);
	//init buttons
  	RCC->AHB1ENR |= RCC_AHB1ENR_GPIOAEN;	//enable GPIOA clock domain
  	GPIOA->PUPDR |= (GPIO_PUPDR_PUPDR0_0 | GPIO_PUPDR_PUPDR1_0); 		//configure puppies for button pins
}

//macro definitions for LED Bit Set/Reset Register
#define LED_RED_ON		GPIO_BSRR_BR_0
#define LED_RED_OFF		GPIO_BSRR_BS_0
#define LED_GREEN_ON	GPIO_BSRR_BR_1
#define LED_GREEN_OFF	GPIO_BSRR_BS_1
#define LED_BLUE_ON		GPIO_BSRR_BR_2
#define LED_BLUE_OFF	GPIO_BSRR_BS_2

void GPIO_LED_set(typeRGBColor color){
	switch(color){ //choose a color and switch on/off the required LEDs
		case RED:		GPIOC->BSRR = ( LED_RED_ON  | LED_GREEN_OFF | LED_BLUE_OFF ); break;
		case GREEN:		GPIOC->BSRR = ( LED_RED_OFF | LED_GREEN_ON  | LED_BLUE_OFF ); break;
		case BLUE:		GPIOC->BSRR = ( LED_RED_OFF | LED_GREEN_OFF | LED_BLUE_ON  ); break;
		case YELLOW:	GPIOC->BSRR = ( LED_RED_ON  | LED_GREEN_ON  | LED_BLUE_OFF ); break;
		case CYAN:		GPIOC->BSRR = ( LED_RED_OFF | LED_GREEN_ON  | LED_BLUE_ON  ); break;
		case MAGENTA: 	GPIOC->BSRR = ( LED_RED_ON  | LED_GREEN_OFF | LED_BLUE_ON  ); break;
		case WHITE:		GPIOC->BSRR = ( LED_RED_ON  | LED_GREEN_ON  | LED_BLUE_ON  ); break;
		case OFF:		GPIOC->BSRR = ( LED_RED_OFF | LED_GREEN_OFF | LED_BLUE_OFF ); break;
	}
}

//macro definitions for button Input Data Register
#define BUT1_pin	GPIO_IDR_IDR_0
#define BUT2_pin	GPIO_IDR_IDR_1

uint32_t GPIO_button_read(typeButton BUT_to_read){
	switch(BUT_to_read){
		case BUT1: return !(GPIOA->IDR & BUT1_pin); break;	//read BUT1 input
		case BUT2: return !(GPIOA->IDR & BUT2_pin); break;	//read BUT2 input
	}
	return 0;	//should never be reached, but prevents compiler warnings (return is required in all cases)
}
