/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.ui.catalog.UserActionCatalogItem;
import org.eclipse.epp.internal.mpc.ui.wizards.AbstractUserActionLinksItem;
import org.eclipse.epp.internal.mpc.ui.wizards.ActionLink;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryResources;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class RetryErrorActionItem
extends AbstractUserActionLinksItem {
    private static final String RETRY_ACTION_ID = "retry";
    private static final String DETAILS_ACTION_ID = "details";
    private final IStatus error;

    public RetryErrorActionItem(Composite parent, DiscoveryResources resources, IShellProvider shellProvider, UserActionCatalogItem element, MarketplaceViewer viewer) {
        super(parent, resources, shellProvider, element, viewer);
        this.error = MarketplaceClientCore.computeStatus((Throwable)((Throwable)element.getData()), null);
        this.createContent(new ActionLink(DETAILS_ACTION_ID, Messages.RetryErrorActionItem_showDetailsActionLabel, Messages.RetryErrorActionItem_showDetailsTooltip){

            public void selected() {
                RetryErrorActionItem.this.showDetails();
            }
        }, new ActionLink(RETRY_ACTION_ID, Messages.RetryErrorActionItem_retryActionLabel, Messages.RetryErrorActionItem_retryTooltip){

            public void selected() {
                RetryErrorActionItem.this.retry();
            }
        });
    }

    protected String getDescriptionText() {
        return NLS.bind((String)Messages.RetryErrorActionItem_failedToLoadMessage, (Object)(this.error.getMessage() == null ? this.error.getClass().getSimpleName() : this.error.getMessage()));
    }

    protected void showDetails() {
        ErrorDialog.openError((Shell)this.getShell(), (String)Messages.RetryErrorActionItem_errorDetailsDialogTitle, (String)this.getDescriptionText(), (IStatus)this.error);
    }

    protected void retry() {
        this.getViewer().reload();
    }

    protected MarketplaceViewer getViewer() {
        return (MarketplaceViewer)super.getViewer();
    }
}

