/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.core.model.Identifiable;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUiPlugin;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCatalog;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCategory;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceDiscoveryStrategy;
import org.eclipse.epp.internal.mpc.ui.catalog.UserActionCatalogItem;
import org.eclipse.epp.internal.mpc.ui.wizards.AbstractTagFilter;
import org.eclipse.epp.internal.mpc.ui.wizards.BrowseCatalogItem;
import org.eclipse.epp.internal.mpc.ui.wizards.DiscoveryItem;
import org.eclipse.epp.internal.mpc.ui.wizards.IDiscoveryItemFactory;
import org.eclipse.epp.internal.mpc.ui.wizards.IMarketplaceWebBrowser;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceCatalogConfiguration;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceDiscoveryResources;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceFilter;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplacePatternFilter;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewerSorter;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceWizard;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.Operation;
import org.eclipse.epp.internal.mpc.ui.wizards.RetryErrorActionItem;
import org.eclipse.epp.internal.mpc.ui.wizards.SelectionModel;
import org.eclipse.epp.internal.mpc.ui.wizards.UserActionViewerItem;
import org.eclipse.epp.internal.mpc.ui.wizards.UserFavoritesFindFavoritesActionItem;
import org.eclipse.epp.internal.mpc.ui.wizards.UserFavoritesLoginActionItem;
import org.eclipse.epp.internal.mpc.ui.wizards.UserFavoritesUnsupportedActionItem;
import org.eclipse.epp.mpc.core.model.ICatalogBranding;
import org.eclipse.epp.mpc.core.model.ICategory;
import org.eclipse.epp.mpc.core.model.IIdentifiable;
import org.eclipse.epp.mpc.core.model.IMarket;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.epp.mpc.core.service.IMarketplaceStorageService;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.equinox.internal.p2.discovery.AbstractDiscoveryStrategy;
import org.eclipse.equinox.internal.p2.discovery.Catalog;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.discovery.model.Tag;
import org.eclipse.equinox.internal.p2.ui.discovery.util.ControlListItem;
import org.eclipse.equinox.internal.p2.ui.discovery.util.FilteredViewer;
import org.eclipse.equinox.internal.p2.ui.discovery.util.GradientCanvas;
import org.eclipse.equinox.internal.p2.ui.discovery.util.PatternFilter;
import org.eclipse.equinox.internal.p2.ui.discovery.util.TextSearchControl;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogConfiguration;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogFilter;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogViewer;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CategoryItem;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryResources;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarketplaceViewer
extends CatalogViewer {
    public static final String QUERY_TAG_KEYWORD = "tag:";
    private ViewerFilter[] filters;
    private ContentType contentType = ContentType.SEARCH;
    public static String CONTENT_TYPE_PROPERTY = "contentType";
    private final SelectionModel selectionModel;
    private QueryData queryData = new QueryData();
    private final Map<ContentType, QueryData> tabQueries = new HashMap<ContentType, QueryData>();
    private ContentType queryContentType;
    private final IMarketplaceWebBrowser browser;
    private String findText;
    private final MarketplaceWizard wizard;
    private final List<IPropertyChangeListener> listeners = new LinkedList<IPropertyChangeListener>();
    private IDiscoveryItemFactory discoveryItemFactory;
    private MarketplaceDiscoveryResources discoveryResources;
    private boolean inUpdate;
    private Composite header;
    private final IMarketplaceStorageService.LoginListener loginListener = new IMarketplaceStorageService.LoginListener(){

        public void loginChanged(final String oldUser, final String newUser) {
            Control control = MarketplaceViewer.this.getControl();
            if (control != null && !control.isDisposed()) {
                Display display = control.getDisplay();
                Display current = Display.getCurrent();
                if (current == null || current != display) {
                    display.syncExec(new Runnable(){

                        public void run() {
                            this.loginChanged(oldUser, newUser);
                        }
                    });
                    return;
                }
                MarketplaceViewer.this.refreshFavorites();
            }
        }
    };

    public MarketplaceViewer(Catalog catalog, IShellProvider shellProvider, MarketplaceWizard wizard) {
        super(catalog, shellProvider, (IRunnableContext)wizard.getContainer(), (CatalogConfiguration)wizard.getConfiguration());
        this.browser = wizard;
        this.selectionModel = wizard.getSelectionModel();
        this.wizard = wizard;
        this.setAutomaticFind(false);
    }

    protected void doCreateHeaderControls(Composite parent) {
        this.header = parent;
        int originalChildCount = parent.getChildren().length;
        for (CatalogFilter filter : this.getConfiguration().getFilters()) {
            if (!(filter instanceof MarketplaceFilter)) continue;
            MarketplaceFilter marketplaceFilter = (MarketplaceFilter)filter;
            marketplaceFilter.createControl(parent);
            marketplaceFilter.addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if ("selected".equals(event.getProperty())) {
                        MarketplaceViewer.this.doQuery();
                    }
                }
            });
        }
        Control[] children = parent.getChildren();
        int x = originalChildCount;
        while (x < children.length) {
            Control child = children[x];
            GridDataFactory.swtDefaults().hint(135, -1).applyTo(child);
            ++x;
        }
        Button goButton = new Button(parent, 8);
        goButton.setText(Messages.MarketplaceViewer_go);
        goButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MarketplaceViewer.this.doQuery();
            }
        });
    }

    protected CatalogViewer.CatalogContentProvider doCreateContentProvider() {
        return new MarketplaceCatalogContentProvider();
    }

    protected MarketplaceDiscoveryResources getResources() {
        return this.discoveryResources;
    }

    protected void catalogUpdated(final boolean wasCancelled, final boolean wasError) {
        MarketplaceCatalog catalog = this.getCatalog();
        List discoveryStrategies = catalog.getDiscoveryStrategies();
        for (AbstractDiscoveryStrategy discoveryStrategy : discoveryStrategies) {
            if (!(discoveryStrategy instanceof MarketplaceDiscoveryStrategy)) continue;
            MarketplaceDiscoveryStrategy marketplaceDiscoveryStrategy = (MarketplaceDiscoveryStrategy)discoveryStrategy;
            marketplaceDiscoveryStrategy.addLoginListener(this.loginListener);
        }
        this.runUpdate(new Runnable(){

            public void run() {
                MarketplaceViewer.super.catalogUpdated(wasCancelled, wasError);
                for (CatalogFilter filter : MarketplaceViewer.this.getConfiguration().getFilters()) {
                    if (!(filter instanceof MarketplaceFilter)) continue;
                    ((MarketplaceFilter)filter).catalogUpdated(wasCancelled);
                }
                MarketplaceViewer.this.setFilters(MarketplaceViewer.this.queryData);
            }
        });
    }

    protected void doCheckCatalog() {
    }

    protected void filterTextChanged() {
        this.doFind(this.getFilterText());
    }

    protected void doFind(String text) {
        this.findText = text;
        this.doQuery();
    }

    protected ControlListItem<?> doCreateViewerItem(Composite parent, Object element) {
        if (element instanceof CatalogItem) {
            CatalogItem catalogItem = (CatalogItem)element;
            if (catalogItem instanceof UserActionCatalogItem) {
                return this.createUserActionViewerItem((UserActionCatalogItem)catalogItem, parent);
            }
            if (catalogItem.getData() instanceof CatalogDescriptor) {
                return this.createBrowseItem(catalogItem, parent);
            }
            DiscoveryItem<CatalogItem> discoveryItem = this.createDiscoveryItem(parent, catalogItem);
            discoveryItem.setSelected(this.getCheckedItems().contains(catalogItem));
            return discoveryItem;
        }
        if (element instanceof MarketplaceCategory) {
            MarketplaceCategory category = (MarketplaceCategory)((Object)element);
            if (category.getContents() != MarketplaceCategory.Contents.FEATURED) {
                throw new IllegalStateException();
            }
            category.setName(Messages.MarketplaceViewer_featured);
            CategoryItem categoryItem = (CategoryItem)super.doCreateViewerItem(parent, element);
            MarketplaceViewer.setSeparatorVisible(categoryItem, false);
            MarketplaceViewer.fixLayout(categoryItem);
            return categoryItem;
        }
        return super.doCreateViewerItem(parent, element);
    }

    private BrowseCatalogItem createBrowseItem(CatalogItem catalogItem, Composite parent) {
        CatalogDescriptor catalogDescriptor = (CatalogDescriptor)catalogItem.getData();
        return new BrowseCatalogItem(parent, this.getResources(), this.shellProvider, this.browser, (MarketplaceCategory)catalogItem.getCategory(), catalogDescriptor, this);
    }

    private UserActionViewerItem<?> createUserActionViewerItem(UserActionCatalogItem catalogItem, Composite parent) {
        UserActionCatalogItem.UserAction userAction = catalogItem.getUserAction();
        switch (userAction) {
            case BROWSE: {
                return this.createBrowseItem(catalogItem, parent);
            }
            case CREATE_FAVORITES: {
                return new UserFavoritesFindFavoritesActionItem(parent, (DiscoveryResources)this.getResources(), this.shellProvider, catalogItem, this.getWizard().getCatalogPage());
            }
            case FAVORITES_UNSUPPORTED: {
                return new UserFavoritesUnsupportedActionItem(parent, (DiscoveryResources)this.getResources(), this.shellProvider, catalogItem, this.getWizard().getCatalogPage());
            }
            case LOGIN: {
                return new UserFavoritesLoginActionItem(parent, (DiscoveryResources)this.getResources(), this.shellProvider, catalogItem, this);
            }
            case RETRY_ERROR: {
                return new RetryErrorActionItem(parent, (DiscoveryResources)this.getResources(), this.shellProvider, catalogItem, this);
            }
        }
        return null;
    }

    private DiscoveryItem<CatalogItem> createDiscoveryItem(Composite parent, CatalogItem catalogItem) {
        if (this.discoveryItemFactory != null) {
            return this.discoveryItemFactory.createDiscoveryItem(catalogItem, this, parent, this.getResources(), this.shellProvider, this.browser);
        }
        return new DiscoveryItem<CatalogItem>(parent, 0, this.getResources(), this.browser, catalogItem, this);
    }

    public void show(Set<? extends INode> nodes) {
        ContentType newContentType = ContentType.SEARCH;
        ContentType oldContentType = this.contentType;
        this.contentType = newContentType;
        this.fireContentTypeChange(oldContentType, newContentType);
        this.doQuery(new QueryData(), nodes);
    }

    public void search(String query) {
        this.search(this.getQueryMarket(), this.getQueryCategory(), query);
    }

    public void search(IMarket market, ICategory category, String query) {
        final QueryData queryData = new QueryData(market, category, query);
        this.setFilters(queryData);
        this.queryData = queryData;
        this.updateContent(this.contentType, new Runnable(){

            public void run() {
                MarketplaceViewer.this.doQuery(queryData, null);
            }
        });
    }

    private void setFilters(QueryData queryData) {
        this.setFindText(queryData.queryText == null ? "" : queryData.queryText);
        for (CatalogFilter filter : this.getConfiguration().getFilters()) {
            Tag tag;
            AbstractTagFilter tagFilter;
            if (!(filter instanceof AbstractTagFilter) || (tagFilter = (AbstractTagFilter)filter).getTagClassification() != ICategory.class) continue;
            List<Tag> choices = tagFilter.getChoices();
            Tag tag2 = tag = choices.isEmpty() ? null : choices.get(0);
            if (tag == null) continue;
            IMarket data = null;
            if (tag.getTagClassifier() == IMarket.class) {
                data = queryData.queryMarket;
            } else {
                if (tag.getTagClassifier() != ICategory.class) continue;
                data = queryData.queryCategory;
            }
            tag = null;
            if (data != null) {
                for (Tag choice : choices) {
                    Object choiceData = choice.getData();
                    if (choiceData != data && !MarketplaceViewer.matches((IIdentifiable)data, choiceData)) continue;
                    tag = choice;
                    break;
                }
            }
            tagFilter.setSelected(tag == null ? Collections.emptySet() : Collections.singleton(tag));
            tagFilter.updateUi();
        }
        this.initQueryFromFilters();
    }

    private static boolean matches(IIdentifiable data, Object tagData) {
        return tagData instanceof IIdentifiable && Identifiable.matches((IIdentifiable)((IIdentifiable)tagData), (IIdentifiable)data);
    }

    public void reload() {
        this.updateContent(this.contentType, new Runnable(){

            public void run() {
                MarketplaceViewer.this.doQuery();
            }
        });
    }

    private IStatus doQuery() {
        this.initQueryFromFilters();
        return this.doQuery(this.queryData, null);
    }

    private void initQueryFromFilters() {
        this.queryData = new QueryData();
        this.findText = this.getFilterText();
        AbstractTagFilter marketFilter = null;
        for (CatalogFilter filter : this.getConfiguration().getFilters()) {
            Tag tag;
            AbstractTagFilter tagFilter;
            if (!(filter instanceof AbstractTagFilter) || (tagFilter = (AbstractTagFilter)filter).getTagClassification() != ICategory.class) continue;
            Tag tag2 = tag = tagFilter.getSelected().isEmpty() ? null : tagFilter.getSelected().iterator().next();
            if (tag == null) continue;
            if (tag.getTagClassifier() == IMarket.class) {
                marketFilter = tagFilter;
                this.queryData.queryMarket = (IMarket)tag.getData();
                continue;
            }
            if (tag.getTagClassifier() != ICategory.class) continue;
            this.queryData.queryCategory = (ICategory)tag.getData();
        }
        if (marketFilter != null) {
            this.setFilterEnabled(marketFilter, this.contentType != ContentType.FEATURED_MARKET);
        }
        this.queryData.queryText = this.findText;
    }

    private void setFilterEnabled(MarketplaceFilter filter, boolean enabled) {
        if (this.header != null) {
            Control[] children;
            Control[] controlArray = children = this.header.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                if (control.getData() == filter) {
                    control.setEnabled(enabled);
                }
                ++n2;
            }
        }
    }

    public void doQueryForTag(final String tag) {
        this.updateContent(ContentType.SEARCH, new Runnable(){

            public void run() {
                MarketplaceViewer.this.queryData = new QueryData();
                ((MarketplaceViewer)MarketplaceViewer.this).queryData.queryText = MarketplaceViewer.QUERY_TAG_KEYWORD + tag;
                MarketplaceViewer.this.setFilters(MarketplaceViewer.this.queryData);
                MarketplaceViewer.this.doQuery();
            }
        });
    }

    private void setFindText(String tag) {
        try {
            Field filterTextField = FilteredViewer.class.getDeclaredField("filterText");
            filterTextField.setAccessible(true);
            TextSearchControl textSearchControl = (TextSearchControl)filterTextField.get((Object)this);
            textSearchControl.getTextControl().setText(tag);
        }
        catch (Exception e) {
            MarketplaceClientUi.log(2, Messages.MarketplaceViewer_Could_not_change_find_text, e);
        }
    }

    private void fireContentTypeChange(ContentType oldValue, ContentType newValue) {
        MarketplaceViewer source = this;
        String property = CONTENT_TYPE_PROPERTY;
        this.firePropertyChangeEvent(new PropertyChangeEvent((Object)source, property, (Object)oldValue, (Object)newValue));
    }

    protected IStatus refreshFavorites() {
        IStatus status;
        try {
            final IStatus[] result = new IStatus[1];
            this.context.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    result[0] = MarketplaceViewer.this.getCatalog().refreshUserFavorites(monitor);
                }
            });
            status = result[0];
        }
        catch (InvocationTargetException e) {
            status = this.computeStatus(e, Messages.MarketplaceViewer_unexpectedException);
        }
        catch (InterruptedException interruptedException) {
            status = Status.CANCEL_STATUS;
        }
        if (status != null && !status.isOK() && status.getSeverity() != 8) {
            MarketplaceClientUi.handle(status, 7);
        }
        return status;
    }

    private IStatus doQuery(final QueryData queryData, final Set<? extends INode> nodes) {
        try {
            ContentType queryType;
            this.queryContentType = queryType = this.contentType;
            final IStatus[] result = new IStatus[1];
            this.context.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    switch (queryType) {
                        case POPULAR: {
                            result[0] = MarketplaceViewer.this.getCatalog().popular(monitor);
                            break;
                        }
                        case RECENT: {
                            result[0] = MarketplaceViewer.this.getCatalog().recent(monitor);
                            break;
                        }
                        case RELATED: {
                            result[0] = MarketplaceViewer.this.getCatalog().related(monitor);
                            break;
                        }
                        case INSTALLED: {
                            result[0] = MarketplaceViewer.this.getCatalog().installed(monitor);
                            break;
                        }
                        case FAVORITES: {
                            result[0] = MarketplaceViewer.this.getCatalog().userFavorites(false, monitor);
                            break;
                        }
                        case SELECTION: {
                            HashSet<String> nodeIds = new HashSet<String>();
                            for (CatalogItem item : MarketplaceViewer.this.getSelectionModel().getItemToSelectedOperation().keySet()) {
                                nodeIds.add(((INode)item.getData()).getId());
                            }
                            result[0] = MarketplaceViewer.this.getCatalog().performQuery(monitor, nodeIds);
                            break;
                        }
                        default: {
                            if (nodes != null && !nodes.isEmpty()) {
                                result[0] = MarketplaceViewer.this.getCatalog().performNodeQuery(monitor, nodes);
                                break;
                            }
                            if (queryData.queryText != null && queryData.queryText.length() > 0) {
                                String tag = MarketplaceViewer.this.getTagQuery(queryData.queryText);
                                if (tag != null) {
                                    result[0] = MarketplaceViewer.this.getCatalog().tagged(tag, monitor);
                                    break;
                                }
                                result[0] = MarketplaceViewer.this.getCatalog().performQuery(queryData.queryMarket, queryData.queryCategory, queryData.queryText, monitor);
                                break;
                            }
                            result[0] = MarketplaceViewer.this.getCatalog().featured(monitor, queryData.queryMarket, queryData.queryCategory);
                        }
                    }
                    if (!monitor.isCanceled() && result[0] != null && result[0].getSeverity() != 8) {
                        MarketplaceViewer.this.getCatalog().checkForUpdates(monitor);
                    }
                    MarketplaceViewer.this.getControl().getDisplay().syncExec(new Runnable(){

                        public void run() {
                            MarketplaceViewer.this.updateViewer(queryData.queryText);
                        }
                    });
                }
            });
            if (result[0] != null && !result[0].isOK() && result[0].getSeverity() != 8) {
                MarketplaceClientUi.handle(result[0], (result[0].getSeverity() > 2 ? 6 : 0) | 1);
                return result[0];
            }
            this.verifyUpdateSiteAvailability();
            return Status.OK_STATUS;
        }
        catch (InvocationTargetException e) {
            IStatus status = this.computeStatus(e, Messages.MarketplaceViewer_unexpectedException);
            MarketplaceClientUi.handle(status, 7);
            return status;
        }
        catch (InterruptedException interruptedException) {
            return Status.CANCEL_STATUS;
        }
    }

    private String getTagQuery(String queryText) {
        String tag;
        if (queryText != null && queryText.toLowerCase().startsWith(QUERY_TAG_KEYWORD) && (tag = queryText.substring(QUERY_TAG_KEYWORD.length()).trim()).length() > 0) {
            return tag;
        }
        return null;
    }

    private void updateViewer(final String queryText) {
        this.runUpdate(new Runnable(){

            public void run() {
                if (MarketplaceViewer.this.contentType == ContentType.INSTALLED) {
                    MarketplaceViewer.this.getViewer().setSorter((ViewerSorter)new MarketplaceViewerSorter());
                } else {
                    MarketplaceViewer.this.getViewer().setSorter(null);
                }
                MarketplaceViewer.super.doFind(queryText);
                MarketplaceViewer.this.getViewer().getControl().getParent().layout(true, true);
            }
        });
    }

    private void runUpdate(Runnable r) {
        if (this.getViewer().getControl().isDisposed()) {
            return;
        }
        if (this.inUpdate) {
            r.run();
            return;
        }
        this.inUpdate = true;
        this.getViewer().getControl().setRedraw(false);
        try {
            r.run();
        }
        finally {
            this.inUpdate = false;
            this.getViewer().getControl().setRedraw(true);
        }
    }

    public void showSelected() {
        this.contentType = ContentType.SELECTION;
        this.queryData = new QueryData();
        this.findText = null;
        this.runUpdate(new Runnable(){

            public void run() {
                MarketplaceViewer.this.setHeaderVisible(true);
                MarketplaceViewer.this.doQuery(new QueryData(null, null, MarketplaceViewer.this.findText), null);
            }
        });
        this.contentType = ContentType.SEARCH;
    }

    public void updateContents() {
        this.doSetContentType(this.contentType);
    }

    public MarketplaceCatalogConfiguration getConfiguration() {
        return (MarketplaceCatalogConfiguration)super.getConfiguration();
    }

    public MarketplaceCatalog getCatalog() {
        return (MarketplaceCatalog)super.getCatalog();
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    protected PatternFilter doCreateFilter() {
        return new MarketplacePatternFilter();
    }

    public void setContentType(ContentType contentType) {
        if (this.contentType != contentType) {
            this.doSetContentType(contentType);
        }
    }

    private void doSetContentType(ContentType contentType) {
        final ContentType oldContentType = this.contentType;
        this.updateContent(contentType, new Runnable(){

            public void run() {
                IStatus status = MarketplaceViewer.this.doQuery();
                if (status.getSeverity() == 8 || status.getSeverity() >= 4) {
                    MarketplaceViewer.this.setContentType(oldContentType);
                }
            }
        });
    }

    private void updateContent(final ContentType contentType, final Runnable queryCall) {
        ContentType queryType;
        final ContentType oldContentType = this.contentType;
        this.contentType = contentType;
        boolean hadQuery = this.showQueryHeader(oldContentType);
        final boolean hasQuery = this.showQueryHeader(contentType);
        ContentType oldQueryType = oldContentType;
        if (oldQueryType == ContentType.SELECTION) {
            oldQueryType = ContentType.SEARCH;
        }
        if ((queryType = contentType) == ContentType.SELECTION) {
            queryType = ContentType.SEARCH;
        }
        if (oldQueryType != queryType || hasQuery != hadQuery) {
            if (hadQuery) {
                this.initQueryFromFilters();
                this.tabQueries.put(oldQueryType, this.queryData);
            }
            if (hasQuery) {
                QueryData newQueryData = this.tabQueries.get((Object)queryType);
                if (newQueryData == null) {
                    String marketName;
                    boolean hasFeaturedMarketTab;
                    CatalogDescriptor catalogDescriptor;
                    ICatalogBranding catalogBranding;
                    newQueryData = new QueryData();
                    if (queryType == ContentType.FEATURED_MARKET && (catalogBranding = (catalogDescriptor = this.getWizard().getConfiguration().getCatalogDescriptor()).getCatalogBranding()) != null && (hasFeaturedMarketTab = catalogBranding.hasFeaturedMarketTab()) && (marketName = catalogBranding.getFeaturedMarketTabName()) != null) {
                        block0: for (CatalogFilter filter : this.getConfiguration().getFilters()) {
                            AbstractTagFilter tagFilter;
                            if (!(filter instanceof AbstractTagFilter) || (tagFilter = (AbstractTagFilter)filter).getTagClassification() != ICategory.class) continue;
                            for (Tag tag : tagFilter.getChoices()) {
                                if (tag.getTagClassifier() != IMarket.class) continue block0;
                                IMarket market = (IMarket)tag.getData();
                                if (!marketName.equals(market.getName())) continue;
                                newQueryData.queryMarket = market;
                                continue block0;
                            }
                        }
                        if (newQueryData.queryMarket == null) {
                            this.setContentType(oldContentType);
                            return;
                        }
                    }
                    this.tabQueries.put(queryType, newQueryData);
                }
                this.setFilters(newQueryData);
            }
        }
        this.runUpdate(new Runnable(){

            public void run() {
                MarketplaceViewer.this.fireContentTypeChange(oldContentType, contentType);
                MarketplaceViewer.this.setHeaderVisible(hasQuery);
                queryCall.run();
            }
        });
    }

    private boolean showQueryHeader(ContentType contentType) {
        return contentType == ContentType.SEARCH || contentType == ContentType.SELECTION || contentType == ContentType.FEATURED_MARKET;
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void firePropertyChangeEvent(PropertyChangeEvent event) {
        for (IPropertyChangeListener listener : this.listeners) {
            listener.propertyChange(event);
        }
    }

    public void setHeaderVisible(final boolean visible) {
        if (visible != this.isHeaderVisible()) {
            this.runUpdate(new Runnable(){

                public void run() {
                    if (!visible) {
                        MarketplaceViewer.this.filters = MarketplaceViewer.this.getViewer().getFilters();
                        MarketplaceViewer.this.getViewer().resetFilters();
                    } else if (MarketplaceViewer.this.filters != null) {
                        MarketplaceViewer.this.getViewer().setFilters(MarketplaceViewer.this.filters);
                        MarketplaceViewer.this.filters = null;
                    }
                    MarketplaceViewer.super.setHeaderVisible(visible);
                }
            });
        }
    }

    protected boolean doFilter(CatalogItem item) {
        return true;
    }

    protected StructuredViewer doCreateViewer(Composite container) {
        ServiceReference serviceReference = null;
        final BundleContext bundleContext = MarketplaceClientUiPlugin.getInstance().getBundle().getBundleContext();
        try {
            serviceReference = bundleContext.getServiceReference(IDiscoveryItemFactory.class);
            if (serviceReference != null) {
                this.discoveryItemFactory = (IDiscoveryItemFactory)bundleContext.getService(serviceReference);
            }
        }
        catch (Exception ex) {
            MarketplaceClientUi.error(ex);
        }
        StructuredViewer viewer = super.doCreateViewer(container);
        this.discoveryResources = new MarketplaceDiscoveryResources(container.getDisplay());
        viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                MarketplaceViewer.this.discoveryResources.dispose();
            }
        });
        super.getResources().dispose();
        viewer.setSorter(null);
        if (serviceReference != null) {
            final ServiceReference ref = serviceReference;
            viewer.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    bundleContext.ungetService(ref);
                }
            });
        }
        return viewer;
    }

    protected void modifySelection(CatalogItem connector, boolean selected) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected void modifySelection(CatalogItem connector, Operation operation) {
        this.modifySelection(connector, operation == null ? null : operation.getOperation());
    }

    protected void modifySelection(CatalogItem connector, org.eclipse.epp.mpc.ui.Operation operation) {
        if (operation == null) {
            throw new IllegalArgumentException();
        }
        org.eclipse.epp.mpc.ui.Operation selectedOperation = this.selectionModel.getSelectedOperation(connector);
        this.selectionModel.select(connector, operation);
        super.modifySelection(connector, operation != org.eclipse.epp.mpc.ui.Operation.NONE);
        if (selectedOperation != operation) {
            this.getViewer().refresh((Object)connector);
        }
    }

    protected void postDiscovery() {
    }

    public void updateCatalog() {
        if (this.getWizard().wantInitializeInitialSelection()) {
            try {
                this.getWizard().initializeInitialSelection();
                MarketplaceWizard.WizardState initialState = this.getWizard().getInitialState();
                if (initialState != null) {
                    this.getWizard().getCatalogPage().initialize(initialState);
                }
                this.catalogUpdated(false, false);
            }
            catch (CoreException e) {
                boolean wasCancelled;
                boolean bl = wasCancelled = e.getStatus().getSeverity() == 8;
                if (!wasCancelled) {
                    MarketplaceClientUi.handle(e.getStatus(), 7);
                }
                this.catalogUpdated(wasCancelled, !wasCancelled);
            }
        } else {
            super.updateCatalog();
        }
        this.refresh();
    }

    protected IStatus computeStatus(InvocationTargetException e, String message) {
        return MarketplaceClientCore.computeStatus((Throwable)e, (String)message);
    }

    protected MarketplaceWizard getWizard() {
        return this.wizard;
    }

    public List<CatalogItem> getCheckedItems() {
        ArrayList<CatalogItem> items = new ArrayList<CatalogItem>();
        for (Map.Entry<CatalogItem, org.eclipse.epp.mpc.ui.Operation> entry : this.getSelectionModel().getItemToSelectedOperation().entrySet()) {
            if (entry.getValue() == org.eclipse.epp.mpc.ui.Operation.NONE) continue;
            items.add(entry.getKey());
        }
        return items;
    }

    public IStructuredSelection getSelection() {
        return new StructuredSelection(this.getCheckedItems());
    }

    public SelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public String getQueryText() {
        return this.queryData.queryText;
    }

    public ICategory getQueryCategory() {
        return this.queryData.queryCategory;
    }

    public IMarket getQueryMarket() {
        return this.queryData.queryMarket;
    }

    ContentType getQueryContentType() {
        return this.queryContentType;
    }

    protected Set<String> getInstalledFeatures(IProgressMonitor monitor) {
        return MarketplaceClientUi.computeInstalledFeatures(monitor);
    }

    public void refresh() {
        this.runUpdate(new Runnable(){

            public void run() {
                MarketplaceViewer.super.refresh();
            }
        });
    }

    protected static void fixLayout(CategoryItem<?> categoryItem) {
        CatalogCategory category = (CatalogCategory)categoryItem.getData();
        boolean hasDescription = category.getDescription() != null;
        int valignTitle = hasDescription ? 1 : 0x1000000;
        int totalRows = hasDescription ? 2 : 1;
        Control[] children = categoryItem.getChildren();
        Composite categoryHeaderContainer = (Composite)children[0];
        GridLayoutFactory.fillDefaults().numColumns(3).margins(5, hasDescription ? 5 : 10).equalWidth(false).applyTo(categoryHeaderContainer);
        Control[] headerChildren = categoryHeaderContainer.getChildren();
        Control iconLabel = headerChildren[0];
        Control nameLabel = headerChildren[1];
        Control tooltip = headerChildren[2];
        GridDataFactory.swtDefaults().align(0x1000000, valignTitle).span(1, totalRows).applyTo(iconLabel);
        GridDataFactory.fillDefaults().grab(true, false).align(1, valignTitle).applyTo(nameLabel);
        if (tooltip instanceof Label) {
            GridDataFactory.fillDefaults().align(0x1000008, valignTitle).applyTo(tooltip);
        }
    }

    protected static void setSeparatorVisible(CategoryItem<?> categoryItem, boolean visible) {
        Control childControl = categoryItem.getChildren()[0];
        if (childControl instanceof GradientCanvas) {
            GradientCanvas canvas = (GradientCanvas)childControl;
            canvas.setSeparatorVisible(visible);
        }
    }

    public void reveal(Object item) {
        this.viewer.reveal(item);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContentType {
        SEARCH,
        FEATURED_MARKET,
        RECENT,
        POPULAR,
        INSTALLED,
        SELECTION,
        RELATED,
        FAVORITES;

    }

    public static class MarketplaceCatalogContentProvider
    extends CatalogViewer.CatalogContentProvider {
        private static final Object[] NO_ELEMENTS = new Object[0];

        public Catalog getCatalog() {
            return super.getCatalog();
        }

        public Object[] getElements(Object inputElement) {
            if (this.getCatalog() != null) {
                ArrayList<CatalogCategory> items = new ArrayList<CatalogCategory>(this.getCatalog().getItems());
                for (CatalogCategory category : this.getCatalog().getCategories()) {
                    MarketplaceCategory marketplaceCategory;
                    if (!(category instanceof MarketplaceCategory) || (marketplaceCategory = (MarketplaceCategory)category).getContents() != MarketplaceCategory.Contents.FEATURED) continue;
                    items.add(0, category);
                }
                return items.toArray();
            }
            return NO_ELEMENTS;
        }
    }

    private static class QueryData {
        public String queryText;
        public IMarket queryMarket;
        public ICategory queryCategory;

        public QueryData() {
        }

        public QueryData(IMarket queryMarket, ICategory queryCategory, String queryText) {
            this.queryMarket = queryMarket;
            this.queryCategory = queryCategory;
            this.queryText = queryText;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.queryCategory == null ? 0 : this.queryCategory.hashCode());
            result = 31 * result + (this.queryMarket == null ? 0 : this.queryMarket.hashCode());
            result = 31 * result + (this.queryText == null ? 0 : this.queryText.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QueryData other = (QueryData)obj;
            if (this.queryCategory == null ? other.queryCategory != null : !this.queryCategory.equals(other.queryCategory)) {
                return false;
            }
            if (this.queryMarket == null ? other.queryMarket != null : !this.queryMarket.equals(other.queryMarket)) {
                return false;
            }
            return !(this.queryText == null ? other.queryText != null : !this.queryText.equals(other.queryText));
        }
    }
}

