/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.epp.internal.mpc.ui.catalog.UserActionCatalogItem;
import org.eclipse.epp.internal.mpc.ui.wizards.ActionLink;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.UserActionViewerItem;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryResources;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUserActionLinksItem
extends UserActionViewerItem<UserActionCatalogItem> {
    private final Map<String, ActionLink> actions = new HashMap<String, ActionLink>();

    public AbstractUserActionLinksItem(Composite parent, DiscoveryResources resources, IShellProvider shellProvider, UserActionCatalogItem element, MarketplaceViewer viewer) {
        super(parent, resources, shellProvider, element, viewer);
    }

    protected void createContent(ActionLink ... actionLinks) {
        AbstractUserActionLinksItem parent = this;
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo((Composite)parent);
        int vAlignLinks = 0x1000000;
        String descriptionText = this.getDescriptionText();
        if (descriptionText != null) {
            Label descriptionLabel = new Label((Composite)parent, 0x1000000);
            descriptionLabel.setText(descriptionText);
            GridDataFactory.swtDefaults().grab(true, false).align(0x1000000, 0x1000008).applyTo((Control)descriptionLabel);
            vAlignLinks = 1;
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                Object data = event.data;
                if (data == null && (data = event.text) == null) {
                    data = event.widget.getData();
                }
                AbstractUserActionLinksItem.this.actionPerformed(data);
            }
        };
        Composite linkParent = new Composite((Composite)parent, 0);
        GridDataFactory.swtDefaults().grab(true, false).align(0x1000000, vAlignLinks).applyTo((Control)linkParent);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo(linkParent);
        boolean first = true;
        ActionLink[] actionLinkArray = actionLinks;
        int n = actionLinks.length;
        int n2 = 0;
        while (n2 < n) {
            ActionLink actionLink = actionLinkArray[n2];
            this.actions.put(actionLink.getId(), actionLink);
            if (first) {
                first = false;
            } else {
                Label separator = new Label(linkParent, 0x1000000);
                separator.setText(" | ");
                GridDataFactory.swtDefaults().align(0x1000000, vAlignLinks).applyTo((Control)separator);
            }
            String linkText = this.getLinkText(actionLink);
            String tooltip = actionLink.getTooltip();
            if (tooltip == null) {
                tooltip = this.getLinkToolTipText();
            }
            Control link = this.createActionLink(linkParent, linkText, tooltip);
            link.setData((Object)actionLink.getId());
            link.addListener(13, listener);
            GridDataFactory.swtDefaults().align(0x1000008, vAlignLinks).applyTo(link);
            ++n2;
        }
    }

    private String getLinkText(ActionLink actionLink) {
        return MessageFormat.format("<a href=\"{0}\">{1}</a>", actionLink.getId(), actionLink.getLabel());
    }

    protected String getDescriptionText() {
        return null;
    }

    @Override
    protected String getLinkText() {
        return null;
    }

    @Override
    protected void actionPerformed(Object data) {
        ActionLink actionLink = this.actions.get(data);
        if (actionLink != null) {
            actionLink.selected();
        }
    }
}

