/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.wizards;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.internal.tasks.ui.wizards.Messages;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewWebTaskPage;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewWebTaskWizard
extends Wizard
implements INewWizard {
    protected TaskRepository taskRepository;
    protected String newTaskUrl;
    private final ITaskMapping taskSelection;

    public NewWebTaskWizard(TaskRepository taskRepository, String newTaskUrl, ITaskMapping taskSelection) {
        this.taskRepository = taskRepository;
        this.newTaskUrl = newTaskUrl;
        this.taskSelection = taskSelection;
        this.setWindowTitle(Messages.NewWebTaskWizard_New_Task);
        this.setDefaultPageImageDescriptor(TasksUiImages.BANNER_REPOSITORY);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.addPage((IWizardPage)new NewWebTaskPage(this.taskSelection));
    }

    public boolean canFinish() {
        return true;
    }

    public boolean performFinish() {
        this.handleSelection(this.taskSelection);
        TasksUiUtil.openUrl(this.newTaskUrl);
        return true;
    }

    private void handleSelection(ITaskMapping taskSelection) {
        if (taskSelection == null) {
            return;
        }
        String summary = taskSelection.getSummary();
        String description = taskSelection.getDescription();
        Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
        clipboard.setContents(new Object[]{String.valueOf(summary) + "\n" + description}, new Transfer[]{TextTransfer.getInstance()});
        MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.NewWebTaskWizard_New_Task, (String)Messages.NewWebTaskWizard_This_connector_does_not_provide_a_rich_task_editor_for_creating_tasks);
    }
}

