/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.kernel.ui.criticalpath;

import org.eclipse.tracecompass.analysis.graph.core.criticalpath.CriticalPathModule;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.os.linux.core.signals.TmfThreadSelectedSignal;
import org.eclipse.tracecompass.internal.lttng2.kernel.core.analysis.graph.model.LttngWorker;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisParamProvider;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class CriticalPathParameterProvider
extends TmfAbstractAnalysisParamProvider {
    private static final String NAME = "Critical Path Lttng kernel parameter provider";
    private HostThread fCurrentHostThread = null;

    public CriticalPathParameterProvider() {
        TmfSignalManager.register((Object)((Object)this));
    }

    public String getName() {
        return NAME;
    }

    public Object getParameter(String name) {
        if (name.equals("workerid")) {
            HostThread currentHostThread = this.fCurrentHostThread;
            if (currentHostThread == null) {
                return null;
            }
            IAnalysisModule mod = this.getModule();
            if (mod != null && mod instanceof CriticalPathModule) {
                LttngWorker worker = new LttngWorker(currentHostThread, "", 0L);
                return worker;
            }
        }
        return null;
    }

    public boolean appliesToTrace(ITmfTrace trace) {
        return true;
    }

    private void setCurrentHostThread(HostThread hostThread) {
        if (!hostThread.equals((Object)this.fCurrentHostThread)) {
            this.fCurrentHostThread = hostThread;
            this.notifyParameterChanged("workerid");
        }
    }

    @TmfSignalHandler
    public void tmfThreadSelectedSignalHander(TmfThreadSelectedSignal signal) {
        TmfThreadSelectedSignal threadSignal = signal;
        if (threadSignal != null) {
            this.setCurrentHostThread(new HostThread(threadSignal.getTraceHost(), Integer.valueOf(threadSignal.getThreadId())));
        }
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        this.fCurrentHostThread = null;
    }
}

