/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.analysis;

import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisManager;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAbstractAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.osgi.framework.Bundle;

public class TmfAnalysisModuleHelperConfigElement
implements IAnalysisModuleHelper {
    private final IConfigurationElement fCe;

    public TmfAnalysisModuleHelperConfigElement(IConfigurationElement ce) {
        this.fCe = ce;
    }

    @Override
    public String getId() {
        String id = this.fCe.getAttribute("id");
        if (id == null) {
            throw new IllegalStateException();
        }
        return id;
    }

    @Override
    public String getName() {
        String name = this.fCe.getAttribute("name");
        if (name == null) {
            throw new IllegalStateException();
        }
        return name;
    }

    @Override
    public boolean isAutomatic() {
        return Boolean.parseBoolean(this.fCe.getAttribute("automatic"));
    }

    @Override
    public boolean appliesToExperiment() {
        return Boolean.parseBoolean(this.fCe.getAttribute("applies_experiment"));
    }

    @Override
    public String getHelpText() {
        return "The trace must be opened to get the help message";
    }

    @Override
    public String getIcon() {
        return this.fCe.getAttribute("icon");
    }

    @Override
    public Bundle getBundle() {
        return ContributorFactoryOSGi.resolve((IContributor)this.fCe.getContributor());
    }

    private boolean appliesToTraceClass(Class<? extends ITmfTrace> traceclass) {
        IConfigurationElement[] tracetypeCE;
        boolean applies = false;
        IConfigurationElement[] iConfigurationElementArray = tracetypeCE = this.fCe.getChildren("tracetype");
        int n = tracetypeCE.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                Class applyclass = this.getBundle().loadClass(element.getAttribute("class"));
                String classAppliesVal = element.getAttribute("applies");
                boolean classApplies = true;
                if (classAppliesVal != null) {
                    classApplies = Boolean.parseBoolean(classAppliesVal);
                }
                if (classApplies) {
                    applies |= applyclass.isAssignableFrom(traceclass);
                } else if (applyclass.isAssignableFrom(traceclass)) {
                    applies = false;
                }
            }
            catch (ClassNotFoundException | InvalidRegistryObjectException e) {
                Activator.logError("Error in applies to trace", e);
            }
            ++n2;
        }
        return applies;
    }

    @Override
    public boolean appliesToTraceType(Class<? extends ITmfTrace> traceclass) {
        boolean applies = this.appliesToTraceClass(traceclass);
        if (!applies && TmfExperiment.class.isAssignableFrom(traceclass)) {
            applies = this.appliesToExperiment();
        }
        return applies;
    }

    @Override
    public Iterable<Class<? extends ITmfTrace>> getValidTraceTypes() {
        HashSet<Class<? extends ITmfTrace>> traceTypes = new HashSet<Class<? extends ITmfTrace>>();
        for (TraceTypeHelper tth : TmfTraceType.getTraceTypeHelpers()) {
            if (!this.appliesToTraceType(tth.getTraceClass())) continue;
            traceTypes.add(tth.getTraceClass());
        }
        return traceTypes;
    }

    @Override
    public Iterable<TmfAbstractAnalysisRequirement> getAnalysisRequirements() {
        IAnalysisModule module = this.createModule();
        if (module != null) {
            return module.getAnalysisRequirements();
        }
        return Collections.EMPTY_SET;
    }

    private IAnalysisModule createModule() {
        IAnalysisModule module = null;
        try {
            module = (IAnalysisModule)this.fCe.createExecutableExtension("analysis_module");
            module.setName(this.getName());
            module.setId(this.getId());
        }
        catch (CoreException e) {
            Activator.logError("Error getting analysis modules from configuration files", e);
        }
        return module;
    }

    @Override
    public IAnalysisModule newModule(ITmfTrace trace) throws TmfAnalysisException {
        IConfigurationElement[] parametersCE;
        boolean applies = this.appliesToTraceClass(trace.getClass());
        if (!applies && trace instanceof TmfExperiment && this.appliesToExperiment()) {
            for (ITmfTrace expTrace : TmfTraceManager.getTraceSet(trace)) {
                if (!this.appliesToTraceClass(expTrace.getClass())) continue;
                applies = true;
                break;
            }
        }
        if (!applies) {
            return null;
        }
        IAnalysisModule module = this.createModule();
        if (module == null) {
            return null;
        }
        module.setAutomatic(this.isAutomatic());
        IConfigurationElement[] iConfigurationElementArray = parametersCE = this.fCe.getChildren("parameter");
        int n = parametersCE.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String paramName = element.getAttribute("name");
            if (paramName != null) {
                module.addParameter(paramName);
                String defaultValue = element.getAttribute("default_value");
                if (defaultValue != null) {
                    module.setParameter(paramName, defaultValue);
                }
            }
            ++n2;
        }
        if (module.setTrace(trace)) {
            TmfAnalysisManager.analysisModuleCreated(module);
        } else {
            module.dispose();
            module = null;
        }
        return module;
    }

    @Override
    public String getHelpText(@NonNull ITmfTrace trace) {
        IAnalysisModule module = this.createModule();
        if (module != null) {
            String ret = module.getHelpText(trace);
            module.dispose();
            return ret;
        }
        return this.getHelpText();
    }
}

