/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.graph.core.building;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.base.TmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.building.ITmfGraphProvider;
import org.eclipse.tracecompass.analysis.graph.core.building.ITraceEventHandler;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class AbstractTmfGraphProvider
implements ITmfGraphProvider {
    private final ITmfTrace fTrace;
    private final List<ITraceEventHandler> fHandlers;
    private boolean fGraphAssigned;
    private @Nullable TmfGraph fGraph = null;

    public AbstractTmfGraphProvider(ITmfTrace trace, String id) {
        this.fTrace = trace;
        this.fGraphAssigned = false;
        this.fHandlers = new ArrayList<ITraceEventHandler>();
    }

    @Override
    public ITmfTrace getTrace() {
        return this.fTrace;
    }

    @Override
    public long getStartTime() {
        return this.fTrace.getStartTime().toNanos();
    }

    @Override
    public void assignTargetGraph(TmfGraph graph) {
        this.fGraph = graph;
        this.fGraphAssigned = true;
    }

    @Override
    public @Nullable TmfGraph getAssignedGraph() {
        return this.fGraph;
    }

    @Override
    public void processEvent(ITmfEvent event) {
        if (!this.fGraphAssigned) {
            return;
        }
        this.eventHandle(event);
    }

    @Override
    public void dispose() {
        this.fGraphAssigned = false;
        this.fGraph = null;
    }

    @Override
    public void done() {
    }

    protected void eventHandle(ITmfEvent event) {
        for (ITraceEventHandler handler : this.fHandlers) {
            handler.handleEvent(event);
        }
    }

    @Override
    public void handleCancel() {
    }

    public void registerHandler(ITraceEventHandler handler) {
        this.fHandlers.add(handler);
    }
}

