/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.editors.automake;

import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.MessageLine;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.StatusTool;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;

public abstract class SelectionStatusDialog
extends SelectionDialog {
    private MessageLine fStatusLine;
    private IStatus fLastStatus;
    private Image fImage;
    private boolean fInitialSelectionSet = false;
    private boolean fStatusLineAboveButtons = false;

    protected abstract void computeResult();

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.fImage != null) {
            shell.setImage(this.fImage);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        if (this.fStatusLineAboveButtons) {
            layout.verticalSpacing = 0;
        } else {
            layout.numColumns = 2;
        }
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.fStatusLine = new MessageLine(composite);
        this.fStatusLine.setAlignment(16384);
        this.fStatusLine.setLayoutData(new GridData(768));
        this.fStatusLine.setMessage("");
        super.createButtonBar(composite);
        return composite;
    }

    public void create() {
        super.create();
        if (this.fLastStatus != null) {
            this.updateStatus(this.fLastStatus);
        }
    }

    protected Object getPrimaryInitialSelection() {
        List result = this.getInitialElementSelections();
        if (result == null || result.size() == 0) {
            return null;
        }
        return result.get(0);
    }

    public Object getPrimaryResult() {
        Object[] result = this.getResult();
        if (result == null || result.length == 0) {
            return null;
        }
        return result[0];
    }

    public SelectionStatusDialog(Shell parent) {
        super(parent);
    }

    protected void okPressed() {
        this.computeResult();
        super.okPressed();
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    protected void setInitialSelection(int position, Object element) {
        List l = this.getInitialElementSelections();
        l.set(position, element);
        this.fInitialSelectionSet = true;
    }

    public void setInitialSelection(Object element) {
        if (this.fInitialSelectionSet && element != null && element.equals("A")) {
            return;
        }
        if (element != null) {
            this.setInitialSelections(new Object[]{element});
        } else {
            this.setInitialSelections(new Object[0]);
        }
    }

    public void setInitialSelections(Object[] selectedElements) {
        super.setInitialSelections(selectedElements);
        this.fInitialSelectionSet = true;
    }

    protected void setResult(int position, Object element) {
        Object[] result = this.getResult();
        result[position] = element;
        this.setResult(Arrays.asList(result));
    }

    public void setStatusLineAboveButtons(boolean aboveButtons) {
        this.fStatusLineAboveButtons = aboveButtons;
    }

    protected void updateButtonsEnableState(IStatus status) {
        Button okButton = this.getOkButton();
        if (okButton != null && !okButton.isDisposed()) {
            okButton.setEnabled(!status.matches(4));
        }
    }

    protected void updateStatus(IStatus status) {
        this.fLastStatus = status;
        if (this.fStatusLine != null && !this.fStatusLine.isDisposed()) {
            this.updateButtonsEnableState(status);
            StatusTool.applyToStatusLine(this.fStatusLine, status);
        }
    }
}

