/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.profiling.launch;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.linuxtools.internal.profiling.launch.Messages;
import org.eclipse.linuxtools.internal.profiling.launch.provider.launch.ProviderFramework;
import org.eclipse.linuxtools.internal.profiling.launch.provider.launch.ProviderLaunchShortcut;
import org.eclipse.linuxtools.profiling.launch.ProfileLaunchConfigurationTabGroup;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractProfilingOptionsTab
extends AbstractLaunchConfigurationTab {
    private String type;
    private String name;
    private String id;
    private Composite top;
    private Combo providerCombo;
    private AbstractLaunchConfigurationTab[] tabs;
    private ILaunchConfiguration initial;
    private Map<String, String> comboItems;
    private CTabFolder tabgroup;
    protected Image img;
    private Map<String, Boolean> initialized = new HashMap<String, Boolean>();

    protected abstract Map<String, String> getProviders();

    public void createControl(Composite parent) {
        this.top = new Composite(parent, 0);
        this.setControl((Control)this.top);
        this.top.setLayout((Layout)new GridLayout(1, true));
        this.comboItems = this.getProviders();
        Set<String> providerNames = this.comboItems.keySet();
        this.providerCombo = new Combo(this.top, 8);
        this.providerCombo.setItems(providerNames.toArray(new String[0]));
        if (providerNames.size() == 0) {
            this.providerCombo.setVisible(false);
            this.providerCombo.setEnabled(false);
            Label label = new Label(this.top, 0);
            label.setText(Messages.ProfilingTab_no_category_profilers_installed);
        }
        this.tabgroup = new CTabFolder(this.top, 0);
        this.tabgroup.setLayoutData((Object)new GridData(4, 4, true, true));
        this.providerCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String curProviderId = (String)AbstractProfilingOptionsTab.this.comboItems.get(AbstractProfilingOptionsTab.this.providerCombo.getText());
                AbstractProfilingOptionsTab.this.loadTabGroupItems(AbstractProfilingOptionsTab.this.tabgroup, curProviderId);
                AbstractProfilingOptionsTab.this.initializeFrom(AbstractProfilingOptionsTab.this.initial);
                AbstractProfilingOptionsTab.this.updateLaunchConfigurationDialog();
                AbstractProfilingOptionsTab.this.top.layout();
            }
        });
    }

    protected abstract String getDefaultProviderId();

    private void loadTabGroupItems(CTabFolder tabgroup, String curProviderId) {
        CTabItem[] cTabItemArray = tabgroup.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            item.dispose();
            ++n2;
        }
        this.setErrorMessage(null);
        this.initialized.clear();
        if (curProviderId == null || curProviderId.isEmpty()) {
            curProviderId = this.getDefaultProviderId();
        }
        this.initialized.put(curProviderId, false);
        ProfileLaunchConfigurationTabGroup tabGroupConfig = ProviderFramework.getTabGroupProviderFromId(curProviderId);
        if (tabGroupConfig == null) {
            String profilingToolName = null;
            try {
                profilingToolName = this.initial.getAttribute("toolname", null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (profilingToolName == null) {
                this.setErrorMessage(NLS.bind((String)Messages.ProfilingTab_specified_providerid_not_installed, (Object)curProviderId));
            } else {
                this.setErrorMessage(NLS.bind((String)Messages.ProfilingTab_specified_profiler_not_installed, (Object)profilingToolName));
            }
            return;
        }
        this.tabs = tabGroupConfig.getProfileTabs();
        this.setProvider(curProviderId);
        int itemIndex = this.getComboItemIndexFromId(curProviderId);
        this.providerCombo.select(itemIndex);
        this.setConfigurationName(this.providerCombo.getText());
        AbstractLaunchConfigurationTab[] abstractLaunchConfigurationTabArray = this.tabs;
        int n3 = this.tabs.length;
        int n4 = 0;
        while (n4 < n3) {
            AbstractLaunchConfigurationTab tab = abstractLaunchConfigurationTabArray[n4];
            tab.setLaunchConfigurationDialog(this.getLaunchConfigurationDialog());
            CTabItem item = new CTabItem(tabgroup, 0);
            item.setText(tab.getName());
            item.setImage(tab.getImage());
            tab.createControl((Composite)tabgroup);
            item.setControl(tab.getControl());
            tabgroup.setSelection(0);
            ++n4;
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        if (this.providerCombo != null && !this.providerCombo.getText().isEmpty()) {
            AbstractLaunchConfigurationTab[] abstractLaunchConfigurationTabArray = this.tabs;
            int n = this.tabs.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractLaunchConfigurationTab tab = abstractLaunchConfigurationTabArray[n2];
                tab.setDefaults(configuration);
                ++n2;
            }
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.initial = configuration;
        if (this.initial != null) {
            try {
                String providerId = this.initial.getAttribute("provider", null);
                this.loadTabGroupItems(this.tabgroup, providerId);
            }
            catch (CoreException providerId) {
                // empty catch block
            }
        }
        if (this.tabs != null) {
            AbstractLaunchConfigurationTab[] abstractLaunchConfigurationTabArray = this.tabs;
            int n = this.tabs.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractLaunchConfigurationTab tab = abstractLaunchConfigurationTabArray[n2];
                tab.initializeFrom(configuration);
                ++n2;
            }
        }
        this.initialized.put(this.getProviderId(), true);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        Boolean isInitialized = this.initialized.get(this.getProviderId());
        isInitialized = isInitialized != null ? isInitialized : false;
        if (this.tabs != null && isInitialized.booleanValue()) {
            AbstractLaunchConfigurationTab[] abstractLaunchConfigurationTabArray = this.tabs;
            int n = this.tabs.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractLaunchConfigurationTab tab = abstractLaunchConfigurationTabArray[n2];
                tab.performApply(configuration);
                ++n2;
            }
        }
    }

    private void setProvider(String providerId) {
        try {
            ILaunchConfigurationWorkingCopy wc = this.initial.getWorkingCopy();
            wc.setAttribute("provider", providerId);
            this.initial = wc.doSave();
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
    }

    protected void setConfigurationName(String newToolName) {
        try {
            String currentToolName = this.initial.getAttribute("toolname", "");
            if (newToolName != null && !newToolName.isEmpty() && !currentToolName.equals(newToolName)) {
                String projectName = this.initial.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
                String newConfigurationName = ProviderLaunchShortcut.generateProviderConfigurationName(projectName, newToolName);
                String newUniqueToolName = this.getLaunchManager().generateLaunchConfigurationName(newConfigurationName);
                ILaunchConfigurationWorkingCopy wc = this.initial.getWorkingCopy();
                wc.rename(newUniqueToolName);
                wc.setAttribute("toolname", newToolName);
                this.initial = wc.doSave();
                this.getLaunchConfigurationDialog().setName(newUniqueToolName);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private String getProviderId() {
        try {
            return this.initial.getAttribute("provider", "");
        }
        catch (CoreException e) {
            return "";
        }
    }

    private String getComboItemNameFromId(String id) {
        for (Map.Entry<String, String> entry : this.comboItems.entrySet()) {
            if (!id.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private int getItemIndex(String name) {
        int itemCount = this.providerCombo.getItemCount();
        int i = 0;
        while (i < itemCount) {
            if (this.providerCombo.getItem(i).equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getComboItemIndexFromId(String id) {
        String providerName = this.getComboItemNameFromId(id);
        return this.getItemIndex(providerName);
    }

    public boolean isValid(ILaunchConfiguration config) {
        String provider;
        try {
            provider = config.getAttribute("provider", "");
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
            return false;
        }
        if (provider.isEmpty()) {
            this.setErrorMessage(Messages.ProfilingTab_providerid_not_found);
            return false;
        }
        Boolean isInitialized = this.initialized.get(this.getProviderId());
        if (isInitialized.booleanValue()) {
            if (this.tabs == null) {
                return false;
            }
            AbstractLaunchConfigurationTab[] abstractLaunchConfigurationTabArray = this.tabs;
            int n = this.tabs.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractLaunchConfigurationTab tab = abstractLaunchConfigurationTabArray[n2];
                if (!tab.isValid(config)) {
                    this.setErrorMessage(tab.getErrorMessage());
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected String getProfilingType() {
        return this.type;
    }

    protected void setProfilingType(String type) {
        this.type = type;
    }

    public Image getImage() {
        return this.img;
    }

    public void setImage(Image img) {
        this.img = img;
    }

    public void dispose() {
        if (this.img != null) {
            this.img.dispose();
        }
        super.dispose();
    }
}

