/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.common.core.format;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import org.eclipse.jdt.annotation.NonNull;

public class DataSizeWithUnitFormat
extends Format {
    private static final @NonNull Format INSTANCE = new DataSizeWithUnitFormat();
    private static final long serialVersionUID = 3934127385682676804L;
    private static final String B = "B";
    private static final String KB = "KB";
    private static final String MB = "MB";
    private static final String GB = "GB";
    private static final String TB = "TB";
    private static final long KILO = 1024L;
    private static final Format FORMAT = new DecimalFormat("#.###");

    protected DataSizeWithUnitFormat() {
    }

    public static @NonNull Format getInstance() {
        return INSTANCE;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj instanceof Number) {
            Number num = (Number)obj;
            double value = num.doubleValue();
            double abs = Math.abs(value);
            if (value == 0.0) {
                return toAppendTo.append("0");
            }
            if (abs >= 1.099511627776E12) {
                return toAppendTo.append(FORMAT.format(value / 1.099511627776E12)).append(' ').append(TB);
            }
            if (abs >= 1.073741824E9) {
                return toAppendTo.append(FORMAT.format(value / 1.073741824E9)).append(' ').append(GB);
            }
            if (abs >= 1048576.0) {
                return toAppendTo.append(FORMAT.format(value / 1048576.0)).append(' ').append(MB);
            }
            if (abs >= 1024.0) {
                return toAppendTo.append(FORMAT.format(value / 1024.0)).append(' ').append(KB);
            }
            return toAppendTo.append(FORMAT.format(value)).append(' ').append(B);
        }
        return toAppendTo.append(obj);
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return source == null ? "" : source;
    }
}

