/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.TopDocs;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.search.AnalyzerDescriptor;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.ISearchQuery;
import org.eclipse.help.internal.search.IndexingOperation;
import org.eclipse.help.internal.search.PluginVersionInfo;
import org.eclipse.help.internal.search.ProgressDistributor;
import org.eclipse.help.internal.search.QueryTooComplexException;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.search.SearchIndex;
import org.eclipse.help.internal.search.SearchIndexWithIndexingProgress;
import org.eclipse.help.internal.search.SearchProgressMonitor;
import org.eclipse.help.internal.util.URLCoder;
import org.eclipse.help.search.SearchParticipant;
import org.osgi.framework.Bundle;

public class LocalSearchManager {
    private static final String SEARCH_PARTICIPANT_XP_FULLNAME = "org.eclipse.help.base.searchParticipant";
    private static final String SEARCH_PARTICIPANT_XP_NAME = "searchParticipant";
    private static final String BINDING_XP_NAME = "binding";
    private static final ArrayList<ParticipantDescriptor> PARTICIPANTS_NOT_FOUND = new ArrayList();
    private Map<String, Object> indexes = new HashMap<String, Object>();
    private Map<String, AnalyzerDescriptor> analyzerDescriptors = new HashMap<String, AnalyzerDescriptor>();
    private Map<String, ParticipantDescriptor> searchParticipantsById = new HashMap<String, ParticipantDescriptor>();
    private Map<String, ArrayList<ParticipantDescriptor>> searchParticipantsByPlugin = new HashMap<String, ArrayList<ParticipantDescriptor>>();
    private ArrayList<ParticipantDescriptor> globalSearchParticipants;

    public static List<SearchHit> asList(TopDocs topDocs, IndexSearcher searcher) {
        ArrayList<SearchHit> list = new ArrayList<SearchHit>(topDocs.scoreDocs.length);
        int i = 0;
        while (i < topDocs.scoreDocs.length) {
            try {
                Document doc = searcher.doc(topDocs.scoreDocs[i].doc);
                float score = topDocs.scoreDocs[i].score;
                String href = doc.get("name");
                String summary = doc.get("summary");
                String id = doc.get("id");
                String participantId = doc.get("participantId");
                String label = doc.get("raw_title");
                boolean isPotentialHit = doc.get("filters") != null;
                list.add(new SearchHit(href, label, summary, score, null, id, participantId, isPotentialHit));
            }
            catch (IOException e) {
                HelpBasePlugin.logError("An error occured while reading search hits", e);
            }
            ++i;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchIndexWithIndexingProgress getIndex(String locale) {
        Map<String, Object> map = this.indexes;
        synchronized (map) {
            Object index = this.indexes.get(locale);
            if (index == null) {
                index = new SearchIndexWithIndexingProgress(locale, this.getAnalyzer(locale), HelpPlugin.getTocManager());
                this.indexes.put(locale, index);
            }
            return (SearchIndexWithIndexingProgress)index;
        }
    }

    private AnalyzerDescriptor getAnalyzer(String locale) {
        AnalyzerDescriptor analyzerDesc = this.analyzerDescriptors.get(locale);
        if (analyzerDesc != null) {
            return analyzerDesc;
        }
        analyzerDesc = new AnalyzerDescriptor(locale);
        this.analyzerDescriptors.put(locale, analyzerDesc);
        String lang = analyzerDesc.getLang();
        if (locale != null && !locale.equals(lang)) {
            this.analyzerDescriptors.put(lang, analyzerDesc);
        }
        return analyzerDesc;
    }

    public static String trimQuery(String href) {
        int qloc = href.indexOf(63);
        if (qloc != -1) {
            return href.substring(0, qloc);
        }
        return href;
    }

    public boolean isIndexable(String url) {
        ArrayList<ParticipantDescriptor> list = this.getParticipantDescriptors(LocalSearchManager.getPluginId(url = LocalSearchManager.trimQuery(url)));
        if (list == null) {
            return false;
        }
        int dotLoc = url.lastIndexOf(46);
        String ext = url.substring(dotLoc + 1);
        int i = 0;
        while (i < list.size()) {
            ParticipantDescriptor desc = list.get(i);
            if (desc.matches(ext)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isParticipantEnabled(boolean headless) {
        if (!headless) {
            return BaseHelpSystem.getMode() == 0;
        }
        return true;
    }

    public static String getPluginId(String href) {
        IProduct product;
        int i;
        if ((href = LocalSearchManager.trimQuery(href)).charAt(0) == '/') {
            href = href.substring(1);
        }
        String pluginId = (i = href.indexOf(47)) == -1 ? "" : href.substring(0, i);
        if ("PRODUCT_PLUGIN".equals(pluginId = URLCoder.decode((String)pluginId)) && (product = Platform.getProduct()) != null) {
            pluginId = product.getDefiningBundle().getSymbolicName();
        }
        return pluginId;
    }

    public SearchParticipant getGlobalParticipant(String participantId) {
        ParticipantDescriptor desc = this.getGlobalParticipantDescriptor(participantId);
        return desc != null ? desc.getParticipant() : null;
    }

    public IHelpResource getParticipantCategory(String participantId) {
        ParticipantDescriptor desc = this.getGlobalParticipantDescriptor(participantId);
        return desc != null ? desc.getCategory() : null;
    }

    public URL getParticipantIconURL(String participantId) {
        ParticipantDescriptor desc = this.getGlobalParticipantDescriptor(participantId);
        return desc != null ? desc.getIconURL() : null;
    }

    private ParticipantDescriptor getGlobalParticipantDescriptor(String participantId) {
        if (this.globalSearchParticipants == null) {
            this.createGlobalSearchParticipants();
        }
        int i = 0;
        while (i < this.globalSearchParticipants.size()) {
            ParticipantDescriptor desc = this.globalSearchParticipants.get(i);
            if (desc.getId().equals(participantId)) {
                return desc;
            }
            ++i;
        }
        return null;
    }

    public SearchParticipant getParticipant(String participantId) {
        ParticipantDescriptor desc = this.searchParticipantsById.get(participantId);
        if (desc != null) {
            return desc.getParticipant();
        }
        return null;
    }

    public SearchParticipant getParticipant(String pluginId, String fileName) {
        ArrayList<ParticipantDescriptor> list = this.getParticipantDescriptors(pluginId);
        if (list == null) {
            return null;
        }
        int dotLoc = fileName.lastIndexOf(46);
        String ext = fileName.substring(dotLoc + 1);
        int i = 0;
        while (i < list.size()) {
            ParticipantDescriptor desc = list.get(i);
            if (desc.matches(ext)) {
                return desc.getParticipant();
            }
            ++i;
        }
        return null;
    }

    public boolean isParticipantBound(String pluginId, String participantId) {
        ArrayList<ParticipantDescriptor> list = this.getParticipantDescriptors(pluginId);
        if (list != null) {
            for (ParticipantDescriptor desc : list) {
                if (!participantId.equals(desc.getId())) continue;
                return true;
            }
        }
        return false;
    }

    public Set<String> getPluginsWithSearchParticipants() {
        HashSet<String> set = new HashSet<String>();
        this.addSearchBindings(set);
        SearchParticipant[] gps = this.getGlobalParticipants();
        int i = 0;
        while (i < gps.length) {
            block3: {
                Set<String> ids;
                try {
                    ids = gps[i].getContributingPlugins();
                }
                catch (Throwable t) {
                    HelpBasePlugin.logError("Error getting the contributing plugins from help search participant: " + gps[i].getClass().getName() + ". skipping this one.", t);
                    break block3;
                }
                set.addAll(ids);
            }
            ++i;
        }
        return set;
    }

    private void addSearchBindings(HashSet<String> set) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(SEARCH_PARTICIPANT_XP_FULLNAME);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals(BINDING_XP_NAME) || element.getName().equals(SEARCH_PARTICIPANT_XP_NAME)) {
                set.add(element.getContributor().getName());
            }
            ++i;
        }
    }

    public void clearSearchParticipants() {
        for (ParticipantDescriptor desc : this.searchParticipantsById.values()) {
            desc.clear();
        }
    }

    private ArrayList<ParticipantDescriptor> getBindingsForPlugin(String pluginId, ArrayList<ParticipantDescriptor> list, String extensionPointName) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionPointName);
        ArrayList<IConfigurationElement> binding = null;
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getContributor().getName().equals(pluginId)) {
                if (BINDING_XP_NAME.equals(element.getName())) {
                    String refId = element.getAttribute("participantId");
                    int j = 0;
                    while (j < elements.length) {
                        IConfigurationElement rel = elements[j];
                        if (rel.getName().equals(SEARCH_PARTICIPANT_XP_NAME)) {
                            String id = rel.getAttribute("id");
                            if (rel.getAttribute("extensions") != null && id != null && id.equals(refId)) {
                                if (binding == null) {
                                    binding = new ArrayList<IConfigurationElement>();
                                }
                                binding.add(rel);
                                break;
                            }
                        }
                        ++j;
                    }
                } else if (SEARCH_PARTICIPANT_XP_NAME.equals(element.getName()) && element.getAttribute("extensions") != null && LocalSearchManager.isParticipantEnabled(String.valueOf(true).equals(element.getAttribute("headless")))) {
                    if (list == null) {
                        list = new ArrayList();
                    }
                    ParticipantDescriptor desc = new ParticipantDescriptor(element);
                    list.add(desc);
                    this.searchParticipantsById.put(desc.getId(), desc);
                }
            }
            ++i;
        }
        if (binding != null) {
            list = this.addBoundDescriptors(list, binding);
        }
        return list;
    }

    private ArrayList<ParticipantDescriptor> addBoundDescriptors(ArrayList<ParticipantDescriptor> list, ArrayList<IConfigurationElement> binding) {
        int i = 0;
        while (i < binding.size()) {
            IConfigurationElement refEl = binding.get(i);
            Collection<ArrayList<ParticipantDescriptor>> collection = this.searchParticipantsByPlugin.values();
            boolean found = false;
            Iterator<ArrayList<ParticipantDescriptor>> iter = collection.iterator();
            block1: while (iter.hasNext()) {
                if (found) break;
                ArrayList<ParticipantDescriptor> participants = iter.next();
                if (participants == PARTICIPANTS_NOT_FOUND) continue;
                int j = 0;
                while (j < participants.size()) {
                    ParticipantDescriptor desc = participants.get(j);
                    if (desc.contains(refEl)) {
                        if (list == null) {
                            list = new ArrayList();
                        }
                        list.add(desc);
                        found = true;
                        continue block1;
                    }
                    ++j;
                }
            }
            if (!found) {
                if (list == null) {
                    list = new ArrayList();
                }
                ParticipantDescriptor d = new ParticipantDescriptor(refEl);
                list.add(d);
                this.searchParticipantsById.put(d.getId(), d);
            }
            ++i;
        }
        return list;
    }

    public SearchParticipant[] getGlobalParticipants() {
        if (this.globalSearchParticipants == null) {
            this.createGlobalSearchParticipants();
        }
        ArrayList<SearchParticipant> result = new ArrayList<SearchParticipant>();
        int i = 0;
        while (i < this.globalSearchParticipants.size()) {
            ParticipantDescriptor desc = this.globalSearchParticipants.get(i);
            SearchParticipant p = desc.getParticipant();
            if (p != null) {
                result.add(p);
            }
            ++i;
        }
        return result.toArray(new SearchParticipant[result.size()]);
    }

    private void createGlobalSearchParticipants() {
        this.globalSearchParticipants = new ArrayList();
        this.addSearchParticipants();
    }

    private void addSearchParticipants() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(SEARCH_PARTICIPANT_XP_FULLNAME);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals(SEARCH_PARTICIPANT_XP_NAME) && element.getAttribute("extensions") == null && LocalSearchManager.isParticipantEnabled(String.valueOf(true).equals(element.getAttribute("headless")))) {
                ParticipantDescriptor desc = new ParticipantDescriptor(element);
                this.globalSearchParticipants.add(desc);
            }
            ++i;
        }
    }

    private ArrayList<ParticipantDescriptor> getParticipantDescriptors(String pluginId) {
        ArrayList<ParticipantDescriptor> result = this.searchParticipantsByPlugin.get(pluginId);
        if (result == null) {
            result = this.getBindingsForPlugin(pluginId, null, SEARCH_PARTICIPANT_XP_FULLNAME);
            if (result == null) {
                result = PARTICIPANTS_NOT_FOUND;
            }
            this.searchParticipantsByPlugin.put(pluginId, result);
        }
        if (result == PARTICIPANTS_NOT_FOUND) {
            return null;
        }
        return result;
    }

    public void search(ISearchQuery searchQuery, ISearchHitCollector collector, IProgressMonitor pm) throws QueryTooComplexException {
        SearchIndexWithIndexingProgress index = this.getIndex(searchQuery.getLocale());
        this.ensureIndexUpdated(pm, index);
        if (index.exists()) {
            index.search(searchQuery, collector);
        }
    }

    /*
     * Exception decompiling
     */
    public void ensureIndexUpdated(IProgressMonitor pm, SearchIndexWithIndexingProgress index) throws OperationCanceledException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private synchronized void updateIndex(IProgressMonitor pm, SearchIndex index, ProgressDistributor progressDistrib) {
        if (index.isClosed() || !index.needsUpdating()) {
            pm.beginTask("", 1);
            pm.worked(1);
            pm.done();
            return;
        }
        try {
            PluginVersionInfo versions = index.getDocPlugins();
            if (versions == null) {
                pm.beginTask("", 1);
                pm.worked(1);
                pm.done();
                return;
            }
            IndexingOperation indexer = new IndexingOperation(index);
            indexer.execute(progressDistrib);
            return;
        }
        catch (OperationCanceledException e) {
            progressDistrib.operationCanceled();
            throw e;
        }
        catch (IndexingOperation.IndexingException e) {
            String msg = "Error indexing documents";
            HelpBasePlugin.logError(msg, e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map<String, Object> map = this.indexes;
        synchronized (map) {
            Iterator<Object> it = this.indexes.values().iterator();
            while (it.hasNext()) {
                ((SearchIndex)it.next()).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void tocsChanged() {
        ArrayList<Object> activeIndexes = new ArrayList<Object>();
        Map<String, Object> map = this.indexes;
        synchronized (map) {
            activeIndexes.addAll(this.indexes.values());
        }
        for (SearchIndexWithIndexingProgress searchIndexWithIndexingProgress : activeIndexes) {
            searchIndexWithIndexingProgress.close();
            Map<String, Object> map2 = this.indexes;
            synchronized (map2) {
                this.indexes.remove(searchIndexWithIndexingProgress.getLocale());
                ProgressDistributor pm = searchIndexWithIndexingProgress.getProgressDistributor();
                pm.beginTask("", 1);
                pm.worked(1);
                pm.done();
                SearchProgressMonitor.reinit(searchIndexWithIndexingProgress.getLocale());
            }
        }
    }

    private static class ParticipantDescriptor
    implements IHelpResource {
        private IConfigurationElement element;
        private SearchParticipant participant;

        public ParticipantDescriptor(IConfigurationElement element) {
            this.element = element;
        }

        public String getId() {
            return this.element.getAttribute("id");
        }

        public boolean matches(String extension) {
            String ext = this.element.getAttribute("extensions");
            if (ext == null) {
                return false;
            }
            StringTokenizer stok = new StringTokenizer(ext, ",");
            while (stok.hasMoreTokens()) {
                String token = stok.nextToken().trim();
                if (!token.equalsIgnoreCase(extension)) continue;
                return true;
            }
            return false;
        }

        public IHelpResource getCategory() {
            return this;
        }

        public SearchParticipant getParticipant() {
            if (this.participant == null) {
                try {
                    Object obj = this.element.createExecutableExtension("participant");
                    if (obj instanceof SearchParticipant) {
                        this.participant = (SearchParticipant)obj;
                        this.participant.init(this.getId());
                    }
                }
                catch (Throwable t) {
                    HelpPlugin.logError((String)"Exception occurred creating Lucene search participant.", (Throwable)t);
                }
            }
            return this.participant;
        }

        public boolean contains(IConfigurationElement el) {
            return this.element.equals((Object)el);
        }

        public String getHref() {
            return null;
        }

        public String getLabel() {
            return this.element.getAttribute("name");
        }

        public URL getIconURL() {
            String relativePath = this.element.getAttribute("icon");
            if (relativePath == null) {
                return null;
            }
            String bundleId = this.element.getContributor().getName();
            Bundle bundle = Platform.getBundle((String)bundleId);
            if (bundle == null) {
                return null;
            }
            return FileLocator.find((Bundle)bundle, (IPath)new Path(relativePath), null);
        }

        public void clear() {
            if (this.participant != null) {
                try {
                    this.participant.clear();
                }
                catch (Throwable t) {
                    HelpBasePlugin.logError("Error occured in search participant's clear() operation: " + this.participant.getClass().getName(), t);
                }
            }
        }
    }
}

