/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.helgrind;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.linuxtools.internal.valgrind.helgrind.Messages;
import org.eclipse.linuxtools.valgrind.launch.IValgrindToolPage;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.osgi.framework.Version;

public class HelgrindToolPage
extends AbstractLaunchConfigurationTab
implements IValgrindToolPage {
    private Button lockordersButton;
    private Combo historyCombo;
    private Spinner cacheSizeSpinner;
    private boolean isInitializing = false;
    private SelectionListener selectListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            HelgrindToolPage.this.updateLaunchConfigurationDialog();
        }
    };
    private ModifyListener modifyListener = e -> this.updateLaunchConfigurationDialog();

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout helgrindLayout = new GridLayout(2, true);
        top.setLayout((Layout)helgrindLayout);
        top.setLayoutData((Object)new GridData(768));
        this.lockordersButton = new Button(top, 32);
        this.lockordersButton.setLayoutData((Object)new GridData(768));
        this.lockordersButton.setText(Messages.getString("HelgrindToolPage.track_lockorders"));
        this.lockordersButton.addSelectionListener(this.selectListener);
        Composite historyTop = new Composite(top, 0);
        historyTop.setLayout((Layout)new GridLayout(2, false));
        historyTop.setLayoutData((Object)new GridData(768));
        Label historyLabel = new Label(historyTop, 0);
        historyLabel.setText(Messages.getString("HelgrindToolPage.history_level"));
        this.historyCombo = new Combo(historyTop, 8);
        String[] historyOpts = new String[]{"full", "approx", "none"};
        this.historyCombo.setItems(historyOpts);
        this.historyCombo.addSelectionListener(this.selectListener);
        Composite conflictCacheSizeTop = new Composite(top, 0);
        conflictCacheSizeTop.setLayout((Layout)new GridLayout(2, false));
        conflictCacheSizeTop.setLayoutData((Object)new GridData(768));
        Label cacheSizeLabel = new Label(conflictCacheSizeTop, 0);
        cacheSizeLabel.setText(Messages.getString("HelgrindToolPage.cache_size"));
        this.cacheSizeSpinner = new Spinner(conflictCacheSizeTop, 2048);
        this.cacheSizeSpinner.setMaximum(Integer.MAX_VALUE);
        this.cacheSizeSpinner.addModifyListener(this.modifyListener);
    }

    public String getName() {
        return Messages.getString("HelgrindToolPage.Helgrind_Options");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.isInitializing = true;
        try {
            this.lockordersButton.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.helgrind.HELGRIND_LOCKORDERS", true));
            this.historyCombo.setText(configuration.getAttribute("org.eclipse.linuxtools.valgrind.helgrind.HELGRIND_HISTORYLEVEL", "full"));
            this.cacheSizeSpinner.setSelection(configuration.getAttribute("org.eclipse.linuxtools.valgrind.helgrind.HELGRIND_CACHESIZE", 1000000));
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.isInitializing = false;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.helgrind.HELGRIND_LOCKORDERS", this.lockordersButton.getSelection());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.helgrind.HELGRIND_HISTORYLEVEL", this.historyCombo.getText());
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.helgrind.HELGRIND_CACHESIZE", this.cacheSizeSpinner.getSelection());
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.launch.TOOL", "org.eclipse.linuxtools.valgrind.launch.helgrind");
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.helgrind.HELGRIND_LOCKORDERS", true);
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.helgrind.HELGRIND_HISTORYLEVEL", "full");
        configuration.setAttribute("org.eclipse.linuxtools.valgrind.helgrind.HELGRIND_CACHESIZE", 1000000);
    }

    public void setValgrindVersion(Version ver) {
    }

    protected void updateLaunchConfigurationDialog() {
        if (!this.isInitializing) {
            super.updateLaunchConfigurationDialog();
        }
    }

    public Button getLockordersButton() {
        return this.lockordersButton;
    }

    public Spinner getCacheSizeSpinner() {
        return this.cacheSizeSpinner;
    }

    public Combo getHistoryCombo() {
        return this.historyCombo;
    }
}

