/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.Messages;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternAnalysis;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.stateprovider.XmlStateSystemModule;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisManager;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAbstractAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.project.model.ITmfPropertiesProvider;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;

public class TmfAnalysisModuleHelperXml
implements IAnalysisModuleHelper,
ITmfPropertiesProvider {
    private final File fSourceFile;
    private final Element fSourceElement;
    private final XmlAnalysisModuleType fType;

    public TmfAnalysisModuleHelperXml(File xmlFile, Element node, XmlAnalysisModuleType type) {
        this.fSourceFile = xmlFile;
        this.fSourceElement = node;
        this.fType = type;
    }

    public String getId() {
        return this.fSourceElement.getAttribute("id");
    }

    public String getName() {
        List<Element> labels;
        String name = null;
        List<Element> head = XmlUtils.getChildElements(this.fSourceElement, "head");
        if (head.size() == 1 && !(labels = XmlUtils.getChildElements(head.get(0), "label")).isEmpty()) {
            name = labels.get(0).getAttribute("value");
        }
        if (name == null) {
            name = this.getId();
        }
        return name;
    }

    public boolean isAutomatic() {
        return false;
    }

    public boolean appliesToExperiment() {
        return false;
    }

    public String getHelpText() {
        return "";
    }

    public String getHelpText(@NonNull ITmfTrace trace) {
        return "";
    }

    public String getIcon() {
        return null;
    }

    public Bundle getBundle() {
        return Activator.getDefault().getBundle();
    }

    public boolean appliesToTraceType(Class<? extends ITmfTrace> traceClass) {
        List<Element> head = XmlUtils.getChildElements(this.fSourceElement, "head");
        if (head.size() != 1) {
            return true;
        }
        List<Element> elements = XmlUtils.getChildElements(head.get(0), "traceType");
        if (elements.isEmpty()) {
            return true;
        }
        for (Element element : elements) {
            String traceTypeId = element.getAttribute("id");
            TraceTypeHelper helper = TmfTraceType.getTraceType((String)(traceTypeId = TmfTraceType.buildCompatibilityTraceTypeId((String)traceTypeId)));
            if (helper == null || !helper.getTrace().getClass().isAssignableFrom(traceClass)) continue;
            return true;
        }
        return false;
    }

    public Iterable<Class<? extends ITmfTrace>> getValidTraceTypes() {
        return Collections.EMPTY_SET;
    }

    public Iterable<TmfAbstractAnalysisRequirement> getAnalysisRequirements() {
        return Collections.EMPTY_SET;
    }

    public IAnalysisModule newModule(ITmfTrace trace) throws TmfAnalysisException {
        String analysisid = this.getId();
        Object module = null;
        switch (this.fType) {
            case STATE_SYSTEM: {
                Object ssModule = module = new XmlStateSystemModule();
                module.setId(analysisid);
                ((XmlStateSystemModule)((Object)ssModule)).setXmlFile((IPath)new Path(this.fSourceFile.getAbsolutePath()));
                ssModule.setAutomatic(true);
                break;
            }
            case PATTERN: {
                module = new XmlPatternAnalysis();
                module.setName(this.getName());
                module.setId(analysisid);
                XmlPatternAnalysis paModule = (XmlPatternAnalysis)((Object)module);
                paModule.setXmlFile((IPath)new Path(this.fSourceFile.getAbsolutePath()));
                paModule.setAutomatic(true);
                break;
            }
        }
        if (module != null) {
            if (module.setTrace(trace)) {
                TmfAnalysisManager.analysisModuleCreated((IAnalysisModule)module);
            } else {
                module.dispose();
                module = null;
            }
        }
        return module;
    }

    public @NonNull Map<@NonNull String, @NonNull String> getProperties() {
        HashMap<@NonNull String, @NonNull String> properties = new HashMap<String, String>();
        properties.put((String)NonNullUtils.checkNotNull((Object)Messages.XmlModuleHelper_PropertyFile), this.fSourceFile.getName());
        properties.put((String)NonNullUtils.checkNotNull((Object)Messages.XmlModuleHelper_PropertyType), this.fType.name());
        return properties;
    }

    public static enum XmlAnalysisModuleType {
        STATE_SYSTEM,
        PATTERN;

    }
}

