/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.db;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.pdom.db.Chunk;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.db.IString;
import org.eclipse.core.runtime.CoreException;

public class ShortString
implements IString {
    private final Database db;
    private final long record;
    private int hash;
    private static final int LENGTH = 0;
    private static final int CHARS = 4;
    public static final int MAX_BYTE_LENGTH = 4090;

    public ShortString(Database db, long offset) {
        this.db = db;
        this.record = offset;
    }

    public ShortString(Database db, char[] chars, boolean useBytes) throws CoreException {
        int n = chars.length;
        this.db = db;
        this.record = db.malloc(4 + (useBytes ? n : 2 * n));
        Chunk chunk = db.getChunk(this.record);
        chunk.putInt(this.record + 0L, useBytes ? -n : n);
        long p = this.record + 4L;
        if (useBytes) {
            chunk.putCharsAsBytes(p, chars, 0, n);
        } else {
            chunk.putChars(p, chars, 0, n);
        }
    }

    @Override
    public long getRecord() {
        return this.record;
    }

    @Override
    public void delete() throws CoreException {
        this.db.free(this.record);
    }

    @Override
    public char[] getChars() throws CoreException {
        Chunk chunk = this.db.getChunk(this.record);
        int l = chunk.getInt(this.record + 0L);
        int length = Math.abs(l);
        char[] chars = new char[length];
        if (l < 0) {
            chunk.getCharsFromBytes(this.record + 4L, chars, 0, length);
        } else {
            chunk.getChars(this.record + 4L, chars, 0, length);
        }
        return chars;
    }

    @Override
    public String getString() throws CoreException {
        return new String(this.getChars());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        try {
            if (obj instanceof ShortString) {
                int n2;
                ShortString string = (ShortString)obj;
                if (this.db == string.db && this.record == string.record) {
                    return true;
                }
                Chunk chunk1 = this.db.getChunk(this.record);
                Chunk chunk2 = string.db.getChunk(string.record);
                int n1 = chunk1.getInt(this.record);
                if (n1 == (n2 = chunk2.getInt(string.record))) return CharArrayUtils.equals(this.getChars(), string.getChars());
                return false;
            }
            if (obj instanceof char[]) {
                char[] chars = (char[])obj;
                if (this.getLength() == chars.length) return CharArrayUtils.equals(this.getChars(), chars);
                return false;
            }
            if (!(obj instanceof String)) return false;
            String string = (String)obj;
            if (this.getLength() == string.length()) return CharArrayUtils.equals(this.getChars(), string.toCharArray());
            return false;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
        return false;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            try {
                char[] chars = this.getChars();
                int len = chars.length;
                int i = 0;
                while (i < len) {
                    h = 31 * h + chars[i];
                    ++i;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            this.hash = h;
        }
        return h;
    }

    public static int compare(char[] chars, char[] other, boolean caseSensitive) {
        int n = Math.min(chars.length, other.length);
        int i = 0;
        while (i < n) {
            int cmp = ShortString.compareChars(chars[i], other[i], caseSensitive);
            if (cmp != 0) {
                return cmp;
            }
            ++i;
        }
        return chars.length - other.length;
    }

    @Override
    public int compare(char[] other, boolean caseSensitive) throws CoreException {
        return ShortString.compare(this.getChars(), other, caseSensitive);
    }

    @Override
    public int compare(IString string, boolean caseSensitive) throws CoreException {
        return ShortString.compare(this.getChars(), string.getChars(), caseSensitive);
    }

    @Override
    public int compare(String other, boolean caseSensitive) throws CoreException {
        return ShortString.compare(this.getChars(), other.toCharArray(), caseSensitive);
    }

    @Override
    public int compareCompatibleWithIgnoreCase(IString string) throws CoreException {
        return this.compareCompatibleWithIgnoreCase(string.getChars());
    }

    @Override
    public int compareCompatibleWithIgnoreCase(char[] other) throws CoreException {
        return ShortString.compareCompatibleWithIgnoreCase(this.getChars(), other);
    }

    public static int compareCompatibleWithIgnoreCase(char[] chars, char[] other) {
        int n = Math.min(chars.length, other.length);
        int sensitiveCmp = 0;
        int i = 0;
        while (i < n) {
            char c1 = chars[i];
            char c2 = other[i];
            if (c1 != c2) {
                int cmp = ShortString.compareChars(c1, c2, false);
                if (cmp != 0) {
                    return cmp;
                }
                if (sensitiveCmp == 0) {
                    sensitiveCmp = c1 < c2 ? -1 : 1;
                }
            }
            ++i;
        }
        int cmp = chars.length - other.length;
        if (cmp != 0) {
            return cmp;
        }
        return sensitiveCmp;
    }

    @Override
    public int comparePrefix(char[] other, boolean caseSensitive) throws CoreException {
        return ShortString.comparePrefix(this.getChars(), other, caseSensitive);
    }

    public static int comparePrefix(char[] chars, char[] other, boolean caseSensitive) {
        int n = Math.min(chars.length, other.length);
        int i = 0;
        while (i < n) {
            int cmp = ShortString.compareChars(chars[i], other[i], caseSensitive);
            if (cmp != 0) {
                return cmp;
            }
            ++i;
        }
        if (chars.length < other.length) {
            return -1;
        }
        return 0;
    }

    public final int getLength() throws CoreException {
        return Math.abs(this.db.getInt(this.record + 0L));
    }

    public static int compareChars(char a, char b, boolean caseSensitive) {
        if (caseSensitive) {
            if (a < b) {
                return -1;
            }
            if (a > b) {
                return 1;
            }
        } else if (a != b) {
            a = a >= 'a' && a <= 'z' ? (char)(a - 32) : a;
            char c = b = b >= 'a' && b <= 'z' ? (char)(b - 32) : b;
            if (a < b) {
                return -1;
            }
            if (a > b) {
                return 1;
            }
        }
        return 0;
    }

    public String toString() {
        try {
            return this.getString();
        }
        catch (CoreException e) {
            return super.toString();
        }
    }
}

