/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.IdentityHashMap;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.core.parser.OffsetLimitReachedException;
import org.eclipse.cdt.core.parser.util.CharArrayMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.parser.scanner.CPreprocessor;
import org.eclipse.cdt.internal.core.parser.scanner.CompletionInMacroExpansionException;
import org.eclipse.cdt.internal.core.parser.scanner.FunctionStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner.ILexerLog;
import org.eclipse.cdt.internal.core.parser.scanner.ITokenSequence;
import org.eclipse.cdt.internal.core.parser.scanner.ImageLocationInfo;
import org.eclipse.cdt.internal.core.parser.scanner.Lexer;
import org.eclipse.cdt.internal.core.parser.scanner.LocationMap;
import org.eclipse.cdt.internal.core.parser.scanner.MacroDefinitionParser;
import org.eclipse.cdt.internal.core.parser.scanner.MacroExpansionTracker;
import org.eclipse.cdt.internal.core.parser.scanner.ObjectStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner.PreprocessorMacro;
import org.eclipse.cdt.internal.core.parser.scanner.ScannerContext;
import org.eclipse.cdt.internal.core.parser.scanner.Token;
import org.eclipse.cdt.internal.core.parser.scanner.TokenList;
import org.eclipse.cdt.internal.core.parser.scanner.TokenWithImage;

public class MacroExpander {
    private static final int ORIGIN = 4;
    private static final TokenList EMPTY_TOKEN_LIST = new TokenList();
    private final ILexerLog fLog;
    private final MacroDefinitionParser fDefinitionParser;
    private final CharArrayMap<PreprocessorMacro> fDictionary;
    private final LocationMap fLocationMap;
    private final Lexer.LexerOptions fLexOptions;
    private ArrayList<IASTName> fImplicitMacroExpansions = new ArrayList();
    private ArrayList<ImageLocationInfo> fImageLocationInfos = new ArrayList();
    private boolean fCompletionMode;
    private int fStartOffset;
    private int fEndOffset;
    private String fFixedCurrentFilename;
    private int fFixedLineNumber;
    private char[] fFixedInput;
    private ScannerContext fReportMacros;
    private boolean fReportUndefined;

    public MacroExpander(ILexerLog log, CharArrayMap<PreprocessorMacro> macroDictionary, LocationMap locationMap, Lexer.LexerOptions lexOptions) {
        this.fDictionary = macroDictionary;
        this.fLocationMap = locationMap;
        this.fDefinitionParser = new MacroDefinitionParser();
        this.fLexOptions = lexOptions;
        this.fLog = log;
    }

    public TokenList expand(ITokenSequence lexer, int ppOptions, PreprocessorMacro macro, Token identifier, boolean completionMode, ScannerContext scannerContext) throws OffsetLimitReachedException {
        TokenList result;
        boolean protectIntrinsics;
        boolean bl = protectIntrinsics = (ppOptions & 2) != 0;
        if ((ppOptions & 0x10) != 0) {
            this.fReportMacros = scannerContext;
            this.fReportUndefined = (ppOptions & 0x20) == 0;
        } else {
            this.fReportMacros = null;
        }
        this.fImplicitMacroExpansions.clear();
        this.fImageLocationInfos.clear();
        this.fStartOffset = identifier.getOffset();
        this.fEndOffset = identifier.getEndOffset();
        this.fCompletionMode = completionMode;
        IdentityHashMap<PreprocessorMacro, PreprocessorMacro> forbidden = new IdentityHashMap<PreprocessorMacro, PreprocessorMacro>();
        TokenSource input = new TokenSource(lexer);
        TokenList firstExpansion = new TokenList();
        try {
            firstExpansion.append(new ExpansionBoundary(macro, true));
            this.expandOne(identifier, macro, forbidden, input, firstExpansion, null);
            firstExpansion.append(new ExpansionBoundary(macro, false));
            input.prepend(firstExpansion);
            result = this.expandAll(input, forbidden, protectIntrinsics, null);
        }
        catch (CompletionInMacroExpansionException e) {
            result = e.getParameterTokens().cloneTokens();
        }
        this.postProcessTokens(result);
        this.fReportMacros = null;
        return result;
    }

    public void expand(String beforeExpansion, MacroExpansionTracker tracker, String filePath, int lineNumber, boolean protectDefinedConstructs) {
        this.fImplicitMacroExpansions.clear();
        this.fImageLocationInfos.clear();
        this.fFixedInput = beforeExpansion.toCharArray();
        this.fFixedCurrentFilename = filePath;
        this.fFixedLineNumber = lineNumber;
        this.fReportMacros = null;
        Lexer lexer = new Lexer(this.fFixedInput, this.fLexOptions, this.fLog, (Object)this);
        try {
            tracker.start(this.fFixedInput);
            Token identifier = lexer.nextToken();
            if (identifier.getType() != 1) {
                tracker.fail();
                return;
            }
            PreprocessorMacro macro = this.fDictionary.get(identifier.getCharImage());
            if (macro == null) {
                tracker.fail();
                return;
            }
            lexer.nextToken();
            this.fStartOffset = identifier.getOffset();
            this.fEndOffset = identifier.getEndOffset();
            this.fCompletionMode = false;
            IdentityHashMap<PreprocessorMacro, PreprocessorMacro> forbidden = new IdentityHashMap<PreprocessorMacro, PreprocessorMacro>();
            TokenSource input = new TokenSource(lexer);
            TokenList firstExpansion = new TokenList();
            firstExpansion.append(new ExpansionBoundary(macro, true));
            this.expandOne(identifier, macro, forbidden, input, firstExpansion, tracker);
            firstExpansion.append(new ExpansionBoundary(macro, false));
            input.prepend(firstExpansion);
            TokenList result = this.expandAll(input, forbidden, protectDefinedConstructs, tracker);
            tracker.finish(result, this.fEndOffset);
        }
        catch (OffsetLimitReachedException offsetLimitReachedException) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     */
    private Token expandOne(Token lastConsumed, PreprocessorMacro macro, IdentityHashMap<PreprocessorMacro, PreprocessorMacro> forbidden, TokenSource input, TokenList result, MacroExpansionTracker tracker) throws OffsetLimitReachedException {
        if (this.fReportMacros != null) {
            this.fReportMacros.significantMacro(macro);
        }
        if (macro.isFunctionStyle()) {
            block26: {
                paramCount = macro.getParameterPlaceholderList().length;
                argInputs = new TokenSource[paramCount];
                paramUsage = this.getParamUsage(macro);
                if (tracker != null) {
                    tracker.startFunctionStyleMacro(lastConsumed.clone());
                }
                try {
                    lastConsumed = this.parseArguments(input, (FunctionStyleMacro)macro, forbidden, argInputs, tracker);
                    break block26;
                }
                catch (AbortMacroExpansionException e) {
                    var14_13 = argInputs;
                    var13_15 = argInputs.length;
                    var12_17 = 0;
                    ** while (var12_17 < var13_15)
                }
lbl-1000:
                // 1 sources

                {
                    argInput = var14_13[var12_17];
                    this.executeScopeMarkers(argInput, forbidden);
                    if (tracker != null) {
                        tracker.setExpandedMacroArgument(null);
                    }
                    ++var12_17;
                    continue;
                }
lbl23:
                // 1 sources

                if (tracker != null) {
                    if (tracker.isRequestedStep()) {
                        tracker.storeFunctionStyleMacroReplacement(macro, new TokenList(), result);
                    } else if (tracker.isDone()) {
                        tracker.appendFunctionStyleMacro(result);
                    }
                    tracker.endFunctionStyleMacro();
                }
                return null;
            }
            clonedArgs = new TokenList[paramCount];
            expandedArgs = new TokenList[paramCount];
            i = 0;
            while (i < paramCount) {
                argInput = argInputs[i];
                needCopy = paramUsage.get(2 * i);
                needExpansion = paramUsage.get(2 * i + 1);
                clonedArgs[i] = needCopy != false ? argInput.cloneTokens() : MacroExpander.EMPTY_TOKEN_LIST;
                v0 = expandedArgs[i] = needExpansion != false ? this.expandAll(argInput, forbidden, false, tracker) : MacroExpander.EMPTY_TOKEN_LIST;
                if (!needExpansion) {
                    this.executeScopeMarkers(argInput, forbidden);
                }
                if (tracker != null) {
                    tracker.setExpandedMacroArgument(needExpansion != false ? expandedArgs[i] : null);
                    if (tracker.isDone()) {
                        paramUsage.clear();
                    }
                }
                ++i;
            }
            if (tracker == null) {
                this.replaceArgs(macro, clonedArgs, expandedArgs, result);
            } else {
                if (tracker.isRequestedStep()) {
                    replacement = new TokenList();
                    this.replaceArgs(macro, clonedArgs, expandedArgs, replacement);
                    tracker.storeFunctionStyleMacroReplacement(macro, replacement, result);
                } else if (tracker.isDone()) {
                    tracker.appendFunctionStyleMacro(result);
                } else {
                    this.replaceArgs(macro, clonedArgs, expandedArgs, result);
                }
                tracker.endFunctionStyleMacro();
            }
        } else if (tracker == null) {
            this.objStyleTokenPaste(macro, result);
        } else {
            if (tracker.isRequestedStep()) {
                replacement = new TokenList();
                this.objStyleTokenPaste(macro, replacement);
                tracker.storeObjectStyleMacroReplacement(macro, lastConsumed, replacement, result);
            } else {
                this.objStyleTokenPaste(macro, result);
            }
            tracker.endObjectStyleMacro();
        }
        return lastConsumed;
    }

    private void executeScopeMarkers(TokenSource input, IdentityHashMap<PreprocessorMacro, PreprocessorMacro> forbidden) {
        Token t = input.removeFirst();
        while (t != null) {
            if (t.getType() == -198) {
                ((ExpansionBoundary)t).execute(forbidden);
            }
            t = input.removeFirst();
        }
    }

    private TokenList expandAll(TokenSource input, IdentityHashMap<PreprocessorMacro, PreprocessorMacro> forbidden, boolean protectIntrinsics, MacroExpansionTracker tracker) throws OffsetLimitReachedException {
        TokenList result = new TokenList();
        boolean protect = false;
        Token l = null;
        Token t = input.removeFirst();
        while (t != null) {
            switch (t.getType()) {
                case -198: {
                    ((ExpansionBoundary)t).execute(forbidden);
                    break;
                }
                case 1: {
                    char[] image = t.getCharImage();
                    PreprocessorMacro macro = this.fDictionary.get(image);
                    if (protect || tracker != null && tracker.isDone()) {
                        result.append(t);
                        break;
                    }
                    if (protectIntrinsics && Arrays.equals(image, Keywords.cDEFINED)) {
                        t.setType(-200);
                        result.append(t);
                        protect = true;
                        break;
                    }
                    if (protectIntrinsics && Arrays.equals(image, Keywords.c__HAS_FEATURE)) {
                        t.setType(-194);
                        result.append(t);
                        protect = true;
                        break;
                    }
                    if (macro == null || macro.isFunctionStyle() && !input.findLParenthesis()) {
                        if (this.fReportMacros != null) {
                            if (macro != null) {
                                this.fReportMacros.significantMacro(macro);
                            } else if (this.fReportUndefined) {
                                this.fReportMacros.significantMacroUndefined(image);
                            }
                        }
                        result.append(t);
                        break;
                    }
                    if (forbidden.containsKey(macro)) {
                        t.setType(-199);
                        result.append(t);
                        break;
                    }
                    if (this.fLocationMap != null) {
                        ImageLocationInfo info = null;
                        if (this.fLexOptions.fCreateImageLocations) {
                            info = this.createImageLocationInfo(t);
                        }
                        this.fImplicitMacroExpansions.add(this.fLocationMap.encounterImplicitMacroExpansion(macro, info));
                    }
                    TokenList replacement = new TokenList();
                    MacroExpander.addSpacemarker(l, t, replacement);
                    replacement.append(new ExpansionBoundary(macro, true));
                    Token last = this.expandOne(t, macro, forbidden, input, replacement, tracker);
                    replacement.append(new ExpansionBoundary(macro, false));
                    MacroExpander.addSpacemarker(last, input.first(), replacement);
                    input.prepend(replacement);
                    break;
                }
                case -197: 
                case -196: 
                case 8: {
                    result.append(t);
                    break;
                }
                default: {
                    protect = false;
                    result.append(t);
                }
            }
            l = t;
            t = input.removeFirst();
        }
        return result;
    }

    private void addImageLocationInfo(int offset, Token t) {
        ImageLocationInfo info = this.createImageLocationInfo(t);
        if (info != null) {
            info.fTokenOffsetInExpansion = offset;
            this.fImageLocationInfos.add(info);
        }
    }

    private ImageLocationInfo createImageLocationInfo(Token t) {
        if (this.fLocationMap != null) {
            Object s = t.fSource;
            if (s instanceof ObjectStyleMacro) {
                return new ImageLocationInfo.MacroImageLocationInfo((ObjectStyleMacro)s, t.getOffset(), t.getEndOffset());
            }
            if (s instanceof CPreprocessor) {
                int sequenceNumber = this.fLocationMap.getSequenceNumberForOffset(t.getOffset());
                int sequenceEndNumber = this.fLocationMap.getSequenceNumberForOffset(t.getEndOffset());
                return new ImageLocationInfo.ParameterImageLocationInfo(sequenceNumber, sequenceEndNumber);
            }
        }
        return null;
    }

    private static boolean isNeighborInSource(Token l, Token t) {
        return l != null && t != null && l.fSource != null && l.fSource == t.fSource;
    }

    static boolean hasImplicitSpace(Token l, Token t) {
        return MacroExpander.isNeighborInSource(l, t) && l.getEndOffset() != t.getOffset();
    }

    static void addSpacemarker(Token l, Token t, TokenList target) {
        int to;
        int from;
        if (MacroExpander.isNeighborInSource(l, t) && (from = l.getEndOffset()) != (to = t.getOffset())) {
            target.append(new Token(-197, l.fSource, from, to));
        }
        target.append(new Token(-196, null, 0, 0));
    }

    private Token parseArguments(TokenSource input, FunctionStyleMacro macro, IdentityHashMap<PreprocessorMacro, PreprocessorMacro> forbidden, TokenSource[] result, MacroExpansionTracker tracker) throws OffsetLimitReachedException, AbortMacroExpansionException {
        int argCount = macro.getParameterPlaceholderList().length;
        boolean hasVarargs = macro.hasVarArgs() != 0;
        int requiredArgs = hasVarargs ? argCount - 1 : argCount;
        int idx = 0;
        int nesting = -1;
        int i = 0;
        while (i < result.length) {
            result[i] = new TokenSource(null);
            ++i;
        }
        boolean missingRParenthesis = false;
        boolean tooManyArgs = false;
        boolean isFirstOfArg = true;
        Token lastToken = null;
        TokenList spaceMarkers = new TokenList();
        block14: while (true) {
            Token t;
            if ((t = input.fetchFirst()) == null) {
                missingRParenthesis = true;
                break;
            }
            if (tracker != null) {
                switch (t.getType()) {
                    case -198: 
                    case -99: 
                    case 140: 
                    case 144: {
                        break;
                    }
                    default: {
                        tracker.addFunctionStyleMacroExpansionToken(t.clone());
                    }
                }
            }
            lastToken = t;
            switch (t.getType()) {
                case 144: {
                    assert (nesting >= 0);
                    if (this.fCompletionMode) {
                        if (idx < result.length) {
                            throw new CompletionInMacroExpansionException(4, t, result[idx]);
                        }
                        throw new OffsetLimitReachedException(4, null);
                    }
                    missingRParenthesis = true;
                    break block14;
                }
                case 140: {
                    if (idx < result.length) {
                        result[idx].append(t);
                        throw new CompletionInMacroExpansionException(4, t, result[idx]);
                    }
                    throw new OffsetLimitReachedException(4, t);
                }
                case -99: {
                    continue block14;
                }
                case 8: {
                    if (++nesting != 0) break;
                    continue block14;
                }
                case 9: {
                    assert (nesting >= 0);
                    if (--nesting >= 0) break;
                    break block14;
                }
                case 6: {
                    assert (nesting >= 0);
                    if (nesting != 0) break;
                    if (idx < argCount - 1) {
                        isFirstOfArg = true;
                        spaceMarkers.clear();
                        ++idx;
                        continue block14;
                    }
                    if (hasVarargs) break;
                    tooManyArgs = true;
                    break block14;
                }
                case -198: {
                    if (argCount == 0) {
                        ((ExpansionBoundary)t).execute(forbidden);
                        continue block14;
                    }
                    result[idx].append(t);
                    continue block14;
                }
                case -197: 
                case -196: {
                    if (isFirstOfArg) continue block14;
                    spaceMarkers.append(t);
                    continue block14;
                }
                default: {
                    assert (nesting >= 0);
                    break;
                }
            }
            if (argCount == 0) {
                tooManyArgs = true;
                break;
            }
            result[idx].appendAll(spaceMarkers);
            result[idx].append(t);
            isFirstOfArg = false;
        }
        if (missingRParenthesis) {
            this.handleProblem(0x200000C, macro.getNameCharArray());
            throw new AbortMacroExpansionException();
        }
        if (tooManyArgs) {
            this.handleProblem(0x2000009, macro.getNameCharArray());
        } else if (idx + 1 < requiredArgs) {
            this.handleProblem(0x2000009, macro.getNameCharArray());
        }
        return lastToken;
    }

    private void handleProblem(int problemID, char[] arg) {
        this.fLog.handleProblem(problemID, arg, this.fStartOffset, this.fEndOffset);
    }

    private void replaceArgs(PreprocessorMacro macro, TokenList[] args, TokenList[] expandedArgs, TokenList result) {
        TokenList replacement = this.clone(macro.getTokens(this.fDefinitionParser, this.fLexOptions, this));
        Token l = null;
        Token pasteArg1 = null;
        Token t = replacement.first();
        while (t != null) {
            Token n = (Token)t.getNext();
            switch (t.getType()) {
                case -195: {
                    TokenList arg;
                    int idx = ((MacroDefinitionParser.TokenParameterReference)t).getIndex();
                    if (idx >= args.length) break;
                    MacroExpander.addSpacemarker(l, t, result);
                    if (this.isKind(n, 139)) {
                        arg = this.clone(args[idx]);
                        pasteArg1 = arg.last();
                        if (pasteArg1 == null) break;
                        result.appendAllButLast(arg);
                        MacroExpander.addSpacemarker(result.last(), pasteArg1, result);
                        break;
                    }
                    arg = this.clone(expandedArgs[idx]);
                    result.appendAll(arg);
                    MacroExpander.addSpacemarker(t, n, result);
                    break;
                }
                case 138: {
                    int idx;
                    MacroExpander.addSpacemarker(l, t, result);
                    StringBuilder buf = new StringBuilder();
                    buf.append('\"');
                    if (this.isKind(n, -195)) {
                        idx = ((MacroDefinitionParser.TokenParameterReference)n).getIndex();
                        if (idx < args.length) {
                            this.stringify(args[idx], buf);
                        }
                        t = n;
                        n = (Token)n.getNext();
                    }
                    buf.append('\"');
                    int length = buf.length();
                    char[] image = new char[length];
                    buf.getChars(0, length, image, 0);
                    Token generated = new TokenWithImage(130, null, 0, 0, image);
                    if (this.isKind(n, 139)) {
                        pasteArg1 = generated;
                        break;
                    }
                    result.append(generated);
                    MacroExpander.addSpacemarker(t, n, result);
                    break;
                }
                case 139: {
                    int idx;
                    Token pasteArg2 = null;
                    TokenList rest = null;
                    if (n == null) break;
                    Token spaceDef0 = n;
                    Token spaceDef1 = (Token)n.getNext();
                    if (n.getType() == -195) {
                        TokenList arg;
                        idx = ((MacroDefinitionParser.TokenParameterReference)n).getIndex();
                        if (idx < args.length && (pasteArg2 = (arg = this.clone(args[idx])).first()) != null && arg.first() != arg.last()) {
                            spaceDef0 = pasteArg2;
                            rest = arg;
                            rest.removeFirst();
                            spaceDef1 = rest.first();
                        }
                    } else {
                        idx = -1;
                        pasteArg2 = n;
                    }
                    t = n;
                    n = (Token)n.getNext();
                    boolean pasteNext = this.isKind(n, 139);
                    Token generated = this.tokenpaste(pasteArg1, pasteArg2, macro);
                    if (generated == null) {
                        generated = pasteArg1;
                        if (rest == null) {
                            rest = new TokenList();
                        }
                        rest.prepend(pasteArg2);
                        spaceDef0 = generated;
                        spaceDef1 = pasteArg2;
                    }
                    pasteArg1 = null;
                    if (generated != null) {
                        if (pasteNext && rest == null) {
                            pasteArg1 = generated;
                        } else {
                            result.append(generated);
                            MacroExpander.addSpacemarker(spaceDef0, spaceDef1, result);
                        }
                    }
                    if (rest == null) break;
                    if (pasteNext) {
                        pasteArg1 = rest.last();
                        if (pasteArg1 == null) break;
                        result.appendAllButLast(rest);
                        MacroExpander.addSpacemarker(result.last(), pasteArg1, result);
                        break;
                    }
                    result.appendAll(rest);
                    if (idx < 0) break;
                    MacroExpander.addSpacemarker(t, n, result);
                    break;
                }
                case 6: {
                    int idx;
                    if (this.isKind(n, 139)) {
                        Token nn = (Token)n.getNext();
                        if (this.isKind(nn, -195) && (idx = ((MacroDefinitionParser.TokenParameterReference)nn).getIndex()) == args.length - 1 && macro.hasVarArgs() != 0 && !this.isKind(nn.getNext(), 139)) {
                            Token nnn = (Token)nn.getNext();
                            TokenList arg = this.clone(expandedArgs[idx]);
                            if (arg.isEmpty()) {
                                MacroExpander.addSpacemarker(l, t, result);
                                MacroExpander.addSpacemarker(nn, nnn, result);
                            } else {
                                result.append(t);
                                MacroExpander.addSpacemarker(t, n, result);
                                result.appendAll(arg);
                                MacroExpander.addSpacemarker(nn, nnn, result);
                            }
                            t = nn;
                            n = nnn;
                            break;
                        }
                        MacroExpander.addSpacemarker(l, t, result);
                        pasteArg1 = t;
                        break;
                    }
                    result.append(t);
                    break;
                }
                default: {
                    if (this.isKind(n, 139)) {
                        MacroExpander.addSpacemarker(l, t, result);
                        pasteArg1 = t;
                        break;
                    }
                    result.append(t);
                }
            }
            l = t;
            t = n;
        }
    }

    private boolean isKind(IToken t, int kind) {
        return t != null && t.getType() == kind;
    }

    private BitSet getParamUsage(PreprocessorMacro macro) {
        BitSet result = new BitSet();
        TokenList replacement = macro.getTokens(this.fDefinitionParser, this.fLexOptions, this);
        Token l = null;
        Token t = replacement.first();
        while (t != null) {
            Token n = (Token)t.getNext();
            switch (t.getType()) {
                case -195: {
                    int idx = 2 * ((MacroDefinitionParser.TokenParameterReference)t).getIndex();
                    if (!this.isKind(n, 139)) {
                        ++idx;
                    }
                    result.set(idx);
                    break;
                }
                case 138: {
                    if (!this.isKind(n, -195)) break;
                    int idx = ((MacroDefinitionParser.TokenParameterReference)n).getIndex();
                    result.set(2 * idx);
                    t = n;
                    n = (Token)n.getNext();
                    break;
                }
                case 139: {
                    if (!this.isKind(n, -195)) break;
                    int idx = ((MacroDefinitionParser.TokenParameterReference)n).getIndex();
                    if (this.isKind(l, 6) && macro.hasVarArgs() != 0 && idx == macro.getParameterPlaceholderList().length - 1 && !this.isKind(n.getNext(), 139)) {
                        result.set(2 * idx + 1);
                    } else {
                        result.set(2 * idx);
                    }
                    t = n;
                    n = (Token)n.getNext();
                }
            }
            l = t;
            t = n;
        }
        return result;
    }

    private void objStyleTokenPaste(PreprocessorMacro macro, TokenList result) {
        TokenList replacement = this.clone(macro.getTokens(this.fDefinitionParser, this.fLexOptions, this));
        Token l = null;
        Token pasteArg1 = null;
        Token t = replacement.first();
        while (t != null) {
            Token n = (Token)t.getNext();
            switch (t.getType()) {
                case 139: {
                    if (pasteArg1 == null) break;
                    Token pasteArg2 = null;
                    if (n != null) {
                        pasteArg2 = n;
                        n = (Token)n.getNext();
                    }
                    if ((t = this.tokenpaste(pasteArg1, pasteArg2, macro)) == null) break;
                    if (this.isKind(n, 139)) {
                        pasteArg1 = t;
                        break;
                    }
                    result.append(t);
                    MacroExpander.addSpacemarker(pasteArg2, n, result);
                    break;
                }
                default: {
                    if (this.isKind(n, 139)) {
                        MacroExpander.addSpacemarker(l, t, result);
                        pasteArg1 = t;
                        break;
                    }
                    result.append(t);
                }
            }
            l = t;
            t = n;
        }
    }

    private TokenList clone(TokenList tl) {
        TokenList result = new TokenList();
        Token t = tl.first();
        while (t != null) {
            result.append(t.clone());
            t = (Token)t.getNext();
        }
        return result;
    }

    private Token tokenpaste(Token arg1, Token arg2, PreprocessorMacro macro) {
        if (arg1 == null) {
            return arg2;
        }
        if (arg2 == null) {
            return arg1;
        }
        char[] image1 = arg1.getCharImage();
        char[] image2 = arg2.getCharImage();
        int l1 = image1.length;
        int l2 = image2.length;
        char[] image = new char[l1 + l2];
        System.arraycopy(image1, 0, image, 0, l1);
        System.arraycopy(image2, 0, image, l1, l2);
        Lexer lex = new Lexer(image, this.fLexOptions, ILexerLog.NULL, null);
        try {
            Token t1 = lex.nextToken();
            Token t2 = lex.nextToken();
            if (t1.getType() != 144 && t2.getType() == 144) {
                t1.setOffset(arg1.getOffset(), arg2.getEndOffset());
                return t1;
            }
        }
        catch (OffsetLimitReachedException offsetLimitReachedException) {
            // empty catch block
        }
        this.handleProblem(0x200000A, macro.getNameCharArray());
        return null;
    }

    private void stringify(TokenList tokenList, StringBuilder buf) {
        Token t = tokenList.first();
        if (t == null) {
            return;
        }
        Token l = null;
        boolean space = false;
        while (t != null) {
            Token n = (Token)t.getNext();
            if (!space && MacroExpander.hasImplicitSpace(l, t)) {
                buf.append(' ');
                space = true;
            }
            switch (t.getType()) {
                case 130: 
                case 131: 
                case 132: 
                case 133: 
                case 5000: 
                case 5001: 
                case 5002: 
                case 5003: {
                    char[] image;
                    char[] cArray = image = t.getCharImage();
                    int n2 = image.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        char c = cArray[n3];
                        if (c == '\"' || c == '\\') {
                            buf.append('\\');
                        }
                        buf.append(c);
                        ++n3;
                    }
                    space = false;
                    break;
                }
                case -197: {
                    if (space || l == null || n == null) break;
                    buf.append(' ');
                    space = true;
                    break;
                }
                case -196: {
                    break;
                }
                default: {
                    buf.append(t.getCharImage());
                    space = false;
                }
            }
            l = t;
            t = n;
        }
    }

    public IASTName[] clearImplicitExpansions() {
        IASTName[] result = this.fImplicitMacroExpansions.toArray(new IASTName[this.fImplicitMacroExpansions.size()]);
        this.fImplicitMacroExpansions.clear();
        return result;
    }

    public ImageLocationInfo[] clearImageLocationInfos() {
        ImageLocationInfo[] result = this.fImageLocationInfos.toArray(new ImageLocationInfo[this.fImageLocationInfos.size()]);
        this.fImageLocationInfos.clear();
        return result;
    }

    private void postProcessTokens(TokenList replacement) {
        boolean createImageLocations = this.fLexOptions.fCreateImageLocations;
        int offset = 0;
        Token l = null;
        Token t = replacement.first();
        while (t != null) {
            block7: {
                switch (t.getType()) {
                    case -199: {
                        t.setType(1);
                        if (!createImageLocations) break;
                        this.addImageLocationInfo(offset, t);
                        break;
                    }
                    case 1: {
                        if (!createImageLocations) break;
                        this.addImageLocationInfo(offset, t);
                        break;
                    }
                    case -198: 
                    case -197: 
                    case -196: {
                        replacement.removeBehind(l);
                        break block7;
                    }
                    case 140: {
                        t.setOffset(offset, offset + t.getLength());
                        t.setNext(null);
                        return;
                    }
                    default: {
                        if (!createImageLocations || !(t.fSource instanceof CPreprocessor)) break;
                        this.addImageLocationInfo(offset, t);
                    }
                }
                t.setOffset(offset++, offset);
                l = t;
            }
            t = (Token)t.getNext();
        }
    }

    int getCurrentLineNumber() {
        if (this.fFixedInput != null) {
            return this.fFixedLineNumber + this.countNewlines(this.fFixedInput);
        }
        if (this.fLocationMap != null) {
            return this.fLocationMap.getCurrentLineNumber(this.fEndOffset);
        }
        return 0;
    }

    private int countNewlines(char[] input) {
        int nl = 0;
        int i = 0;
        while (i < input.length && i < this.fEndOffset) {
            if (input[i] == '\n') {
                ++nl;
            }
            ++i;
        }
        return nl;
    }

    String getCurrentFilename() {
        if (this.fFixedCurrentFilename != null) {
            return this.fFixedCurrentFilename;
        }
        if (this.fLocationMap != null) {
            return this.fLocationMap.getCurrentFilePath();
        }
        return "";
    }

    private static final class AbortMacroExpansionException
    extends Exception {
        private AbortMacroExpansionException() {
        }
    }

    public static final class ExpansionBoundary
    extends Token {
        private boolean fIsStart;
        private final PreprocessorMacro fMacro;

        ExpansionBoundary(PreprocessorMacro scope, boolean isStart) {
            super(-198, null, 0, 0);
            this.fMacro = scope;
            this.fIsStart = isStart;
        }

        @Override
        public char[] getCharImage() {
            return CharArrayUtils.EMPTY;
        }

        @Override
        public String toString() {
            return "{" + (this.fIsStart ? (char)'+' : '-') + this.fMacro.getName() + '}';
        }

        public void execute(IdentityHashMap<PreprocessorMacro, PreprocessorMacro> forbidden) {
            if (this.fIsStart) {
                forbidden.put(this.fMacro, this.fMacro);
            } else {
                forbidden.remove(this.fMacro);
            }
        }
    }

    private class TokenSource
    extends TokenList {
        private final ITokenSequence fLexer;

        public TokenSource(ITokenSequence lexer) {
            this.fLexer = lexer;
        }

        public Token fetchFirst() throws OffsetLimitReachedException {
            Token t = this.removeFirst();
            if (t == null && this.fLexer != null && (t = this.fLexer.currentToken()).getType() != 144) {
                MacroExpander.this.fEndOffset = t.getEndOffset();
                this.fLexer.nextToken();
            }
            return t;
        }

        public boolean findLParenthesis() throws OffsetLimitReachedException {
            Token t = this.first();
            while (t != null) {
                switch (t.getType()) {
                    case -198: 
                    case -197: 
                    case -196: 
                    case -99: {
                        break;
                    }
                    case 8: {
                        return true;
                    }
                    default: {
                        return false;
                    }
                }
                t = (Token)t.getNext();
            }
            if (this.fLexer != null) {
                t = this.fLexer.currentToken();
                while (t.getType() == -99) {
                    t = this.fLexer.nextToken();
                }
                return t.getType() == 8;
            }
            return false;
        }
    }
}

