/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ISourceFinder;
import org.eclipse.cdt.core.ISymbolReader;
import org.eclipse.cdt.core.model.BinaryFilePresentation;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.model.BinaryFunction;
import org.eclipse.cdt.internal.core.model.BinaryInfo;
import org.eclipse.cdt.internal.core.model.BinaryModule;
import org.eclipse.cdt.internal.core.model.BinaryVariable;
import org.eclipse.cdt.internal.core.model.BufferManager;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CProjectInfo;
import org.eclipse.cdt.internal.core.model.ExternalTranslationUnit;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.cdt.internal.core.util.MementoTokenizer;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class Binary
extends Openable
implements IBinary {
    private int fBinType;
    private String hasDebug;
    private String cpu;
    private String[] needed;
    private long longData;
    private long longText;
    private long longBSS;
    private String endian;
    private String soname;
    private long fLastModification;
    private IBinaryParser.IBinaryObject binaryObject;
    private boolean showInBinaryContainer;

    public Binary(ICElement parent, IFile file, IBinaryParser.IBinaryObject bin) {
        super(parent, (IResource)file, 14);
        this.binaryObject = bin;
        this.showInBinaryContainer = this.determineShowInBinaryContainer(bin);
    }

    private boolean determineShowInBinaryContainer(IBinaryParser.IBinaryObject bin) {
        BinaryFilePresentation presentation = (BinaryFilePresentation)bin.getAdapter(BinaryFilePresentation.class);
        if (presentation != null) {
            return presentation.showInBinaryContainer();
        }
        return BinaryFilePresentation.showInBinaryContainer(bin);
    }

    public Binary(ICElement parent, IPath path, IBinaryParser.IBinaryObject bin) {
        super(parent, path, 14);
        this.binaryObject = bin;
        this.showInBinaryContainer = this.determineShowInBinaryContainer(bin);
    }

    @Override
    public boolean isSharedLib() {
        return this.getType() == 4;
    }

    @Override
    public boolean isExecutable() {
        return this.getType() == 2;
    }

    @Override
    public boolean isObject() {
        return this.getType() == 1;
    }

    @Override
    public boolean isCore() {
        return this.getType() == 16;
    }

    @Override
    public boolean hasDebug() {
        IBinaryParser.IBinaryObject obj;
        if ((this.isObject() || this.isExecutable() || this.isSharedLib()) && (this.hasDebug == null || this.hasChanged()) && (obj = this.getBinaryObject()) != null) {
            this.hasDebug = String.valueOf(obj.hasDebug());
        }
        return Boolean.valueOf(this.hasDebug);
    }

    @Override
    public String getCPU() {
        if ((this.isObject() || this.isExecutable() || this.isSharedLib() || this.isCore()) && (this.cpu == null || this.hasChanged())) {
            IBinaryParser.IBinaryObject obj = this.getBinaryObject();
            this.cpu = obj.getCPU();
        }
        return this.cpu == null ? "" : this.cpu;
    }

    @Override
    public String[] getNeededSharedLibs() {
        IBinaryParser.IBinaryObject obj;
        if ((this.isExecutable() || this.isSharedLib()) && (this.needed == null || this.hasChanged()) && (obj = this.getBinaryObject()) instanceof IBinaryParser.IBinaryExecutable) {
            this.needed = ((IBinaryParser.IBinaryExecutable)obj).getNeededSharedLibs();
        }
        return this.needed == null ? new String[]{} : this.needed;
    }

    @Override
    public long getText() {
        IBinaryParser.IBinaryObject obj;
        if ((this.isObject() || this.isExecutable() || this.isSharedLib()) && (this.longText == -1L || this.hasChanged()) && (obj = this.getBinaryObject()) != null) {
            this.longText = obj.getText();
        }
        return this.longText;
    }

    @Override
    public long getData() {
        IBinaryParser.IBinaryObject obj;
        if ((this.isObject() || this.isExecutable() || this.isSharedLib()) && (this.longData == -1L || this.hasChanged()) && (obj = this.getBinaryObject()) != null) {
            this.longData = obj.getData();
        }
        return this.longData;
    }

    @Override
    public long getBSS() {
        IBinaryParser.IBinaryObject obj;
        if ((this.isObject() || this.isExecutable() || this.isSharedLib()) && (this.longBSS == -1L || this.hasChanged()) && (obj = this.getBinaryObject()) != null) {
            this.longBSS = obj.getBSS();
        }
        return this.longBSS;
    }

    @Override
    public String getSoname() {
        IBinaryParser.IBinaryObject obj;
        if (this.isSharedLib() && (this.soname == null || this.hasChanged()) && (obj = this.getBinaryObject()) instanceof IBinaryParser.IBinaryShared) {
            this.soname = ((IBinaryParser.IBinaryShared)obj).getSoName();
        }
        return this.soname == null ? "" : this.soname;
    }

    @Override
    public boolean isLittleEndian() {
        IBinaryParser.IBinaryObject obj;
        if ((this.isObject() || this.isExecutable() || this.isSharedLib() || this.isCore()) && (this.endian == null || this.hasChanged()) && (obj = this.getBinaryObject()) != null) {
            this.endian = String.valueOf(obj.isLittleEndian());
        }
        return Boolean.valueOf(this.endian);
    }

    protected IBinaryParser.IBinaryObject getBinaryObject() {
        return this.binaryObject;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (IBinaryParser.IBinaryObject.class.equals((Object)adapter)) {
            return this.getBinaryObject();
        }
        return super.getAdapter(adapter);
    }

    protected int getType() {
        IBinaryParser.IBinaryObject obj = this.getBinaryObject();
        if (obj != null && (this.fBinType == 0 || this.hasChanged())) {
            this.fBinType = obj.getType();
        }
        return this.fBinType;
    }

    @Override
    protected boolean hasChanged() {
        long modification = this.getModificationStamp();
        boolean changed = modification != this.fLastModification;
        this.fLastModification = modification;
        if (changed) {
            this.hasDebug = null;
            this.needed = null;
            this.cpu = null;
            this.endian = null;
            this.longBSS = -1L;
            this.longData = -1L;
            this.longText = -1L;
            this.soname = null;
        }
        return changed;
    }

    protected long getModificationStamp() {
        IResource res = this.getResource();
        if (res != null) {
            return res.getModificationStamp();
        }
        return 0L;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public CElementInfo createElementInfo() {
        return new BinaryInfo(this);
    }

    @Override
    protected boolean buildStructure(OpenableInfo info, IProgressMonitor pm, Map<ICElement, CElementInfo> newElements, IResource underlyingResource) throws CModelException {
        return this.computeChildren(info, underlyingResource);
    }

    boolean computeChildren(OpenableInfo info, IResource res) throws CModelException {
        boolean ok = false;
        if (this.isObject() || this.isExecutable() || this.isSharedLib()) {
            HashMap<IPath, BinaryModule> hash = new HashMap<IPath, BinaryModule>();
            IBinaryParser.IBinaryObject obj = this.getBinaryObject();
            if (obj != null) {
                boolean showSourceFiles = Platform.getPreferencesService().getBoolean("org.eclipse.cdt.core", "org.eclipse.cdt.core.showSourceFilesInBinaries", false, null);
                if (!showSourceFiles || !this.addSourceFiles(info, obj, hash)) {
                    IBinaryParser.ISymbol[] symbols;
                    IBinaryParser.ISymbol[] iSymbolArray = symbols = obj.getSymbols();
                    int n = symbols.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IBinaryParser.ISymbol symbol = iSymbolArray[n2];
                        switch (symbol.getType()) {
                            case 1: {
                                this.addFunction(info, symbol, hash);
                                break;
                            }
                            case 2: {
                                this.addVariable(info, symbol, hash);
                            }
                        }
                        ++n2;
                    }
                }
                ok = true;
            }
        }
        return ok;
    }

    private boolean addSourceFiles(OpenableInfo info, IBinaryParser.IBinaryObject obj, Map<IPath, BinaryModule> hash) throws CModelException {
        ISymbolReader symbolreader = (ISymbolReader)obj.getAdapter(ISymbolReader.class);
        if (symbolreader == null) {
            return false;
        }
        String[] sourceFiles = symbolreader.getSourceFiles();
        if (sourceFiles != null && sourceFiles.length > 0) {
            ISourceFinder srcFinder = (ISourceFinder)this.getAdapter(ISourceFinder.class);
            try {
                String[] stringArray = sourceFiles;
                int n = sourceFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    String localPath;
                    String filename = stringArray[n2];
                    if (srcFinder != null && (localPath = srcFinder.toLocalPath(filename)) != null) {
                        filename = localPath;
                    }
                    File file = new File(filename);
                    String id = CoreModel.getRegistedContentTypeId(this.getCProject().getProject(), file.getName());
                    if (id != null) {
                        TranslationUnit tu;
                        IFile wkspFile = null;
                        if (file.isAbsolute()) {
                            IFile[] filesInWP;
                            IFile[] iFileArray = filesInWP = ResourceLookup.findFilesForLocation((IPath)new Path(filename));
                            int n3 = filesInWP.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IFile element = iFileArray[n4];
                                if (element.isAccessible()) {
                                    wkspFile = element;
                                    break;
                                }
                                ++n4;
                            }
                        }
                        if (!info.includesChild(tu = wkspFile != null ? new TranslationUnit((ICElement)this, wkspFile, id) : (file.isAbsolute() ? new ExternalTranslationUnit((ICElement)this, Path.fromOSString((String)filename), id) : new ExternalTranslationUnit((ICElement)this, URIUtil.toURI((String)filename, (boolean)true), id)))) {
                            info.addChild(tu);
                        }
                    }
                    ++n2;
                }
                return true;
            }
            finally {
                if (srcFinder != null) {
                    srcFinder.dispose();
                }
            }
        }
        return false;
    }

    private void addFunction(OpenableInfo info, IBinaryParser.ISymbol symbol, Map<IPath, BinaryModule> hash) throws CModelException {
        IPath filename = symbol.getFilename();
        BinaryFunction function = null;
        if (filename != null && !filename.isEmpty()) {
            BinaryModule module = null;
            if (hash.containsKey(filename)) {
                module = hash.get(filename);
            } else {
                module = new BinaryModule(this, filename);
                hash.put(filename, module);
                info.addChild(module);
            }
            function = new BinaryFunction((ICElement)module, symbol.getName(), symbol.getAddress());
            function.setLines(symbol.getStartLine(), symbol.getEndLine());
            module.addChild(function);
        } else {
            function = new BinaryFunction((ICElement)this, symbol.getName(), symbol.getAddress());
            function.setLines(symbol.getStartLine(), symbol.getEndLine());
            info.addChild(function);
        }
    }

    private void addVariable(OpenableInfo info, IBinaryParser.ISymbol symbol, Map<IPath, BinaryModule> hash) throws CModelException {
        IPath filename = symbol.getFilename();
        BinaryVariable variable = null;
        if (filename != null && !filename.isEmpty()) {
            BinaryModule module = null;
            if (hash.containsKey(filename)) {
                module = hash.get(filename);
            } else {
                module = new BinaryModule(this, filename);
                hash.put(filename, module);
                info.addChild(module);
            }
            variable = new BinaryVariable((ICElement)module, symbol.getName(), symbol.getAddress());
            variable.setLines(symbol.getStartLine(), symbol.getEndLine());
            module.addChild(variable);
        } else {
            variable = new BinaryVariable((ICElement)this, symbol.getName(), symbol.getAddress());
            variable.setLines(symbol.getStartLine(), symbol.getEndLine());
            info.addChild(variable);
        }
    }

    @Override
    public IBuffer getBuffer() throws CModelException {
        if (this.hasBuffer()) {
            IBuffer buffer = this.getBufferManager().getBuffer(this);
            if (buffer == null) {
                buffer = this.openBuffer(null);
            }
            return buffer;
        }
        return null;
    }

    @Override
    protected IBuffer openBuffer(IProgressMonitor pm) throws CModelException {
        BufferManager bufManager = this.getBufferManager();
        IBuffer buffer = this.getBufferFactory().createBuffer(this);
        if (buffer == null) {
            return null;
        }
        if (buffer.getCharacters() == null) {
            IBinaryParser.IBinaryObject bin = this.getBinaryObject();
            if (bin != null) {
                StringBuilder sb = new StringBuilder();
                try {
                    int len;
                    BufferedReader stream = new BufferedReader(new InputStreamReader(bin.getContents()));
                    char[] buf = new char[512];
                    while ((len = stream.read(buf, 0, buf.length)) != -1) {
                        sb.append(buf, 0, len);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                buffer.setContents(sb.toString());
            } else {
                IResource file = this.getResource();
                if (file != null && file.getType() == 1) {
                    buffer.setContents(Util.getResourceContentsAsCharArray((IFile)file));
                }
            }
        }
        bufManager.addBuffer(buffer);
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    @Override
    protected boolean hasBuffer() {
        return true;
    }

    @Override
    public boolean exists() {
        IResource res = this.getResource();
        if (res != null) {
            return res.exists();
        }
        return super.exists();
    }

    @Override
    protected void closing(Object info) throws CModelException {
        ICProject cproject = this.getCProject();
        CProjectInfo pinfo = (CProjectInfo)CModelManager.getDefault().peekAtInfo(cproject);
        if (pinfo != null && pinfo.vBin != null) {
            pinfo.vBin.removeChild(this);
        }
        super.closing(info);
    }

    @Override
    public boolean showInBinaryContainer() {
        return this.showInBinaryContainer;
    }

    @Override
    public ICElement getHandleFromMemento(String token, MementoTokenizer memento) {
        return null;
    }

    @Override
    public String getHandleMemento() {
        return null;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        Assert.isTrue((boolean)false, (String)"Should not be called");
        return '\u0000';
    }
}

