/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.Arrays;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IProblemBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNameSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBaseClause;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClassType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitConstructor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPImplicitMethod;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPInheritedConstructor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPReferenceType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ImplicitsAnalysis;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.parser.util.ContentAssistMatcherFactory;

public class CPPClassScope
extends CPPScope
implements ICPPClassScope {
    private static final ICPPFunctionType DESTRUCTOR_FUNCTION_TYPE = CPPVisitor.createImplicitFunctionType(CPPBasicType.UNSPECIFIED_TYPE, ICPPParameter.EMPTY_CPPPARAMETER_ARRAY, false, false);
    private ICPPMethod[] implicits;

    public CPPClassScope(ICPPASTCompositeTypeSpecifier physicalNode) {
        super(physicalNode);
    }

    @Override
    public EScopeKind getKind() {
        return EScopeKind.eClassType;
    }

    public void createImplicitMembers() {
        CPPImplicitMethod m;
        ICPPASTCompositeTypeSpecifier compTypeSpec = (ICPPASTCompositeTypeSpecifier)this.getPhysicalNode();
        IASTName name = compTypeSpec.getName().getLastName();
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof ICPPClassType)) {
            return;
        }
        ICPPClassType classType = (ICPPClassType)binding;
        if (classType instanceof ICPPClassTemplate) {
            classType = (ICPPClassType)((Object)((ICPPClassTemplate)classType).asDeferredInstance());
        }
        char[] className = name.getLookupKey();
        CPPReferenceType pType = new CPPReferenceType(SemanticUtil.constQualify(classType), false);
        IParameter[] params = new ICPPParameter[]{new CPPParameter(pType, 0)};
        int i = 0;
        ImplicitsAnalysis ia = new ImplicitsAnalysis(compTypeSpec, classType);
        this.implicits = new ICPPMethod[ia.getImplicitsToDeclareCount()];
        if (!ia.hasUserDeclaredConstructor()) {
            boolean isConstexpr = ia.isDefaultConstructorConstexpr();
            m = new CPPImplicitConstructor(this, className, ICPPParameter.EMPTY_CPPPARAMETER_ARRAY, isConstexpr);
            this.implicits[i++] = m;
            this.addBinding(m);
        }
        if (!ia.hasUserDeclaredCopyConstructor()) {
            CPPImplicitConstructor m2 = new CPPImplicitConstructor(this, className, (ICPPParameter[])params, false);
            this.implicits[i++] = m2;
            this.addBinding(m2);
        }
        if (!ia.hasUserDeclaredCopyAssignmentOperator()) {
            CPPReferenceType refType = new CPPReferenceType(classType, false);
            ICPPFunctionType ft = CPPVisitor.createImplicitFunctionType(refType, params, false, false);
            CPPImplicitMethod m3 = new CPPImplicitMethod(this, OverloadableOperator.ASSIGN.toCharArray(), ft, (ICPPParameter[])params, false);
            this.implicits[i++] = m3;
            this.addBinding(m3);
        }
        if (!ia.hasUserDeclaredDestructor()) {
            char[] dtorName = CharArrayUtils.concat("~".toCharArray(), className);
            m = new CPPImplicitMethod(this, dtorName, DESTRUCTOR_FUNCTION_TYPE, ICPPParameter.EMPTY_CPPPARAMETER_ARRAY, false);
            this.implicits[i++] = m;
            this.addBinding(m);
        }
        ICPPBase[] inheritedConstructorsSources = this.findInheritedConstructorsSourceBases(compTypeSpec);
        Object[] inheritedConstructors = CPPClassScope.createInheritedConsructors(this, className, inheritedConstructorsSources, ia.getParametersOfNontrivialUserDeclaredConstructors(), compTypeSpec);
        this.implicits = ArrayUtil.addAll(this.implicits, inheritedConstructors);
        Object[] objectArray = inheritedConstructors;
        int n = inheritedConstructors.length;
        int n2 = 0;
        while (n2 < n) {
            Object ctor = objectArray[n2];
            this.addBinding((IBinding)ctor);
            ++n2;
        }
    }

    private ICPPBase[] findInheritedConstructorsSourceBases(ICPPASTCompositeTypeSpecifier compositeTypeSpec) {
        ICPPBase[] bases = ClassTypeHelper.getBases(this.getClassType(), compositeTypeSpec);
        if (bases.length == 0) {
            return bases;
        }
        ICPPBase[] results = ICPPBase.EMPTY_BASE_ARRAY;
        IASTDeclaration[] members = compositeTypeSpec.getMembers();
        int n = 0;
        IASTDeclaration[] iASTDeclarationArray = members;
        int n2 = members.length;
        int n3 = 0;
        while (n3 < n2) {
            ICPPASTQualifiedName qName;
            ICPPASTNameSpecifier[] qualifier;
            IBinding parent;
            IASTName name;
            IASTDeclaration member = iASTDeclarationArray[n3];
            if (member instanceof ICPPASTUsingDeclaration && (name = ((ICPPASTUsingDeclaration)member).getName()) instanceof ICPPASTQualifiedName && (parent = (qualifier = (qName = (ICPPASTQualifiedName)name).getQualifier())[qualifier.length - 1].resolveBinding()) instanceof IType && !(parent instanceof IProblemBinding) && CPPClassScope.isConstructorNameForType(qName.getLastName().getSimpleID(), (IType)((Object)parent))) {
                IType type = SemanticUtil.getNestedType((IType)((Object)parent), 1);
                ICPPBase[] iCPPBaseArray = bases;
                int n4 = bases.length;
                int n5 = 0;
                while (n5 < n4) {
                    ICPPBase base = iCPPBaseArray[n5];
                    IType baseClass = base.getBaseClassType();
                    if (type.isSameType(baseClass)) {
                        ((CPPBaseClause)base).setInheritedConstructorsSource(true);
                        results = ArrayUtil.appendAt(results, n++, base);
                    }
                    ++n5;
                }
            }
            ++n3;
        }
        return ArrayUtil.trim(results, n);
    }

    private static boolean isConstructorNameForType(char[] lastName, IType type) {
        while (type instanceof IBinding) {
            if (Arrays.equals(((IBinding)((Object)type)).getNameCharArray(), lastName)) {
                return true;
            }
            if (!(type instanceof ITypedef)) break;
            type = ((ITypedef)type).getType();
        }
        return false;
    }

    static ICPPMethod[] createInheritedConsructors(ICPPClassScope scope, char[] className, ICPPBase[] bases, IType[][] existingConstructorParamTypes, IASTNode point) {
        ICPPMethod[] inheritedConstructors = ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        int n = 0;
        ICPPBase[] iCPPBaseArray = bases;
        int n2 = bases.length;
        int n3 = 0;
        while (n3 < n2) {
            IBinding baseClass;
            ICPPBase base = iCPPBaseArray[n3];
            if (base.isInheritedConstructorsSource() && (baseClass = base.getBaseClass()) instanceof ICPPClassType) {
                ICPPConstructor[] ctors;
                ICPPConstructor[] iCPPConstructorArray = ctors = ClassTypeHelper.getConstructors((ICPPClassType)baseClass, point);
                int n4 = ctors.length;
                int n5 = 0;
                while (n5 < n4) {
                    ICPPConstructor ctor = iCPPConstructorArray[n5];
                    ICPPParameter[] prototypeParams = ctor.getParameters();
                    int k = Math.max(ctor.getRequiredArgumentCount(), 1);
                    while (k <= prototypeParams.length) {
                        if (!(k == 1 && CPPClassScope.isReferenceToClass(prototypeParams[0].getType(), (ICPPClassType)baseClass) || CPPClassScope.findMatchingSignature(prototypeParams, k, existingConstructorParamTypes) >= 0)) {
                            ICPPParameter[] params = CPPClassScope.deriveParameters(prototypeParams, k);
                            CPPInheritedConstructor inheritedConstructor = new CPPInheritedConstructor(scope, className, ctor, params);
                            inheritedConstructors = ArrayUtil.appendAt(inheritedConstructors, n++, inheritedConstructor);
                        }
                        ++k;
                    }
                    ++n5;
                }
            }
            ++n3;
        }
        return ArrayUtil.trim(inheritedConstructors, n);
    }

    private static ICPPParameter[] deriveParameters(ICPPParameter[] prototypes, int count) {
        ICPPParameter[] params = new ICPPParameter[count];
        int i = 0;
        while (i < count) {
            params[i] = new CPPParameter(prototypes[i].getType(), i);
            ++i;
        }
        return params;
    }

    private static boolean isReferenceToClass(IType type, IType classType) {
        if ((type = SemanticUtil.getNestedType(type, 1)) instanceof ICPPReferenceType && !((ICPPReferenceType)type).isRValueReference()) {
            type = SemanticUtil.getNestedType(type, 13);
            return classType.isSameType(type);
        }
        return false;
    }

    private static int findMatchingSignature(ICPPParameter[] params, int numParams, IType[][] paramTypes) {
        int i = 0;
        while (i < paramTypes.length) {
            if (CPPClassScope.doParameterTypesMatch(params, numParams, paramTypes[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static boolean doParameterTypesMatch(ICPPParameter[] params, int numParams, IType[] types) {
        if (numParams != types.length) {
            return false;
        }
        int i = 0;
        while (i < numParams) {
            if (!params[i].getType().isSameType(types[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public IScope getParent() {
        ICPPASTCompositeTypeSpecifier compType = (ICPPASTCompositeTypeSpecifier)this.getPhysicalNode();
        IASTName compName = compType.getName().getLastName();
        return CPPVisitor.getContainingNonTemplateScope(compName);
    }

    @Override
    public void addBinding(IBinding binding) {
        if (binding instanceof ICPPConstructor) {
            this.addConstructor(binding);
            return;
        }
        super.addBinding(binding);
    }

    @Override
    public void addName(IASTName name) {
        IASTNode parent;
        if (!name.isActive()) {
            return;
        }
        if (name instanceof ICPPASTQualifiedName) {
            IBinding b = this.getClassType();
            ICPPASTQualifiedName qname = (ICPPASTQualifiedName)name;
            ICPPASTNameSpecifier[] qualifier = qname.getQualifier();
            int i = qualifier.length;
            while (--i >= 0) {
                char[] segmentName;
                if (b == null) {
                    return;
                }
                if (qualifier[i] instanceof IASTName) {
                    segmentName = ((IASTName)((Object)qualifier[i])).getLookupKey();
                } else {
                    IBinding segmentBinding = qualifier[i].resolveBinding();
                    if (segmentBinding == null) {
                        return;
                    }
                    segmentName = segmentBinding.getNameCharArray();
                }
                if (!CharArrayUtils.equals(segmentName, b.getNameCharArray())) {
                    return;
                }
                b = b.getOwner();
            }
            if (qname.isFullyQualified() && b != null) {
                return;
            }
        }
        if ((parent = name.getParent()) instanceof IASTDeclarator && CPPVisitor.isConstructor(this, (IASTDeclarator)parent)) {
            this.addConstructor(name);
            return;
        }
        super.addName(name);
    }

    private void addConstructor(Object constructor) {
        Object o;
        if (this.bindings == null) {
            this.bindings = new CharArrayObjectMap(1);
        }
        if ((o = this.bindings.get(CONSTRUCTOR_KEY)) != null) {
            if (o instanceof ObjectSet) {
                ((ObjectSet)o).put(constructor);
            } else {
                ObjectSet<Object> set = new ObjectSet<Object>(2);
                set.put(o);
                set.put(constructor);
                this.bindings.put(CONSTRUCTOR_KEY, set);
            }
        } else {
            this.bindings.put(CONSTRUCTOR_KEY, constructor);
        }
    }

    @Override
    public IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet fileSet) {
        char[] c = name.getLookupKey();
        ICPPASTCompositeTypeSpecifier compType = (ICPPASTCompositeTypeSpecifier)this.getPhysicalNode();
        IASTName compName = compType.getName().getLastName();
        if (compName instanceof ICPPASTTemplateId) {
            compName = ((ICPPASTTemplateId)compName).getTemplateName();
        }
        if (CharArrayUtils.equals(c, compName.getLookupKey())) {
            return compName.resolveBinding();
        }
        return super.getBinding(name, resolve, fileSet);
    }

    @Override
    public IBinding[] getBindings(IScope.ScopeLookupData lookup) {
        char[] c = lookup.getLookupKey();
        boolean prefixLookup = lookup.isPrefixLookup();
        ICPPASTCompositeTypeSpecifier compType = (ICPPASTCompositeTypeSpecifier)this.getPhysicalNode();
        IASTName compName = compType.getName().getLastName();
        if (compName instanceof ICPPASTTemplateId) {
            compName = ((ICPPASTTemplateId)compName).getTemplateName();
        }
        IBinding[] result = IBinding.EMPTY_BINDING_ARRAY;
        int n = 0;
        if (!prefixLookup && CharArrayUtils.equals(c, compName.getLookupKey()) || prefixLookup && ContentAssistMatcherFactory.getInstance().match(c, compName.getLookupKey())) {
            IASTName lookupName = lookup.getLookupName();
            if (CPPClassScope.shallReturnConstructors(lookupName, prefixLookup)) {
                Object[] constructors = this.getConstructors(lookupName, lookup.isResolve());
                result = ArrayUtil.addAll(result, constructors);
                n += constructors.length;
            }
            result = ArrayUtil.appendAt(result, n++, compName.resolveBinding());
        }
        Object[] bindings = super.getBindings(lookup);
        result = ArrayUtil.addAll(result, bindings);
        return ArrayUtil.trim(result, n += bindings.length);
    }

    protected static boolean shouldResolve(boolean force, IASTName candidate, IASTName forName) {
        if (!force || candidate == forName) {
            return false;
        }
        if (forName == null) {
            return true;
        }
        return forName.isReference() || CPPSemantics.declaredBefore(candidate, forName, false);
    }

    @Override
    public ICPPConstructor[] getConstructors() {
        return this.getConstructors(null, true);
    }

    private ICPPConstructor[] getConstructors(IASTName forName, boolean forceResolve) {
        this.populateCache();
        CharArrayObjectMap nameMap = this.bindings;
        if (nameMap == null) {
            return ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
        }
        Object o = nameMap.get(CONSTRUCTOR_KEY);
        if (o != null) {
            IBinding binding = null;
            if (o instanceof ObjectSet) {
                ObjectSet set = (ObjectSet)o;
                ICPPConstructor[] bs = ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
                int n = 0;
                int i = 0;
                while (i < set.size()) {
                    Object obj = set.keyAt(i);
                    if (obj instanceof IASTName) {
                        IASTName name = (IASTName)obj;
                        IBinding iBinding = binding = CPPClassScope.shouldResolve(forceResolve, name, forName) ? name.resolveBinding() : name.getBinding();
                        if (binding instanceof ICPPConstructor) {
                            bs = ArrayUtil.appendAt(bs, n++, (ICPPConstructor)binding);
                        }
                    } else if (obj instanceof ICPPConstructor) {
                        bs = ArrayUtil.appendAt(bs, n++, (ICPPConstructor)obj);
                    }
                    ++i;
                }
                return ArrayUtil.trim(bs, n);
            }
            if (o instanceof IASTName) {
                if (CPPClassScope.shouldResolve(forceResolve, (IASTName)o, forName) || ((IASTName)o).getBinding() != null) {
                    nameMap.put(CONSTRUCTOR_KEY, o);
                    binding = ((IASTName)o).resolveBinding();
                }
            } else if (o instanceof IBinding) {
                binding = (IBinding)o;
            }
            if (binding != null && binding instanceof ICPPConstructor) {
                return new ICPPConstructor[]{(ICPPConstructor)binding};
            }
        }
        return ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
    }

    @Override
    public IBinding[] find(String name, IASTTranslationUnit tu) {
        return this.find(name);
    }

    @Override
    public IBinding[] find(String name) {
        char[] n = name.toCharArray();
        ICPPASTCompositeTypeSpecifier compType = (ICPPASTCompositeTypeSpecifier)this.getPhysicalNode();
        IASTName compName = compType.getName().getLastName();
        if (compName instanceof ICPPASTTemplateId) {
            compName = ((ICPPASTTemplateId)compName).getTemplateName();
        }
        if (CharArrayUtils.equals(compName.getLookupKey(), n)) {
            return new IBinding[]{compName.resolveBinding()};
        }
        return super.find(name);
    }

    public static boolean shallReturnConstructors(IASTName name, boolean isPrefixLookup) {
        if (name == null) {
            return false;
        }
        if (!isPrefixLookup) {
            return CPPVisitor.isConstructorDeclaration(name) || CPPVisitor.isLastNameInUsingDeclaration(name);
        }
        IASTNode node = name.getParent();
        if (node instanceof ICPPASTTemplateId) {
            return false;
        }
        if (node instanceof ICPPASTQualifiedName) {
            if (((ICPPASTQualifiedName)node).getLastName() == name) {
                node = node.getParent();
            } else {
                return false;
            }
        }
        if (node instanceof IASTDeclSpecifier) {
            IASTNode parent = node.getParent();
            return parent instanceof IASTTypeId && parent.getParent() instanceof ICPPASTNewExpression;
        }
        return !(node instanceof IASTFieldReference);
    }

    @Override
    public ICPPClassType getClassType() {
        ICPPASTCompositeTypeSpecifier compSpec = (ICPPASTCompositeTypeSpecifier)this.getPhysicalNode();
        IASTName name = compSpec.getName();
        IBinding binding = name.resolveBinding();
        if (binding instanceof ICPPClassType) {
            return (ICPPClassType)binding;
        }
        return new CPPClassType.CPPClassTypeProblem((IASTNode)name, 16, name.toCharArray());
    }

    @Override
    public ICPPMethod[] getImplicitMethods() {
        if (this.implicits == null) {
            return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        }
        return this.implicits;
    }

    @Override
    public IName getScopeName() {
        IASTNode node = this.getPhysicalNode();
        if (node instanceof ICPPASTCompositeTypeSpecifier) {
            return ((ICPPASTCompositeTypeSpecifier)node).getName();
        }
        return null;
    }
}

