/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.parser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.parser.AbstractScannerExtensionConfiguration;
import org.eclipse.cdt.core.dom.parser.CLanguageKeywords;
import org.eclipse.cdt.core.dom.parser.IScannerExtensionConfiguration;
import org.eclipse.cdt.core.dom.parser.ISourceCodeParser;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.AbstractLanguage;
import org.eclipse.cdt.core.model.ICLanguageKeywords;
import org.eclipse.cdt.core.model.IContributedModelBuilder;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IParserSettings;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IncludeFileContentProvider;
import org.eclipse.cdt.core.parser.ParseError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.internal.core.parser.scanner.CPreprocessor;
import org.eclipse.cdt.internal.core.util.ICancelable;
import org.eclipse.cdt.internal.core.util.ICanceler;
import org.eclipse.core.runtime.CoreException;

public abstract class AbstractCLikeLanguage
extends AbstractLanguage
implements ICLanguageKeywords {
    private static final AbstractScannerExtensionConfiguration DUMMY_SCANNER_EXTENSION_CONFIGURATION = new AbstractScannerExtensionConfiguration(){};
    private ICLanguageKeywords cLanguageKeywords;

    @Deprecated
    protected IScannerExtensionConfiguration getScannerExtensionConfiguration() {
        return DUMMY_SCANNER_EXTENSION_CONFIGURATION;
    }

    protected IScannerExtensionConfiguration getScannerExtensionConfiguration(IScannerInfo info) {
        return this.getScannerExtensionConfiguration();
    }

    protected abstract ISourceCodeParser createParser(IScanner var1, ParserMode var2, IParserLogService var3, IIndex var4);

    protected ISourceCodeParser createParser(IScanner scanner, ParserMode parserMode, IParserLogService logService, IIndex index, int options, IParserSettings settings) {
        return this.createParser(scanner, parserMode, logService, index);
    }

    protected abstract ParserLanguage getParserLanguage();

    @Override
    @Deprecated
    public IASTTranslationUnit getASTTranslationUnit(CodeReader reader, IScannerInfo scanInfo, ICodeReaderFactory fileCreator, IIndex index, IParserLogService log) throws CoreException {
        return this.getASTTranslationUnit(reader, scanInfo, fileCreator, index, 0, log);
    }

    @Override
    @Deprecated
    public IASTTranslationUnit getASTTranslationUnit(CodeReader reader, IScannerInfo scanInfo, ICodeReaderFactory codeReaderFactory, IIndex index, int options, IParserLogService log) throws CoreException {
        return this.getASTTranslationUnit(FileContent.adapt(reader), scanInfo, IncludeFileContentProvider.adapt(codeReaderFactory), index, options, log);
    }

    @Override
    public IASTTranslationUnit getASTTranslationUnit(FileContent reader, IScannerInfo scanInfo, IncludeFileContentProvider fileCreator, IIndex index, int options, IParserLogService log) throws CoreException {
        final IScanner scanner = this.createScanner(reader, scanInfo, fileCreator, log);
        scanner.setComputeImageLocations((options & 4) == 0);
        scanner.setProcessInactiveCode((options & 0x20) != 0);
        IParserSettings parserSettings = null;
        if (scanInfo instanceof ExtendedScannerInfo) {
            ExtendedScannerInfo extendedScannerInfo = (ExtendedScannerInfo)scanInfo;
            parserSettings = extendedScannerInfo.getParserSettings();
        }
        final ISourceCodeParser parser = this.createParser(scanner, log, index, false, options, parserSettings);
        ICanceler canceler = null;
        if (log instanceof ICanceler) {
            canceler = (ICanceler)((Object)log);
            canceler.setCancelable(new ICancelable(){

                @Override
                public void cancel() {
                    scanner.cancel();
                    parser.cancel();
                }
            });
        }
        try {
            IASTTranslationUnit ast = parser.parse();
            ast.setIsHeaderUnit((options & 8) == 0);
            IASTTranslationUnit iASTTranslationUnit = ast;
            return iASTTranslationUnit;
        }
        catch (ParseError e) {
            if (e.getErrorKind() != ParseError.ParseErrorKind.TOO_MANY_TOKENS) {
                throw e;
            }
            if (log != null) {
                String tuName = null;
                if (scanner.getLocationResolver() != null) {
                    tuName = scanner.getLocationResolver().getTranslationUnitPath();
                }
                log.traceLog(String.valueOf(e.getMessage()) + (tuName == null ? "" : " while parsing " + tuName));
            }
            return null;
        }
        finally {
            if (canceler != null) {
                canceler.setCancelable(null);
            }
        }
    }

    @Override
    @Deprecated
    public IASTCompletionNode getCompletionNode(CodeReader reader, IScannerInfo scanInfo, ICodeReaderFactory fileCreator, IIndex index, IParserLogService log, int offset) throws CoreException {
        return this.getCompletionNode(FileContent.adapt(reader), scanInfo, IncludeFileContentProvider.adapt(fileCreator), index, log, offset);
    }

    @Override
    public IASTCompletionNode getCompletionNode(FileContent reader, IScannerInfo scanInfo, IncludeFileContentProvider fileCreator, IIndex index, IParserLogService log, int offset) throws CoreException {
        IScanner scanner = this.createScanner(reader, scanInfo, fileCreator, log);
        scanner.setContentAssistMode(offset);
        ISourceCodeParser parser = this.createParser(scanner, log, index, true, 0);
        parser.parse();
        IASTCompletionNode node = parser.getCompletionNode();
        return node;
    }

    protected ISourceCodeParser createParser(IScanner scanner, IParserLogService log, IIndex index, boolean forCompletion, int options) {
        ParserMode mode = this.createParserMode(forCompletion, options);
        return this.createParser(scanner, mode, log, index);
    }

    protected ISourceCodeParser createParser(IScanner scanner, IParserLogService log, IIndex index, boolean forCompletion, int options, IParserSettings settings) {
        ParserMode mode = this.createParserMode(forCompletion, options);
        return this.createParser(scanner, mode, log, index, options, settings);
    }

    private ParserMode createParserMode(boolean forCompletion, int options) {
        if (forCompletion) {
            return ParserMode.COMPLETION_PARSE;
        }
        if ((options & 1) != 0) {
            return ParserMode.STRUCTURAL_PARSE;
        }
        return ParserMode.COMPLETE_PARSE;
    }

    @Deprecated
    protected IScanner createScanner(CodeReader reader, IScannerInfo scanInfo, ICodeReaderFactory fileCreator, IParserLogService log) {
        return this.createScanner(FileContent.adapt(reader), scanInfo, IncludeFileContentProvider.adapt(fileCreator), log);
    }

    protected final IScanner createScanner(FileContent content, IScannerInfo scanInfo, IncludeFileContentProvider fcp, IParserLogService log) {
        return new CPreprocessor(content, scanInfo, this.getParserLanguage(), log, this.getScannerExtensionConfiguration(scanInfo), fcp);
    }

    @Override
    @Deprecated
    public IASTName[] getSelectedNames(IASTTranslationUnit ast, int start, int length) {
        IASTNode selectedNode = ast.getNodeSelector(null).findNode(start, length);
        if (selectedNode == null) {
            return new IASTName[0];
        }
        if (selectedNode instanceof IASTName) {
            return new IASTName[]{(IASTName)selectedNode};
        }
        if (selectedNode instanceof IASTPreprocessorMacroExpansion) {
            return new IASTName[]{((IASTPreprocessorMacroExpansion)selectedNode).getMacroReference()};
        }
        NameCollector collector = new NameCollector();
        selectedNode.accept(collector);
        return collector.getNames();
    }

    @Override
    public IContributedModelBuilder createModelBuilder(ITranslationUnit tu) {
        return null;
    }

    private synchronized ICLanguageKeywords getCLanguageKeywords() {
        if (this.cLanguageKeywords == null) {
            this.cLanguageKeywords = new CLanguageKeywords(this.getParserLanguage(), this.getScannerExtensionConfiguration(new ExtendedScannerInfo()));
        }
        return this.cLanguageKeywords;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(ICLanguageKeywords.class)) {
            return (T)this.getCLanguageKeywords();
        }
        return (T)super.getAdapter(adapter);
    }

    @Override
    public String[] getBuiltinTypes() {
        return this.getCLanguageKeywords().getBuiltinTypes();
    }

    @Override
    public String[] getKeywords() {
        return this.getCLanguageKeywords().getKeywords();
    }

    @Override
    public String[] getPreprocessorKeywords() {
        return this.getCLanguageKeywords().getPreprocessorKeywords();
    }

    static class NameCollector
    extends ASTVisitor {
        private List<IASTName> nameList;

        NameCollector() {
            this.shouldVisitNames = true;
            this.nameList = new ArrayList<IASTName>();
        }

        @Override
        public int visit(IASTName name) {
            this.nameList.add(name);
            return 3;
        }

        public IASTName[] getNames() {
            return this.nameList.toArray(new IASTName[this.nameList.size()]);
        }
    }
}

