/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.console;

import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.ConsoleSaveAction;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.TracingConsole;
import org.eclipse.cdt.dsf.gdb.launching.GDBProcess;
import org.eclipse.cdt.dsf.gdb.launching.InferiorRuntimeProcess;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.console.IConsolePageParticipant;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.part.IPageBookViewPage;

public class ConsolePageParticipant
implements IConsolePageParticipant,
IDebugContextListener {
    private org.eclipse.ui.console.IConsole fConsole;
    private IPageBookViewPage fPage;
    private IConsoleView fView;

    public void init(IPageBookViewPage page, org.eclipse.ui.console.IConsole console) {
        this.fPage = page;
        this.fConsole = console;
        this.fView = (IConsoleView)this.fPage.getSite().getPage().findView("org.eclipse.ui.console.ConsoleView");
        if (this.isConsoleInferior(console) || this.isConsoleGdbCli(console)) {
            DebugUITools.getDebugContextManager().getContextService(this.fPage.getSite().getWorkbenchWindow()).addDebugContextListener((IDebugContextListener)this);
        }
        if (console instanceof TracingConsole || this.isConsoleGdbCli(console)) {
            TextConsole textConsole = (TextConsole)console;
            IToolBarManager toolBarManager = page.getSite().getActionBars().getToolBarManager();
            toolBarManager.appendToGroup("outputGroup", (IContributionItem)new Separator());
            ConsoleSaveAction saveConsole = new ConsoleSaveAction(textConsole);
            toolBarManager.appendToGroup("outputGroup", (IAction)saveConsole);
            toolBarManager.appendToGroup("outputGroup", (IContributionItem)new Separator());
        }
    }

    private boolean isConsoleGdbCli(org.eclipse.ui.console.IConsole console) {
        if (console instanceof IConsole) {
            IConsole debugConsole = (IConsole)console;
            return debugConsole.getProcess() instanceof GDBProcess;
        }
        return false;
    }

    private boolean isConsoleInferior(org.eclipse.ui.console.IConsole console) {
        if (console instanceof IConsole) {
            IConsole debugConsole = (IConsole)console;
            return debugConsole.getProcess() instanceof InferiorRuntimeProcess;
        }
        return false;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public void dispose() {
        if (this.isConsoleInferior(this.fConsole) || this.isConsoleGdbCli(this.fConsole)) {
            DebugUITools.getDebugContextManager().getContextService(this.fPage.getSite().getWorkbenchWindow()).removeDebugContextListener((IDebugContextListener)this);
        }
        this.fConsole = null;
    }

    public void activated() {
    }

    public void deactivated() {
    }

    protected IProcess getConsoleProcess() {
        if (this.fConsole instanceof IConsole) {
            return ((IConsole)this.fConsole).getProcess();
        }
        return null;
    }

    protected IProcess getCurrentProcess() {
        IProcess[] processes;
        ILaunch launch;
        IDMContext dmc;
        IMIContainerDMContext container;
        IAdaptable context = DebugUITools.getDebugContext();
        if (context instanceof ILaunch) {
            ILaunch launch2 = (ILaunch)context;
            IProcess[] processes2 = launch2.getProcesses();
            if (processes2 != null && processes2.length > 0) {
                IProcess[] iProcessArray = processes2;
                int n = processes2.length;
                int n2 = 0;
                while (n2 < n) {
                    IProcess process = iProcessArray[n2];
                    if (process instanceof InferiorRuntimeProcess) {
                        return process;
                    }
                    ++n2;
                }
                if (processes2[0] instanceof GDBProcess) {
                    return processes2[0];
                }
            }
            return null;
        }
        if (context != null && (container = (IMIContainerDMContext)DMContexts.getAncestorOfType((IDMContext)(dmc = (IDMContext)context.getAdapter(IDMContext.class)), IMIContainerDMContext.class)) != null && (launch = (ILaunch)context.getAdapter(ILaunch.class)) != null && (processes = launch.getProcesses()) != null && processes.length > 0) {
            IProcess[] iProcessArray = processes;
            int n = processes.length;
            int n3 = 0;
            while (n3 < n) {
                String groupId;
                IProcess process = iProcessArray[n3];
                if (process instanceof InferiorRuntimeProcess && ((groupId = process.getAttribute("org.eclipse.cdt.dsf.gdb.inferiorGroupId")) == null || groupId.equals("") || container.getGroupId().equals(groupId))) {
                    return process;
                }
                ++n3;
            }
            if (processes[0] instanceof GDBProcess) {
                return processes[0];
            }
        }
        return null;
    }

    public void debugContextChanged(DebugContextEvent event) {
        if ((event.getFlags() & 1) > 0) {
            IProcess consoleProcess = this.getConsoleProcess();
            if (this.fView != null && consoleProcess != null && consoleProcess.equals(this.getCurrentProcess())) {
                this.fView.display(this.fConsole);
            }
        }
    }
}

