/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.integer;

import java.nio.ByteOrder;
import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.internal.ctf.core.Activator;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.Messages;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.AlignmentParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.ByteOrderParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.SizeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.integer.BaseParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.integer.ClockMapParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.integer.SignedParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.string.EncodingParser;

public final class IntegerDeclarationParser
implements ICommonTreeParser {
    public static final IntegerDeclarationParser INSTANCE = new IntegerDeclarationParser();
    private static final @NonNull String ENCODING = "encoding";
    private static final @NonNull String EMPTY_STRING = "";
    private static final int DEFAULT_INT_BASE = 10;
    private static final @NonNull String MAP = "map";
    private static final @NonNull String BASE = "base";
    private static final @NonNull String SIZE = "size";
    private static final @NonNull String SIGNED = "signed";

    private IntegerDeclarationParser() {
    }

    @Override
    public IntegerDeclaration parse(CommonTree integer, ICommonTreeParser.ICommonTreeParserParameter parameter) throws ParseException {
        if (!(parameter instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        CTFTrace trace = ((Param)parameter).fTrace;
        List children = integer.getChildren();
        if (children == null) {
            throw new ParseException("integer: missing size attribute");
        }
        IntegerDeclaration integerDeclaration = null;
        boolean signed = false;
        ByteOrder byteOrder = trace.getByteOrder();
        long size = 0L;
        long alignment = 0L;
        int base = 10;
        @NonNull String clock = EMPTY_STRING;
        Encoding encoding = Encoding.NONE;
        for (CommonTree child : children) {
            block0 : switch (child.getType()) {
                case 84: {
                    String left;
                    CommonTree leftNode = (CommonTree)child.getChild(0);
                    CommonTree rightNode = (CommonTree)child.getChild(1);
                    List leftStrings = leftNode.getChildren();
                    if (!TsdlUtils.isAnyUnaryString((CommonTree)leftStrings.get(0))) {
                        throw new ParseException("Left side of ctf expression must be a string");
                    }
                    switch (left = TsdlUtils.concatenateUnaryStrings(leftStrings)) {
                        case "signed": {
                            signed = SignedParser.INSTANCE.parse(rightNode, null);
                            break block0;
                        }
                        case "byte_order": {
                            byteOrder = ByteOrderParser.INSTANCE.parse(rightNode, new ByteOrderParser.Param(trace));
                            break block0;
                        }
                        case "size": {
                            size = SizeParser.INSTANCE.parse(rightNode, null);
                            break block0;
                        }
                        case "align": {
                            alignment = AlignmentParser.INSTANCE.parse(rightNode, null);
                            break block0;
                        }
                        case "base": {
                            base = BaseParser.INSTANCE.parse(rightNode, null);
                            break block0;
                        }
                        case "encoding": {
                            encoding = EncodingParser.INSTANCE.parse(rightNode, null);
                            break block0;
                        }
                        case "map": {
                            clock = ClockMapParser.INSTANCE.parse(rightNode, null);
                            break block0;
                        }
                    }
                    Activator.log(2, String.valueOf(Messages.IOStructGen_UnknownIntegerAttributeWarning) + " " + left);
                    break;
                }
                default: {
                    throw TsdlUtils.childTypeError(child);
                }
            }
        }
        if (size <= 0L) {
            throw new ParseException("Invalid size attribute in Integer: " + size);
        }
        if (alignment == 0L) {
            alignment = 1L;
        }
        integerDeclaration = IntegerDeclaration.createDeclaration((int)size, signed, base, byteOrder, encoding, clock, alignment);
        return integerDeclaration;
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final CTFTrace fTrace;

        public Param(CTFTrace trace) {
            this.fTrace = trace;
        }
    }
}

