/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.ctf.core.event.CTFClock;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.ClockParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeAliasParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeSpecifierListParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypedefParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.environment.EnvironmentParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.event.EventParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.stream.StreamParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.trace.TraceDeclarationParser;
import org.eclipse.tracecompass.internal.ctf.core.trace.CTFStream;

public class IOStructGen {
    private final @NonNull CTFTrace fTrace;
    private CommonTree fTree;
    private final @NonNull DeclarationScope fRoot;
    private boolean fHasBeenParsed = false;

    public IOStructGen(CommonTree tree, @NonNull CTFTrace trace) {
        this.fTrace = trace;
        this.fTree = tree;
        this.fRoot = (DeclarationScope)NonNullUtils.checkNotNull((Object)trace.getScope());
    }

    public void generate() throws ParseException {
        this.parseRoot(this.fTree);
    }

    public void generateFragment() throws ParseException {
        this.parseIncompleteRoot(this.fTree);
    }

    public void setTree(CommonTree newTree) {
        this.fTree = newTree;
    }

    private void parseRoot(CommonTree root) throws ParseException {
        List children = root.getChildren();
        CommonTree traceNode = null;
        boolean hasStreams = false;
        ArrayList<CommonTree> events = new ArrayList<CommonTree>();
        for (CommonTree child : children) {
            int type = child.getType();
            switch (type) {
                case 87: {
                    this.parseRootDeclaration(child);
                    break;
                }
                case 108: {
                    if (traceNode != null) {
                        throw new ParseException("Only one trace block is allowed");
                    }
                    traceNode = child;
                    this.parseTrace(traceNode);
                    break;
                }
                case 102: {
                    StreamParser.INSTANCE.parse(child, new StreamParser.Param(this.fTrace, this.fRoot));
                    hasStreams = true;
                    break;
                }
                case 97: {
                    events.add(child);
                    break;
                }
                case 82: {
                    CTFClock ctfClock = ClockParser.INSTANCE.parse(child, null);
                    String nameValue = ctfClock.getName();
                    this.fTrace.addClock(nameValue, ctfClock);
                    break;
                }
                case 96: {
                    this.fTrace.setEnvironment((Map<String, String>)EnvironmentParser.INSTANCE.parse(child, null));
                    break;
                }
                default: {
                    throw IOStructGen.childTypeError(child);
                }
            }
        }
        if (traceNode == null) {
            throw new ParseException("Missing trace block");
        }
        this.parseEvents(events, hasStreams);
        this.fHasBeenParsed = true;
    }

    private void parseEvents(List<CommonTree> events, boolean hasStreams) throws ParseException {
        if (!hasStreams && !events.isEmpty()) {
            this.fTrace.addStream(new CTFStream(this.fTrace));
        }
        for (CommonTree event : events) {
            EventParser.INSTANCE.parse(event, new EventParser.Param(this.fTrace, this.fRoot));
        }
    }

    private void parseIncompleteRoot(CommonTree root) throws ParseException {
        if (!this.fHasBeenParsed) {
            throw new ParseException("You need to run generate first");
        }
        List children = root.getChildren();
        ArrayList<CommonTree> events = new ArrayList<CommonTree>();
        for (CommonTree child : children) {
            int type = child.getType();
            switch (type) {
                case 87: {
                    this.parseRootDeclaration(child);
                    break;
                }
                case 108: {
                    throw new ParseException("Trace block defined here, please use generate and not generateFragment to parse this fragment");
                }
                case 102: {
                    StreamParser.INSTANCE.parse(child, new StreamParser.Param(this.fTrace, this.fRoot));
                    break;
                }
                case 97: {
                    events.add(child);
                    break;
                }
                case 82: {
                    CTFClock ctfClock = ClockParser.INSTANCE.parse(child, null);
                    String nameValue = ctfClock.getName();
                    this.fTrace.addClock(nameValue, ctfClock);
                    break;
                }
                case 96: {
                    this.fTrace.setEnvironment((Map<String, String>)EnvironmentParser.INSTANCE.parse(child, null));
                    break;
                }
                default: {
                    throw IOStructGen.childTypeError(child);
                }
            }
        }
        this.parseEvents(events, !Iterables.isEmpty(this.fTrace.getStreams()));
    }

    private void parseTrace(CommonTree traceNode) throws ParseException {
        CTFTrace trace = this.fTrace;
        List children = traceNode.getChildren();
        if (children == null) {
            throw new ParseException("Trace block is empty");
        }
        for (CommonTree child : children) {
            switch (child.getType()) {
                case 109: {
                    TypeAliasParser.INSTANCE.parse(child, new TypeAliasParser.Param(trace, this.fRoot));
                    break;
                }
                case 112: {
                    TypedefParser.INSTANCE.parse(child, new TypedefParser.Param(trace, this.fRoot));
                    break;
                }
                case 83: 
                case 84: {
                    TraceDeclarationParser.INSTANCE.parse(child, new TraceDeclarationParser.Param(this.fTrace, this.fRoot));
                    break;
                }
                default: {
                    throw IOStructGen.childTypeError(child);
                }
            }
        }
        if (this.fTrace.getByteOrder() == null) {
            throw new ParseException("Trace byte order not set");
        }
    }

    private void parseRootDeclaration(CommonTree declaration) throws ParseException {
        List children = declaration.getChildren();
        for (CommonTree child : children) {
            switch (child.getType()) {
                case 112: {
                    TypedefParser.INSTANCE.parse(child, new TypedefParser.Param(this.fTrace, this.fRoot));
                    break;
                }
                case 109: {
                    TypeAliasParser.INSTANCE.parse(child, new TypeAliasParser.Param(this.fTrace, this.fRoot));
                    break;
                }
                case 115: {
                    TypeSpecifierListParser.INSTANCE.parse(child, new TypeSpecifierListParser.Param(this.fTrace, null, null, this.fRoot));
                    break;
                }
                default: {
                    throw IOStructGen.childTypeError(child);
                }
            }
        }
    }

    private static ParseException childTypeError(CommonTree child) {
        CommonTree parent = (CommonTree)child.getParent();
        String error = "Parent " + CTFParser.tokenNames[parent.getType()] + " can't have a child of type " + CTFParser.tokenNames[child.getType()] + ".";
        return new ParseException(error);
    }
}

