/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.trace;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.IEventDeclaration;
import org.eclipse.tracecompass.ctf.core.event.IEventDefinition;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFIOException;
import org.eclipse.tracecompass.ctf.core.trace.CTFResponse;
import org.eclipse.tracecompass.ctf.core.trace.CTFStreamInput;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.core.trace.ICTFPacketDescriptor;
import org.eclipse.tracecompass.ctf.core.trace.IPacketReader;
import org.eclipse.tracecompass.internal.ctf.core.Activator;
import org.eclipse.tracecompass.internal.ctf.core.SafeMappedByteBuffer;
import org.eclipse.tracecompass.internal.ctf.core.trace.CTFPacketReader;
import org.eclipse.tracecompass.internal.ctf.core.trace.NullPacketReader;

@NonNullByDefault
public class CTFStreamInputReader
implements AutoCloseable {
    private static final int BITS_PER_BYTE = 8;
    private final File fFile;
    private final CTFStreamInput fStreamInput;
    private final @Nullable FileChannel fFileChannel;
    private IPacketReader fPacketReader;
    private int fPacketIndex;
    private @Nullable IEventDefinition fCurrentEvent = null;
    private int fId;
    private boolean fLive = false;

    public CTFStreamInputReader(CTFStreamInput streamInput) throws CTFException {
        this.fStreamInput = streamInput;
        this.fFile = this.fStreamInput.getFile();
        try {
            this.fFileChannel = FileChannel.open(this.fFile.toPath(), StandardOpenOption.READ);
        }
        catch (IOException e) {
            throw new CTFIOException(e);
        }
        try {
            this.fPacketIndex = 0;
            if (this.getPacketSize() < this.fPacketIndex + 1 && this.fStreamInput.addPacketHeaderIndex()) {
                this.fPacketIndex = this.getPacketSize() - 1;
            }
            ICTFPacketDescriptor packet = this.getPacket();
            this.fPacketReader = this.getCurrentPacketReader(packet);
        }
        catch (Exception e) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    private IPacketReader getCurrentPacketReader(@Nullable ICTFPacketDescriptor packet) throws CTFException {
        IPacketReader ctfPacketReader = NullPacketReader.INSTANCE;
        if (packet != null) {
            long size = packet.getContentSizeBits();
            if (size < 0L) {
                throw new CTFIOException("Cannot have negative sized buffers.");
            }
            BitBuffer bitBuffer = new BitBuffer(this.getByteBufferAt(packet.getOffsetBits(), size));
            bitBuffer.position(packet.getPayloadStartBits());
            IDeclaration eventHeaderDeclaration = this.getStreamInput().getStream().getEventHeaderDeclaration();
            CTFTrace trace = this.getStreamInput().getStream().getTrace();
            ctfPacketReader = new CTFPacketReader(bitBuffer, packet, this.getEventDeclarations(), eventHeaderDeclaration, this.getStreamEventContextDecl(), trace.getPacketHeaderDef(), trace);
        }
        return ctfPacketReader;
    }

    public ByteBuffer getByteBufferAt(long position, long size) throws CTFException {
        ByteBuffer map;
        try {
            map = SafeMappedByteBuffer.map(this.fFileChannel, FileChannel.MapMode.READ_ONLY, position / 8L, (size + 8L - 1L) / 8L);
        }
        catch (IOException e) {
            throw new CTFIOException(e.getMessage(), e);
        }
        if (map == null) {
            throw new CTFIOException("Failed to allocate mapped byte buffer");
        }
        return map;
    }

    @Override
    public void close() throws IOException {
        if (this.fFileChannel != null) {
            this.fFileChannel.close();
        }
        this.fPacketReader = NullPacketReader.INSTANCE;
    }

    public @Nullable IEventDefinition getCurrentEvent() {
        return this.fCurrentEvent;
    }

    public int getName() {
        return this.fId;
    }

    public void setName(int name) {
        this.fId = name;
    }

    public int getCPU() {
        return this.fPacketReader.getCPU();
    }

    public String getFilename() {
        return this.fStreamInput.getFilename();
    }

    CTFStreamInput getStreamInput() {
        return this.fStreamInput;
    }

    public List<@Nullable IEventDeclaration> getEventDeclarations() {
        return this.fStreamInput.getStream().getEventDeclarations();
    }

    public void setLive(boolean live) {
        this.fLive = live;
    }

    public boolean isLive() {
        return this.fLive;
    }

    public @Nullable StructDeclaration getStreamEventContextDecl() {
        return this.getStreamInput().getStream().getEventContextDecl();
    }

    public CTFResponse readNextEvent() throws CTFException {
        ICTFPacketDescriptor prevPacket;
        if (!this.fPacketReader.hasMoreEvents() && ((prevPacket = this.fPacketReader.getCurrentPacket()) != null || this.fLive)) {
            this.goToNextPacket();
        }
        if (this.fPacketReader.hasMoreEvents()) {
            this.setCurrentEvent(this.fPacketReader.readNextEvent());
            return CTFResponse.OK;
        }
        this.setCurrentEvent(null);
        return this.fLive ? CTFResponse.WAIT : CTFResponse.FINISH;
    }

    private void goToNextPacket() throws CTFException {
        ++this.fPacketIndex;
        while (this.getPacketSize() < this.fPacketIndex + 1) {
            if (this.fStreamInput.addPacketHeaderIndex()) {
                this.fPacketIndex = this.getPacketSize() - 1;
                continue;
            }
            this.fPacketReader = NullPacketReader.INSTANCE;
            return;
        }
        ICTFPacketDescriptor packet = this.getPacket();
        this.fPacketReader = this.getCurrentPacketReader(packet);
    }

    private int getPacketSize() {
        return this.fStreamInput.getIndex().size();
    }

    public long seek(long timestamp) throws CTFException {
        long offset = 0L;
        this.gotoPacket(timestamp);
        while (this.fPacketReader.getCurrentPacket() != null && this.fPacketReader.getCurrentPacket().getTimestampEnd() < timestamp) {
            try {
                this.fStreamInput.addPacketHeaderIndex();
                this.goToNextPacket();
            }
            catch (CTFException e) {
                Activator.log(e.getMessage());
            }
        }
        if (this.fPacketReader.getCurrentPacket() == null) {
            this.gotoPacket(timestamp);
        }
        this.readNextEvent();
        IEventDefinition currentEvent = this.getCurrentEvent();
        while (currentEvent != null && currentEvent.getTimestamp() < timestamp) {
            this.readNextEvent();
            currentEvent = this.getCurrentEvent();
            ++offset;
        }
        return offset;
    }

    private void gotoPacket(long timestamp) throws CTFException {
        this.fPacketIndex = this.fStreamInput.getIndex().search(timestamp) - 1;
        this.goToNextPacket();
    }

    public void goToLastEvent() throws CTFException {
        int lastPacketIndex;
        this.seek(0L);
        if (this.fStreamInput.getIndex().isEmpty() || !this.fPacketReader.hasMoreEvents()) {
            return;
        }
        this.fPacketIndex = this.fStreamInput.getIndex().size() - 1;
        this.fPacketReader = this.getCurrentPacketReader(this.getPacket());
        while (this.fPacketReader.getCurrentPacket() != null) {
            this.goToNextPacket();
        }
        int pos = lastPacketIndex = this.fStreamInput.getIndex().size() - 1;
        while (pos > 0) {
            this.fPacketIndex = pos--;
            this.fPacketReader = this.getCurrentPacketReader(this.getPacket());
            if (this.fPacketReader.hasMoreEvents()) break;
        }
        IEventDefinition prevEvent = null;
        while (this.fCurrentEvent != null) {
            prevEvent = this.fCurrentEvent;
            this.readNextEvent();
        }
        this.setCurrentEvent(prevEvent);
    }

    public void setCurrentEvent(@Nullable IEventDefinition currentEvent) {
        this.fCurrentEvent = currentEvent;
    }

    private int getPacketIndex() {
        return this.fPacketIndex;
    }

    private @Nullable ICTFPacketDescriptor getPacket() {
        if (this.getPacketIndex() >= this.fStreamInput.getIndex().size()) {
            return null;
        }
        return this.fStreamInput.getIndex().getElement(this.getPacketIndex());
    }

    public IPacketReader getCurrentPacketReader() {
        return this.fPacketReader;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fId;
        result = 31 * result + this.fFile.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CTFStreamInputReader)) {
            return false;
        }
        CTFStreamInputReader other = (CTFStreamInputReader)obj;
        if (this.fId != other.fId) {
            return false;
        }
        return this.fFile.equals(other.fFile);
    }

    public String toString() {
        return String.valueOf(this.fId + 32) + NonNullUtils.nullToEmptyString((Object)this.fCurrentEvent);
    }
}

