/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.format;

import java.math.BigDecimal;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.viewers.LamiGraphRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;

public class LamiTimeStampFormat
extends Format {
    private static final int BIG_DECIMAL_DIVISION_SCALE = 22;
    private static final long serialVersionUID = 4285447886537779762L;
    private final TmfTimestampFormat fFormat;
    private @Nullable LamiGraphRange fInternalRange = null;
    private @Nullable LamiGraphRange fExternalRange = null;

    public LamiTimeStampFormat() {
        this.fFormat = (TmfTimestampFormat)NonNullUtils.checkNotNull((Object)TmfTimestampFormat.getDefaulTimeFormat());
    }

    public LamiTimeStampFormat(LamiGraphRange internalRange, LamiGraphRange externalRange) {
        this.fFormat = (TmfTimestampFormat)NonNullUtils.checkNotNull((Object)TmfTimestampFormat.getDefaulTimeFormat());
        this.fInternalRange = internalRange;
        this.fExternalRange = externalRange;
    }

    public LamiTimeStampFormat(String pattern) {
        this.fFormat = new TmfTimestampFormat(pattern);
    }

    public LamiTimeStampFormat(String pattern, LamiGraphRange internalRange, LamiGraphRange externalRange) {
        this.fFormat = new TmfTimestampFormat(pattern);
        this.fInternalRange = internalRange;
        this.fExternalRange = externalRange;
    }

    public @Nullable LamiGraphRange getInternalRange() {
        return this.fInternalRange;
    }

    public void setInternalRange(@Nullable LamiGraphRange internalRange) {
        this.fInternalRange = internalRange;
    }

    public @Nullable LamiGraphRange getExternalRange() {
        return this.fExternalRange;
    }

    public void setExternalRange(@Nullable LamiGraphRange externalRange) {
        this.fExternalRange = externalRange;
    }

    @Override
    public StringBuffer format(@Nullable Object obj, @Nullable StringBuffer toAppendTo, @Nullable FieldPosition pos) {
        if (obj != null && obj instanceof Number && toAppendTo != null) {
            @Nullable LamiGraphRange internalRange = this.fInternalRange;
            @Nullable LamiGraphRange externalRange = this.fExternalRange;
            if (internalRange == null || externalRange == null) {
                long time = ((Number)obj).longValue();
                return (StringBuffer)NonNullUtils.checkNotNull((Object)toAppendTo.append(this.fFormat.format(time)));
            }
            if (internalRange.getDelta().compareTo(BigDecimal.ZERO) == 0 || externalRange.getDelta().compareTo(BigDecimal.ZERO) == 0) {
                return (StringBuffer)NonNullUtils.checkNotNull((Object)toAppendTo.append(this.fFormat.format((Object)externalRange.getMinimum().doubleValue())));
            }
            BigDecimal externalValue = new BigDecimal(obj.toString()).subtract(internalRange.getMinimum()).multiply(externalRange.getDelta()).divide(internalRange.getDelta(), 22, 1).add(externalRange.getMinimum());
            return (StringBuffer)NonNullUtils.checkNotNull((Object)toAppendTo.append(this.fFormat.format(externalValue.longValue())));
        }
        return new StringBuffer();
    }

    @Override
    public @Nullable Object parseObject(@Nullable String source, @Nullable ParsePosition pos) {
        return null;
    }

    public String getPattern() {
        return this.fFormat.toPattern();
    }
}

