/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.shells;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.internal.services.Activator;
import org.eclipse.rse.internal.services.shells.TerminalServiceShellOutputReader;
import org.eclipse.rse.internal.services.shells.TerminalServiceShellWriterThread;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.shells.AbstractHostShell;
import org.eclipse.rse.services.shells.IHostOutput;
import org.eclipse.rse.services.shells.IHostShellChangeEvent;
import org.eclipse.rse.services.shells.IHostShellOutputListener;
import org.eclipse.rse.services.shells.IHostShellOutputReader;
import org.eclipse.rse.services.terminals.ITerminalShell;

public class TerminalServiceHostShell
extends AbstractHostShell {
    private static final String RSE_SHELL_READY_PING = "RSE_SHELL_READY_PING";
    private static final String ECLIPSE_TEST_KEY = "_ping";
    public static final String SHELL_INVOCATION = ">";
    ITerminalShell fTerminalShell;
    BufferedReader fBufReader;
    private TerminalServiceShellOutputReader fStdoutHandler;
    private TerminalServiceShellOutputReader fStderrHandler;
    private TerminalServiceShellWriterThread fShellWriter;
    private static final Pattern cdCommands = Pattern.compile("\\A\\s*(cd|chdir|ls)\\b");

    public TerminalServiceHostShell(ITerminalShell terminalShell, String initialWorkingDirectory, String commandToRun, String[] environment) {
        block11: {
            try {
                this.fTerminalShell = terminalShell;
                String encoding = this.fTerminalShell.getDefaultEncoding();
                this.fBufReader = encoding != null ? new BufferedReader(new InputStreamReader(this.fTerminalShell.getInputStream(), encoding)) : new BufferedReader(new InputStreamReader(this.fTerminalShell.getInputStream()));
                this.fBufReader.mark(1);
                this.fBufReader.read();
                this.fBufReader.reset();
                OutputStream outputStream = this.fTerminalShell.getOutputStream();
                if (encoding != null) {
                    Charset cs = Charset.forName(encoding);
                    PrintWriter outputWriter = new PrintWriter(new OutputStreamWriter(outputStream, cs));
                    this.fShellWriter = new TerminalServiceShellWriterThread(outputWriter);
                } else {
                    PrintWriter outputWriter = new PrintWriter(outputStream);
                    this.fShellWriter = new TerminalServiceShellWriterThread(outputWriter);
                }
                this.fStdoutHandler = new TerminalServiceShellOutputReader(this, this.fBufReader, false, this.fShellWriter);
                this.fStderrHandler = new TerminalServiceShellOutputReader(this, null, true);
                int pingMsec = this.getReadyPingMsec();
                if (SHELL_INVOCATION.equals(commandToRun) && pingMsec > 0) {
                    this.doReadyPing("echo _ping'>'", ECLIPSE_TEST_KEY, pingMsec, 10);
                }
                if (initialWorkingDirectory != null && initialWorkingDirectory.length() > 0 && !initialWorkingDirectory.equals(".") && !initialWorkingDirectory.equals("Command Shell")) {
                    this.writeToShell("cd " + PathUtility.enQuoteUnix(initialWorkingDirectory));
                }
                if (SHELL_INVOCATION.equals(commandToRun)) {
                    this.writeToShell(this.getPromptCommand());
                } else if (commandToRun != null && commandToRun.length() > 0) {
                    this.writeToShell(commandToRun);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.fShellWriter != null) {
                    this.fShellWriter.stopThread();
                    this.fShellWriter = null;
                }
                if (this.fStderrHandler != null) {
                    this.fStderrHandler.interrupt();
                    this.fStderrHandler = null;
                }
                if (this.fStdoutHandler == null) break block11;
                this.fStdoutHandler.interrupt();
                this.fStdoutHandler = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doReadyPing(String pingCmd, final String expectedResponse, int msecPerPing, int maxPing) {
        final boolean[] received_handshake = new boolean[]{false};
        final Object lock = new Object();
        IHostShellOutputListener echoListener = new IHostShellOutputListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void shellOutputChanged(IHostShellChangeEvent event) {
                IHostOutput[] lines = event.getLines();
                int i = lines.length - 1;
                while (i >= 0) {
                    String line = lines[i].getString();
                    if (line.startsWith(expectedResponse)) {
                        Object object = lock;
                        synchronized (object) {
                            received_handshake[0] = true;
                            lock.notifyAll();
                            break;
                        }
                    }
                    --i;
                }
            }
        };
        this.fStdoutHandler.addOutputListener(echoListener);
        int ping = 1;
        do {
            this.writeToShell(pingCmd);
            Object object = lock;
            synchronized (object) {
                try {
                    lock.wait(msecPerPing);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                if (received_handshake[0]) {
                    break;
                }
            }
        } while (!this.fStdoutHandler.isFinished() && ping++ <= maxPing);
        this.fStdoutHandler.removeOutputListener(echoListener);
        return received_handshake[0];
    }

    protected int getReadyPingMsec() {
        int ttyWait = 0;
        String waitVal = System.getProperty(RSE_SHELL_READY_PING);
        if (waitVal != null) {
            try {
                ttyWait = Integer.parseInt(waitVal);
                if (ttyWait < 200) {
                    ttyWait = 200;
                }
            }
            catch (NumberFormatException numberFormatException) {
                Status status = new Status(2, "org.eclipse.rse.services", "RSE_SHELL_READY_PING property should be an integer. Actually is '" + waitVal + "'", null);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        return ttyWait;
    }

    public void exit() {
        if (this.fShellWriter != null) {
            this.fShellWriter.stopThread();
        }
        if (this.fStderrHandler != null) {
            this.fStderrHandler.stopThread();
        }
        if (this.fStdoutHandler != null) {
            this.fStdoutHandler.stopThread();
        }
        this.fTerminalShell.exit();
    }

    public IHostShellOutputReader getStandardErrorReader() {
        return this.fStderrHandler;
    }

    public IHostShellOutputReader getStandardOutputReader() {
        return this.fStdoutHandler;
    }

    public boolean isActive() {
        return this.fTerminalShell.isActive();
    }

    public void writeToShell(String command) {
        if (this.isActive()) {
            if ("#break".equals(command)) {
                command = "\u0003";
            } else if (cdCommands.matcher(command).find()) {
                command = String.valueOf(command) + "\r\n" + this.getPromptCommand();
            }
            if (!this.fShellWriter.sendCommand(command)) {
                this.exit();
                this.isActive();
            }
        }
    }

    public String getPromptCommand() {
        return "echo $PWD'>'";
    }

    public BufferedReader getReader(boolean isErrorReader) {
        return this.fBufReader;
    }
}

