/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.core.callgraph;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.IAnalysisProgressListener;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.common.core.StreamUtils;
import org.eclipse.tracecompass.internal.analysis.timing.core.Activator;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.AbstractCalledFunction;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.AggregatedCalledFunction;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.CalledFunctionFactory;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.CalledStringFunction;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.ICalledFunction;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.Messages;
import org.eclipse.tracecompass.internal.analysis.timing.core.callgraph.ThreadNode;
import org.eclipse.tracecompass.internal.analysis.timing.core.store.LazyArrayListStore;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAbstractAnalysisModule;
import org.eclipse.tracecompass.tmf.core.callstack.CallStackAnalysis;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public abstract class CallGraphAnalysis
extends TmfAbstractAnalysisModule
implements ISegmentStoreProvider {
    private final ISegmentStore<@NonNull ISegment> fStore = new LazyArrayListStore<ISegment>();
    private final ListenerList fListeners = new ListenerList(1);
    private final List<ICalledFunction> fRootFunctions = new ArrayList<ICalledFunction>();
    private List<Integer> fCurrentQuarks = Collections.emptyList();
    private List<ThreadNode> fThreadNodes = new ArrayList<ThreadNode>();

    public @NonNull String getHelpText() {
        String msg = Messages.CallGraphAnalysis_Description;
        return msg != null ? msg : super.getHelpText();
    }

    public @NonNull String getHelpText(@NonNull ITmfTrace trace) {
        return this.getHelpText();
    }

    public boolean canExecute(ITmfTrace trace) {
        return true;
    }

    protected Iterable<IAnalysisModule> getDependentAnalyses() {
        return TmfTraceManager.getTraceSet((ITmfTrace)this.getTrace()).stream().flatMap(trace -> StreamUtils.getStream((Iterable)TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, CallStackAnalysis.class))).distinct().collect(Collectors.toList());
    }

    protected boolean executeAnalysis(@Nullable IProgressMonitor monitor) {
        ITmfTrace trace = this.getTrace();
        if (monitor == null || trace == null) {
            return false;
        }
        Iterable<IAnalysisModule> dependentAnalyses = this.getDependentAnalyses();
        for (IAnalysisModule module : dependentAnalyses) {
            if (!(module instanceof CallStackAnalysis)) {
                return false;
            }
            module.schedule();
        }
        dependentAnalyses.forEach(t -> {
            boolean bl = t.waitForCompletion(monitor);
        });
        for (IAnalysisModule module : dependentAnalyses) {
            CallStackAnalysis callstackModule = (CallStackAnalysis)module;
            String[] threadsPattern = callstackModule.getThreadsPattern();
            String[] processesPattern = callstackModule.getProcessesPattern();
            String[] callStackPath = callstackModule.getCallStackPath();
            ITmfStateSystem ss = callstackModule.getStateSystem();
            if (this.iterateOverStateSystem(ss, threadsPattern, processesPattern, callStackPath, monitor)) continue;
            return false;
        }
        monitor.worked(1);
        monitor.done();
        return true;
    }

    @VisibleForTesting
    protected boolean iterateOverStateSystem(@Nullable ITmfStateSystem ss, String[] threadsPattern, String[] processesPattern, String[] callStackPath, IProgressMonitor monitor) {
        if (ss == null) {
            return false;
        }
        List processQuarks = ss.getQuarks(processesPattern);
        Iterator iterator = processQuarks.iterator();
        while (iterator.hasNext()) {
            int processQuark = (Integer)iterator.next();
            int processId = CallGraphAnalysis.getProcessId(ss, processQuark, ss.getCurrentEndTime());
            Iterator iterator2 = ss.getQuarks(processQuark, threadsPattern).iterator();
            while (iterator2.hasNext()) {
                int threadQuark = (Integer)iterator2.next();
                if (this.iterateOverQuark(ss, processId, threadQuark, callStackPath, monitor)) continue;
                return false;
            }
        }
        this.sendUpdate(this.fStore);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean iterateOverQuark(ITmfStateSystem stateSystem, int processId, int threadQuark, String[] subAttributePath, IProgressMonitor monitor) {
        String threadName = stateSystem.getAttributeName(threadQuark);
        long threadId = -1L;
        ITmfStateInterval interval = null;
        try {
            interval = stateSystem.querySingleState(stateSystem.getStartTime(), threadQuark);
            ITmfStateValue threadStateValue = interval.getStateValue();
            if (threadStateValue.getType() == ITmfStateValue.Type.LONG || threadStateValue.getType() == ITmfStateValue.Type.INTEGER) {
                threadId = threadStateValue.unboxLong();
            } else {
                try {
                    threadId = Long.parseLong(threadName);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (StateSystemDisposedException error) {
            Activator.getInstance().logError(Messages.QueringStateSystemError, (Throwable)error);
        }
        try {
            long curTime = stateSystem.getStartTime();
            long limit = stateSystem.getCurrentEndTime();
            CalledStringFunction initSegment = CalledFunctionFactory.create(0L, 0L, 0, threadName, processId, null);
            ThreadNode init = new ThreadNode(initSegment, 0, threadId);
            while (true) {
                if (curTime >= limit) {
                    this.fThreadNodes.add(init);
                    return true;
                }
                if (monitor.isCanceled()) {
                    return false;
                }
                int callStackQuark = stateSystem.getQuarkRelative(threadQuark, subAttributePath);
                this.fCurrentQuarks = stateSystem.getSubAttributes(callStackQuark, false);
                if (this.fCurrentQuarks.isEmpty()) {
                    return false;
                }
                boolean depth = false;
                int quarkParent = this.fCurrentQuarks.get(0);
                interval = stateSystem.querySingleState(curTime, quarkParent);
                ITmfStateValue stateValue = interval.getStateValue();
                if (!stateValue.isNull()) {
                    long intervalStart = interval.getStartTime();
                    long intervalEnd = interval.getEndTime();
                    AbstractCalledFunction segment = CalledFunctionFactory.create(intervalStart, intervalEnd + 1L, 0, stateValue, processId, null);
                    this.fRootFunctions.add(segment);
                    AggregatedCalledFunction firstNode = new AggregatedCalledFunction(segment, this.fCurrentQuarks.size());
                    if (!this.findChildren(segment, 0, stateSystem, this.fCurrentQuarks.size() + this.fCurrentQuarks.get(0), firstNode, processId, monitor)) {
                        return false;
                    }
                    init.addChild(firstNode);
                }
                curTime = interval.getEndTime() + 1L;
            }
        }
        catch (AttributeNotFoundException | StateSystemDisposedException | TimeRangeException e) {
            Activator.getInstance().logError(Messages.QueringStateSystemError, e);
            return false;
        }
    }

    private boolean findChildren(AbstractCalledFunction node, int depth, ITmfStateSystem ss, int maxQuark, AggregatedCalledFunction aggregatedCalledFunction, int processId, IProgressMonitor monitor) {
        this.fStore.add((Object)node);
        long curTime = node.getStart();
        long limit = node.getEnd();
        ITmfStateInterval interval = null;
        while (curTime < limit) {
            block7: {
                if (monitor.isCanceled()) {
                    return false;
                }
                try {
                    if (depth + 1 < this.fCurrentQuarks.size()) {
                        interval = ss.querySingleState(curTime, this.fCurrentQuarks.get(depth + 1).intValue());
                        break block7;
                    }
                    return true;
                }
                catch (StateSystemDisposedException e) {
                    Activator.getInstance().logError(Messages.QueringStateSystemError, (Throwable)e);
                    return false;
                }
            }
            ITmfStateValue stateValue = interval.getStateValue();
            if (!stateValue.isNull()) {
                long intervalStart = interval.getStartTime();
                long intervalEnd = interval.getEndTime();
                if (intervalStart < node.getStart() || intervalEnd > limit) {
                    return true;
                }
                AbstractCalledFunction segment = CalledFunctionFactory.create(intervalStart, intervalEnd + 1L, node.getDepth() + 1, stateValue, processId, (ICalledFunction)node);
                AggregatedCalledFunction childNode = new AggregatedCalledFunction(segment, aggregatedCalledFunction);
                this.findChildren(segment, depth + 1, ss, maxQuark, childNode, processId, monitor);
                aggregatedCalledFunction.addChild(childNode);
                node.addChild(segment);
            }
            curTime = interval.getEndTime() + 1L;
        }
        return true;
    }

    @Override
    public void addListener(@NonNull IAnalysisProgressListener listener) {
        this.fListeners.add((Object)listener);
    }

    @Override
    public void removeListener(@NonNull IAnalysisProgressListener listener) {
        this.fListeners.remove((Object)listener);
    }

    protected void canceling() {
    }

    @Override
    public @Nullable ISegmentStore<@NonNull ISegment> getSegmentStore() {
        return this.fStore;
    }

    protected void sendUpdate(ISegmentStore<@NonNull ISegment> store) {
        this.getListeners().forEach(listener -> listener.onComplete(this, store));
    }

    protected Iterable<IAnalysisProgressListener> getListeners() {
        return Arrays.stream(this.fListeners.getListeners()).filter(listener -> listener instanceof IAnalysisProgressListener).map(listener -> (IAnalysisProgressListener)listener).collect(Collectors.toList());
    }

    public List<ICalledFunction> getRootFunctions() {
        return ImmutableList.copyOf(this.fRootFunctions);
    }

    public List<ThreadNode> getThreadNodes() {
        return ImmutableList.copyOf(this.fThreadNodes);
    }

    private static int getProcessId(ITmfStateSystem ss, int processQuark, long curTime) {
        int processId = -1;
        if (processQuark != -1) {
            try {
                ITmfStateInterval interval = ss.querySingleState(curTime, processQuark);
                String processName = ss.getAttributeName(processQuark);
                ITmfStateValue processStateValue = interval.getStateValue();
                if (processStateValue.getType() == ITmfStateValue.Type.INTEGER) {
                    processId = processStateValue.unboxInt();
                } else {
                    try {
                        processId = Integer.parseInt(processName);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            catch (StateSystemDisposedException stateSystemDisposedException) {
                // empty catch block
            }
        }
        return processId;
    }
}

