/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.ui.views.segmentstore.table;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.tmf.ui.viewers.table.ISortingLazyContentProvider;

public class SegmentStoreContentProvider
implements ISortingLazyContentProvider {
    private ISegment @Nullable [] fSegmentArray = null;
    private @Nullable TableViewer fTableViewer = null;
    private @Nullable Comparator<ISegment> fComparator = null;

    public void updateElement(int index) {
        TableViewer tableViewer = this.fTableViewer;
        ISegment @Nullable [] segmentArray = this.fSegmentArray;
        if (tableViewer != null && segmentArray != null) {
            tableViewer.replace((Object)segmentArray[index], index);
        }
    }

    public void dispose() {
        this.fSegmentArray = null;
        this.fTableViewer = null;
        this.fComparator = null;
    }

    public void inputChanged(@Nullable Viewer viewer, @Nullable Object oldInput, @Nullable Object newInput) {
        this.fTableViewer = (TableViewer)viewer;
        if (newInput instanceof Collection || newInput instanceof ISegmentStore) {
            Collection segmentStore = (Collection)newInput;
            Object[] array = (ISegment[])Iterables.toArray((Iterable)segmentStore, ISegment.class);
            @NonNull ISegment[] checkedArray = (ISegment[])NonNullUtils.checkNotNullContents((Object[])array);
            if (this.fComparator != null) {
                Arrays.sort(checkedArray, this.fComparator);
            }
            this.fSegmentArray = checkedArray;
        } else if (newInput instanceof ISegment[]) {
            @NonNull ISegment[] checkedArray = (ISegment[])NonNullUtils.checkNotNullContents((Object[])((ISegment[])newInput));
            if (this.fComparator != null) {
                Arrays.sort(checkedArray, this.fComparator);
            }
            this.fSegmentArray = checkedArray;
        } else {
            this.fSegmentArray = null;
        }
    }

    public void setSortOrder(@Nullable Comparator<?> comparator) {
        @NonNull ISegment @Nullable [] segmentArray = this.fSegmentArray;
        if (comparator == null) {
            return;
        }
        if (segmentArray == null) {
            return;
        }
        TableViewer tableViewer = this.fTableViewer;
        if (tableViewer == null) {
            return;
        }
        Comparator<?> comp = comparator;
        this.fComparator = comp;
        Arrays.sort(segmentArray, this.fComparator);
        tableViewer.refresh();
    }

    public int getSegmentCount() {
        ISegment[] segmentArray = this.fSegmentArray;
        return segmentArray == null ? 0 : segmentArray.length;
    }
}

