/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.internal.ui.preferences.CFileTypeAssociation;
import org.eclipse.cdt.internal.ui.preferences.CFileTypeDialog;
import org.eclipse.cdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.cdt.internal.ui.util.Messages;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.content.IContentTypeSettings;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class CFileTypesPreferenceBlock {
    private static final int COL_PATTERN = 0;
    private static final int COL_DESCRIPTION = 1;
    private static final int COL_STATUS = 2;
    private ArrayList<CFileTypeAssociation> fAddAssoc = new ArrayList();
    private ArrayList<CFileTypeAssociation> fRemoveAssoc = new ArrayList();
    private boolean fDirty = false;
    private IProject fInput;
    private IContentType[] fContentTypes;
    private TableViewer fAssocViewer;
    private Button fBtnNew;
    private Button fBtnRemove;

    public CFileTypesPreferenceBlock() {
        this(null);
    }

    public CFileTypesPreferenceBlock(IProject input) {
        this.fInput = input;
        this.setDirty(false);
    }

    public Control createControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        GridLayout controlLayout = new GridLayout(2, false);
        controlLayout.marginHeight = 0;
        controlLayout.marginWidth = 0;
        control.setLayout((Layout)controlLayout);
        control.setLayoutData((Object)new GridData(1808));
        Composite tablePane = new Composite(control, 0);
        GridLayout tablePaneLayout = new GridLayout();
        GridData gridData = new GridData(1808);
        tablePaneLayout.marginHeight = 0;
        tablePaneLayout.marginWidth = 0;
        tablePane.setLayout((Layout)tablePaneLayout);
        tablePane.setLayoutData((Object)gridData);
        Table table = new Table(tablePane, 68098);
        TableLayout tblLayout = new TableLayout();
        TableColumn col = null;
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.heightHint = SWTUtil.getTableHeightHint(table, 15);
        gridData.widthHint = new PixelConverter((Control)parent).convertWidthInCharsToPixels(60);
        tblLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
        tblLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(60));
        tblLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20));
        table.setLayout((Layout)tblLayout);
        table.setLayoutData((Object)gridData);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        col = new TableColumn(table, 16384);
        col.setText(PreferencesMessages.CFileTypesPreferencePage_colTitlePattern);
        col = new TableColumn(table, 16384);
        col.setText(PreferencesMessages.CFileTypesPreferencePage_colTitleDescription);
        col = new TableColumn(table, 16384);
        col.setText(PreferencesMessages.CFileTypesPreferencePage_colTitleStatus);
        Composite buttonPane = new Composite(control, 0);
        GridLayout buttonPaneLayout = new GridLayout();
        buttonPaneLayout.marginHeight = 0;
        buttonPaneLayout.marginWidth = 0;
        buttonPane.setLayout((Layout)buttonPaneLayout);
        buttonPane.setLayoutData((Object)new GridData(2));
        this.fBtnNew = new Button(buttonPane, 8);
        this.fBtnNew.setText(PreferencesMessages.CFileTypesPreferenceBlock_New___);
        gridData = new GridData(768);
        gridData.widthHint = SWTUtil.getButtonWidthHint(this.fBtnNew);
        this.fBtnNew.setLayoutData((Object)gridData);
        this.fBtnNew.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CFileTypesPreferenceBlock.this.handleAdd();
            }
        });
        this.fBtnRemove = new Button(buttonPane, 8);
        this.fBtnRemove.setText(PreferencesMessages.CFileTypesPreferenceBlock_Remove);
        gridData = new GridData(768);
        gridData.widthHint = SWTUtil.getButtonWidthHint(this.fBtnRemove);
        this.fBtnRemove.setLayoutData((Object)gridData);
        this.fBtnRemove.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                CFileTypesPreferenceBlock.this.handleRemove();
            }
        });
        this.fAssocViewer = new TableViewer(table);
        this.fAssocViewer.setSorter((ViewerSorter)new AssocSorter());
        this.fAssocViewer.setContentProvider((IContentProvider)new AssocContentProvider());
        this.fAssocViewer.setLabelProvider((IBaseLabelProvider)new AssocLabelProvider());
        this.fAssocViewer.setInput((Object)this.getCFileTypeAssociations());
        this.fAssocViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CFileTypesPreferenceBlock.this.handleSelectionChanged();
            }
        });
        this.handleSelectionChanged();
        return control;
    }

    public void setEnabled(boolean enabled) {
        this.fAssocViewer.getTable().setEnabled(enabled);
        this.fBtnNew.setEnabled(enabled);
        this.fBtnRemove.setEnabled(enabled);
        this.setDirty(enabled);
    }

    public void setInput(IProject input) {
        this.fAddAssoc.clear();
        this.fRemoveAssoc.clear();
        this.fInput = input;
        if (this.fAssocViewer != null) {
            this.fAssocViewer.setInput((Object)this.getCFileTypeAssociations());
        }
        this.setDirty(true);
    }

    private void setDirty(boolean dirty) {
        this.fDirty = dirty;
    }

    public boolean performOk() {
        boolean changed = this.fDirty;
        if (this.fDirty) {
            CFileTypeAssociation[] add = this.fAddAssoc.toArray(new CFileTypeAssociation[this.fAddAssoc.size()]);
            CFileTypeAssociation[] rem = this.fRemoveAssoc.toArray(new CFileTypeAssociation[this.fRemoveAssoc.size()]);
            changed = add.length > 0 || rem.length > 0;
            this.adjustAssociations(add, rem);
            this.fAddAssoc.clear();
            this.fRemoveAssoc.clear();
            this.setDirty(false);
        }
        return changed;
    }

    private CFileTypeAssociation[] getCFileTypeAssociations() {
        ArrayList<CFileTypeAssociation> list = new ArrayList<CFileTypeAssociation>();
        if (this.fInput == null) {
            this.fillWithUserDefinedCFileTypeAssociations(list);
            this.fillWithPredefinedCFileTypeAssociations(list);
        } else {
            this.fillWithProjectCFileTypeAssociations(list, this.fInput);
        }
        CFileTypeAssociation[] assocs = new CFileTypeAssociation[list.size()];
        list.toArray(assocs);
        return assocs;
    }

    protected void adjustAssociations(CFileTypeAssociation[] add, CFileTypeAssociation[] rem) {
        ProjectScope context = null;
        if (this.fInput != null) {
            context = new ProjectScope(this.fInput);
        }
        this.removeAssociations(rem, (IScopeContext)context);
        this.addAssociations(add, (IScopeContext)context);
    }

    protected final void addAssociations(CFileTypeAssociation[] add, IScopeContext context) {
        int i = 0;
        while (i < add.length) {
            CFileTypeAssociation assoc = add[i];
            String spec = assoc.getSpec();
            IContentType contentType = assoc.getContentType();
            int type = 4;
            if (assoc.isExtSpec()) {
                type = 8;
            }
            this.addAssociation(context, contentType, spec, type);
            ++i;
        }
    }

    protected void addAssociation(IScopeContext context, IContentType contentType, String spec, int type) {
        try {
            IContentTypeSettings settings = contentType.getSettings(context);
            settings.addFileSpec(spec, type);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected void removeAssociations(CFileTypeAssociation[] rem, IScopeContext context) {
        int i = 0;
        while (i < rem.length) {
            CFileTypeAssociation assoc = rem[i];
            IContentType contentType = assoc.getContentType();
            String spec = assoc.getSpec();
            int type = 4;
            if (assoc.isExtSpec()) {
                type = 8;
            }
            this.removeAssociation(context, contentType, spec, type);
            ++i;
        }
    }

    protected void removeAssociation(IScopeContext context, IContentType contentType, String spec, int type) {
        try {
            IContentTypeSettings settings = contentType.getSettings(context);
            settings.removeFileSpec(spec, type);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public IContentType[] getRegistedContentTypes() {
        if (this.fContentTypes == null) {
            String[] ids = CoreModel.getRegistedContentTypeIds();
            IContentTypeManager manager = Platform.getContentTypeManager();
            IContentType[] ctypes = new IContentType[ids.length];
            int i = 0;
            while (i < ids.length) {
                ctypes[i] = manager.getContentType(ids[i]);
                ++i;
            }
            this.fContentTypes = ctypes;
        }
        return this.fContentTypes;
    }

    private void fillWithUserDefinedCFileTypeAssociations(ArrayList<CFileTypeAssociation> list) {
        IContentType[] ctypes = this.getRegistedContentTypes();
        this.fillWithCFileTypeAssociations(ctypes, null, 9, list);
        this.fillWithCFileTypeAssociations(ctypes, null, 5, list);
    }

    private void fillWithPredefinedCFileTypeAssociations(ArrayList<CFileTypeAssociation> list) {
        IContentType[] ctypes = this.getRegistedContentTypes();
        this.fillWithCFileTypeAssociations(ctypes, null, 10, list);
        this.fillWithCFileTypeAssociations(ctypes, null, 6, list);
    }

    private void fillWithProjectCFileTypeAssociations(ArrayList<CFileTypeAssociation> list, IProject project) {
        IContentType[] ctypes = this.getRegistedContentTypes();
        ProjectScope context = new ProjectScope(project);
        this.fillWithCFileTypeAssociations(ctypes, (IScopeContext)context, 9, list);
        this.fillWithCFileTypeAssociations(ctypes, (IScopeContext)context, 5, list);
    }

    private void fillWithCFileTypeAssociations(IContentType[] ctypes, IScopeContext context, int type, ArrayList<CFileTypeAssociation> list) {
        IContentType[] iContentTypeArray = ctypes;
        int n = ctypes.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType ctype = iContentTypeArray[n2];
            try {
                String[] specs;
                IContentTypeSettings setting = ctype.getSettings(context);
                String[] stringArray = specs = setting.getFileSpecs(type);
                int n3 = specs.length;
                int n4 = 0;
                while (n4 < n3) {
                    String spec = stringArray[n4];
                    CFileTypeAssociation assoc = new CFileTypeAssociation(spec, type, ctype);
                    list.add(assoc);
                    ++n4;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++n2;
        }
    }

    private CFileTypeAssociation createAssociation(String pattern, IContentType contentType) {
        int type = 4;
        if (pattern.startsWith("*.")) {
            pattern = pattern.substring(2);
            type = 8;
        }
        return new CFileTypeAssociation(pattern, type | 1, contentType);
    }

    protected void handleSelectionChanged() {
        IStructuredSelection sel = this.getSelection();
        if (sel.isEmpty()) {
            this.fBtnRemove.setEnabled(false);
        } else {
            boolean enabled = true;
            List elements = sel.toList();
            for (Object element : elements) {
                CFileTypeAssociation assoc = (CFileTypeAssociation)element;
                if (!assoc.isPredefined()) continue;
                enabled = false;
            }
            this.fBtnRemove.setEnabled(enabled);
        }
    }

    protected final void handleAdd() {
        CFileTypeAssociation assoc = null;
        CFileTypeDialog dlg = new CFileTypeDialog(this.fBtnNew.getParent().getShell());
        if (dlg.open() == 0 && this.handleAdd(assoc = this.createAssociation(dlg.getPattern(), dlg.getContentType()))) {
            this.fAssocViewer.add((Object)assoc);
            this.setDirty(true);
        }
    }

    private boolean handleAdd(CFileTypeAssociation assoc) {
        String[] specs;
        IContentType settings;
        if (this.containsIgnoreCaseOfSpec(this.fAddAssoc, assoc)) {
            this.reportDuplicateAssociation(assoc);
            return false;
        }
        if (this.containsIgnoreCaseOfSpec(this.fRemoveAssoc, assoc)) {
            if (!this.fRemoveAssoc.remove(assoc)) {
                this.fAddAssoc.add(assoc);
            }
            return true;
        }
        if (this.fInput == null) {
            settings = assoc.getContentType();
        } else {
            try {
                settings = assoc.getContentType().getSettings((IScopeContext)new ProjectScope(this.fInput));
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.fBtnNew.getParent().getShell(), (String)PreferencesMessages.CFileTypesPreferenceBlock_addAssociationError_title, null, (IStatus)e.getStatus());
                return false;
            }
        }
        String newSpec = assoc.getSpec();
        String[] stringArray = specs = settings.getFileSpecs(assoc.getFileSpecType());
        int n = specs.length;
        int n2 = 0;
        while (n2 < n) {
            String spec = stringArray[n2];
            if (spec.equalsIgnoreCase(newSpec)) {
                this.reportDuplicateAssociation(assoc);
                return false;
            }
            ++n2;
        }
        this.fAddAssoc.add(assoc);
        return true;
    }

    private boolean containsIgnoreCaseOfSpec(Collection<CFileTypeAssociation> collection, CFileTypeAssociation assoc) {
        for (CFileTypeAssociation existing : collection) {
            if (!assoc.equalsIgnoreCaseOfSpec(existing)) continue;
            return true;
        }
        return false;
    }

    private void reportDuplicateAssociation(CFileTypeAssociation assoc) {
        MessageDialog.openError((Shell)this.fBtnNew.getParent().getShell(), (String)PreferencesMessages.CFileTypesPreferenceBlock_addAssociationError_title, (String)Messages.format(PreferencesMessages.CFileTypesPreferenceBlock_addAssociationErrorMessage, assoc.getPattern(), assoc.getContentType().getName()));
    }

    protected final void handleRemove() {
        IStructuredSelection sel = this.getSelection();
        if (sel != null && !sel.isEmpty()) {
            for (CFileTypeAssociation assoc : sel) {
                this.handleRemove(assoc);
                this.fAssocViewer.remove((Object)assoc);
                this.setDirty(true);
            }
        }
    }

    private void handleRemove(CFileTypeAssociation assoc) {
        if (!this.fAddAssoc.remove(assoc)) {
            this.fRemoveAssoc.add(assoc);
        }
    }

    private IStructuredSelection getSelection() {
        return (IStructuredSelection)this.fAssocViewer.getSelection();
    }

    private class AssocContentProvider
    implements IStructuredContentProvider {
        CFileTypeAssociation[] assocs;

        private AssocContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.assocs;
        }

        public void dispose() {
            this.assocs = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof CFileTypeAssociation[]) {
                this.assocs = (CFileTypeAssociation[])newInput;
            }
        }
    }

    private class AssocLabelProvider
    implements ILabelProvider,
    ITableLabelProvider {
        private ListenerList listeners = new ListenerList();

        private AssocLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof CFileTypeAssociation && columnIndex == 0) {
                return null;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof CFileTypeAssociation) {
                CFileTypeAssociation assoc = (CFileTypeAssociation)element;
                switch (columnIndex) {
                    case 0: {
                        return assoc.getPattern();
                    }
                    case 1: {
                        return assoc.getDescription();
                    }
                    case 2: {
                        if (assoc.isUserDefined()) {
                            return PreferencesMessages.CFileTypesPreferencePage_userDefined;
                        }
                        if (assoc.isPredefined()) {
                            return PreferencesMessages.CFileTypesPreferencePage_preDefined;
                        }
                        return "";
                    }
                }
            }
            return element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
            this.listeners.add((Object)listener);
        }

        public void dispose() {
            this.listeners.clear();
            this.listeners = null;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
            this.listeners.remove((Object)listener);
        }

        public Image getImage(Object element) {
            return this.getColumnImage(element, 0);
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }
    }

    private class AssocSorter
    extends ViewerSorter {
        private AssocSorter() {
        }

        public int category(Object element) {
            if (element instanceof CFileTypeAssociation) {
                CFileTypeAssociation assoc = (CFileTypeAssociation)element;
                if (assoc.isExtSpec()) {
                    return 10;
                }
                return 20;
            }
            return 30;
        }
    }
}

