/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.ui.cxx;

import org.eclipse.cdt.codan.core.CodanRuntime;
import org.eclipse.cdt.codan.core.model.CheckerLaunchMode;
import org.eclipse.cdt.codan.internal.ui.cxx.CodanCReconciler;
import org.eclipse.cdt.codan.internal.ui.cxx.Messages;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.IPostSaveListener;
import org.eclipse.cdt.ui.ICEditor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;

class CodanPartListener
implements IPartListener2 {
    private CodanCReconciler reconciler;
    private IPostSaveListener postSaveListener;

    CodanPartListener() {
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (this.isCEditor(part)) {
            CEditor editor = (CEditor)part;
            if (this.reconciler == null) {
                this.reconciler = new CodanCReconciler();
            }
            this.reconciler.install(editor);
            if (this.postSaveListener == null) {
                this.postSaveListener = new IPostSaveListener(){

                    public void saved(ITranslationUnit translationUnit, IProgressMonitor monitor) {
                        CodanPartListener.processResource(translationUnit.getResource(), CheckerLaunchMode.RUN_ON_FILE_SAVE);
                    }
                };
            }
            editor.addPostSaveListener(this.postSaveListener);
            IResource resource = (IResource)editor.getEditorInput().getAdapter(IResource.class);
            CodanPartListener.processResource(resource, CheckerLaunchMode.RUN_ON_FILE_OPEN);
        }
    }

    private static void processResource(final IResource resource, final CheckerLaunchMode launchMode) {
        if (resource != null) {
            Job job = new Job(NLS.bind((String)Messages.Startup_AnalyzingFile, (Object)resource.getName())){

                protected IStatus run(IProgressMonitor monitor) {
                    CodanRuntime.getInstance().getBuilder().processResource(resource, monitor, launchMode);
                    return Status.OK_STATUS;
                }
            };
            job.setRule((ISchedulingRule)resource);
            job.setSystem(true);
            job.schedule();
        }
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (this.reconciler != null && this.isCEditor(part)) {
            this.reconciler.uninstall((CEditor)part);
        }
    }

    private boolean isCEditor(IWorkbenchPart part) {
        return part instanceof ICEditor && part instanceof CEditor;
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }
}

