/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.internal.tmf.ui.views.TimeAlignViewsAction;
import org.eclipse.tracecompass.internal.tmf.ui.views.TmfAlignmentSynchronizer;
import org.eclipse.tracecompass.tmf.core.component.ITmfComponent;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.ui.views.ITmfTimeAligned;
import org.eclipse.tracecompass.tmf.ui.views.PinTmfViewAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public abstract class TmfView
extends ViewPart
implements ITmfComponent {
    private final String fName;
    private Composite fParentComposite;
    private ControlAdapter fControlListener;
    private static final TmfAlignmentSynchronizer TIME_ALIGNMENT_SYNCHRONIZER = new TmfAlignmentSynchronizer();
    protected PinTmfViewAction fPinAction;
    private static TimeAlignViewsAction fAlignViewsAction;

    public TmfView(String viewName) {
        this.fName = viewName;
        TmfSignalManager.register((Object)((Object)this));
    }

    public void dispose() {
        TmfSignalManager.deregister((Object)((Object)this));
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getToolBarManager().removeAll();
        bars.getMenuManager().removeAll();
        super.dispose();
    }

    public String getName() {
        return this.fName;
    }

    public void broadcast(TmfSignal signal) {
        TmfSignalManager.dispatchSignal((TmfSignal)signal);
    }

    public void broadcastAsync(TmfSignal signal) {
        TmfSignalManager.dispatchSignalAsync((TmfSignal)signal);
    }

    public boolean isPinned() {
        return this.fPinAction != null && this.fPinAction.isChecked();
    }

    protected void contributePinActionToToolBar() {
        if (this.fPinAction == null) {
            this.fPinAction = new PinTmfViewAction();
            IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
            toolBarManager.add((IContributionItem)new Separator("additions"));
            toolBarManager.add((IAction)this.fPinAction);
        }
    }

    public void createPartControl(Composite parent) {
        this.fParentComposite = parent;
        if (this instanceof ITmfTimeAligned) {
            this.contributeAlignViewsActionToToolbar();
            this.fControlListener = new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    TIME_ALIGNMENT_SYNCHRONIZER.handleViewResized(TmfView.this);
                }
            };
            parent.addControlListener((ControlListener)this.fControlListener);
            this.getSite().getPage().addPartListener(new IPartListener(){

                public void partOpened(IWorkbenchPart part) {
                }

                public void partDeactivated(IWorkbenchPart part) {
                }

                public void partClosed(IWorkbenchPart part) {
                    if (part == TmfView.this && TmfView.this.fControlListener != null && !TmfView.this.fParentComposite.isDisposed()) {
                        TmfView.this.fParentComposite.removeControlListener((ControlListener)TmfView.this.fControlListener);
                        TmfView.this.fControlListener = null;
                        TmfView.this.getSite().getPage().removePartListener((IPartListener)this);
                        TIME_ALIGNMENT_SYNCHRONIZER.handleViewClosed(TmfView.this);
                    }
                }

                public void partBroughtToTop(IWorkbenchPart part) {
                }

                public void partActivated(IWorkbenchPart part) {
                }
            });
        }
    }

    private void contributeAlignViewsActionToToolbar() {
        if (fAlignViewsAction == null) {
            fAlignViewsAction = new TimeAlignViewsAction();
        }
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator("additions"));
        toolBarManager.add((IAction)fAlignViewsAction);
    }

    public Composite getParentComposite() {
        return this.fParentComposite;
    }
}

