/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.changelog.core.editors;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.linuxtools.changelog.core.IEditorChangeLogContrib;
import org.eclipse.linuxtools.internal.changelog.core.ChangelogPlugin;
import org.eclipse.linuxtools.internal.changelog.core.Messages;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class ChangeLogEditor
extends TextEditor {
    private boolean forceNewLogEntry;

    public ChangeLogEditor() {
        SourceViewerConfiguration config = this.getConfig();
        if (config != null) {
            this.setSourceViewerConfiguration(config);
        } else {
            ChangelogPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.linuxtools.changelog.core", 4, Messages.getString("ChangeLogEditor.ErrConfiguration"), (Throwable)new Exception(Messages.getString("ChangeLogEditor.ErrConfiguration"))));
        }
        this.setDocumentProvider((IDocumentProvider)new TextFileDocumentProvider());
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"org.eclipse.linuxtools.changelog.core.changelogEditorScope"});
    }

    private SourceViewerConfiguration getConfig() {
        IExtensionPoint editorExtensions = null;
        IEditorChangeLogContrib editorContrib = null;
        IPreferenceStore store = ChangelogPlugin.getDefault().getPreferenceStore();
        String pref_Editor = store.getString("IChangeLogConstants.DEFAULT_EDITOR");
        editorExtensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.linuxtools.changelog.core", "editorContribution");
        if (editorExtensions != null) {
            IConfigurationElement[] elements = editorExtensions.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                if (elements[i].getName().equals("editor") && elements[i].getAttribute("name").equals(pref_Editor)) {
                    try {
                        IConfigurationElement bob = elements[i];
                        editorContrib = (IEditorChangeLogContrib)bob.createExecutableExtension("class");
                        editorContrib.setTextEditor(this);
                        return (SourceViewerConfiguration)editorContrib;
                    }
                    catch (CoreException e) {
                        ChangelogPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.linuxtools.changelog.core", 4, e.getMessage(), (Throwable)e));
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public ISourceViewer getMySourceViewer() {
        return this.getSourceViewer();
    }

    public boolean isForceNewLogEntry() {
        return this.forceNewLogEntry;
    }

    public void setForceNewLogEntry(boolean forceNewLogEntry) {
        this.forceNewLogEntry = forceNewLogEntry;
    }
}

