/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui;

import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.ui.views.BuildTargetAction;
import org.eclipse.cdt.make.ui.views.CopyTargetAction;
import org.eclipse.cdt.make.ui.views.DeleteTargetAction;
import org.eclipse.cdt.make.ui.views.EditTargetAction;
import org.eclipse.cdt.make.ui.views.PasteTargetAction;
import org.eclipse.cdt.make.ui.views.RebuildLastTargetAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class MakeTargetActionProvider
extends CommonActionProvider {
    private EditTargetAction editTargetAction;
    private CopyTargetAction copyTargetAction;
    private PasteTargetAction pasteTargetAction;
    private DeleteTargetAction deleteTargetAction;
    private BuildTargetAction buildTargetAction;
    private RebuildLastTargetAction buildLastTargetAction;
    private Clipboard clipboard;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        Shell shell = aSite.getViewSite().getShell();
        this.clipboard = new Clipboard(shell.getDisplay());
        this.editTargetAction = new EditTargetAction(aSite.getViewSite().getShell());
        this.pasteTargetAction = new PasteTargetAction(shell, this.clipboard);
        this.copyTargetAction = new CopyTargetAction(shell, this.clipboard, this.pasteTargetAction);
        this.deleteTargetAction = new DeleteTargetAction(shell);
        this.buildTargetAction = new BuildTargetAction(shell);
        this.buildLastTargetAction = new RebuildLastTargetAction();
        this.deleteTargetAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        aSite.getStructuredViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof IMakeTarget) {
                    MakeTargetActionProvider.this.buildTargetAction.run();
                }
            }
        });
    }

    public void dispose() {
        super.dispose();
        this.clipboard.dispose();
    }

    public void fillContextMenu(IMenuManager menu) {
        menu.add((IAction)this.editTargetAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.copyTargetAction);
        menu.add((IAction)this.pasteTargetAction);
        menu.add((IAction)this.deleteTargetAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.buildTargetAction);
        menu.add((IAction)this.buildLastTargetAction);
    }

    public void fillActionBars(IActionBars actionBars) {
        TextActionHandler handler = new TextActionHandler(actionBars);
        handler.setCopyAction((IAction)this.copyTargetAction);
        handler.setPasteAction((IAction)this.pasteTargetAction);
        handler.setDeleteAction((IAction)this.deleteTargetAction);
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        IStructuredSelection selection = (IStructuredSelection)context.getSelection();
        this.editTargetAction.selectionChanged(selection);
        this.copyTargetAction.selectionChanged(selection);
        this.pasteTargetAction.selectionChanged(selection);
        this.deleteTargetAction.selectionChanged(selection);
        this.buildTargetAction.selectionChanged(selection);
        this.buildLastTargetAction.selectionChanged(selection);
    }
}

