/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.util;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.MarketplaceClientCore;
import org.eclipse.epp.internal.mpc.core.util.Messages;
import org.eclipse.epp.internal.mpc.core.util.TransportFactory;
import org.eclipse.epp.mpc.core.service.ITransport;
import org.eclipse.epp.mpc.core.service.ITransportFactory;
import org.eclipse.epp.mpc.core.service.ServiceUnavailableException;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class FallbackTransportFactory
implements ITransportFactory {
    private ITransportFactory primaryFactory;
    private ITransportFactory secondaryFactory;

    public ITransport getTransport() {
        ITransportFactory delegateFactory;
        block6: {
            delegateFactory = this.secondaryFactory;
            if (delegateFactory == null) {
                BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
                try {
                    String disabledTransportsFilter = TransportFactory.computeDisabledTransportsFilter();
                    Collection serviceReferences = bundleContext.getServiceReferences(ITransportFactory.class, "".equals(disabledTransportsFilter) ? null : disabledTransportsFilter);
                    if (serviceReferences.isEmpty()) break block6;
                    for (ServiceReference serviceReference : serviceReferences) {
                        ITransportFactory service = (ITransportFactory)bundleContext.getService(serviceReference);
                        if (service != this && service != this.primaryFactory && !"org.eclipse.epp.mpc.tests.service.MappedTransportFactory".equals(service.getClass().getName())) {
                            delegateFactory = service;
                            break;
                        }
                        bundleContext.ungetService(serviceReference);
                    }
                }
                catch (InvalidSyntaxException invalidSyntaxException) {}
            }
        }
        if (delegateFactory == null) {
            return this.primaryFactory.getTransport();
        }
        return new FallbackTransport(this.primaryFactory.getTransport(), delegateFactory.getTransport());
    }

    public ITransportFactory getPrimaryFactory() {
        return this.primaryFactory;
    }

    public void setPrimaryFactory(ITransportFactory primaryFactory) {
        this.primaryFactory = primaryFactory;
    }

    public void bindPrimaryFactory(ITransportFactory factory) {
        this.setPrimaryFactory(factory);
    }

    public void unbindPrimaryFactory(ITransportFactory factory) {
        if (this.primaryFactory == factory) {
            this.setPrimaryFactory(null);
        }
    }

    public ITransportFactory getSecondaryFactory() {
        return this.secondaryFactory;
    }

    public void setSecondaryFactory(ITransportFactory secondaryFactory) {
        this.secondaryFactory = secondaryFactory;
    }

    private static final class FallbackTransport
    implements ITransport {
        private ITransport primaryTransport;
        private final ITransport fallbackTransport;
        private final Set<String> reportedProblems = new HashSet<String>();
        private int connectionAttempts;
        private int connectionFailures;

        public FallbackTransport(ITransport primaryTransport, ITransport fallbackTransport) {
            this.primaryTransport = primaryTransport;
            this.fallbackTransport = fallbackTransport;
        }

        public InputStream stream(URI location, IProgressMonitor monitor) throws FileNotFoundException, ServiceUnavailableException, CoreException {
            InputStream stream;
            ++this.connectionAttempts;
            if (this.connectionAttempts > 10 && (double)this.connectionFailures / (double)this.connectionAttempts > 0.75) {
                MarketplaceClientCore.getLog().log((IStatus)new Status(1, "org.eclipse.epp.mpc.core", NLS.bind((String)Messages.FallbackTransportFactory_disablingTransport, (Object)this.primaryTransport)));
                this.primaryTransport = null;
            }
            if (this.primaryTransport == null) {
                return this.fallbackTransport.stream(location, monitor);
            }
            try {
                stream = this.primaryTransport.stream(location, monitor);
                if (stream == null) {
                    throw new NullPointerException();
                }
            }
            catch (FileNotFoundException ex) {
                InputStream fallbackStream = this.primaryFailed(location, monitor, ex);
                if (fallbackStream == null) {
                    throw ex;
                }
                return fallbackStream;
            }
            catch (ServiceUnavailableException ex) {
                InputStream fallbackStream = this.primaryFailed(location, monitor, (Exception)((Object)ex));
                if (fallbackStream == null) {
                    throw ex;
                }
                return fallbackStream;
            }
            catch (CoreException ex) {
                InputStream fallbackStream = this.primaryFailed(location, monitor, (Exception)((Object)ex));
                if (fallbackStream == null) {
                    throw ex;
                }
                return fallbackStream;
            }
            catch (RuntimeException ex) {
                InputStream fallbackStream = this.primaryFailed(location, monitor, ex);
                if (fallbackStream == null) {
                    throw ex;
                }
                return fallbackStream;
            }
            try {
                BufferedInputStream buffered = new BufferedInputStream(stream);
                FallbackTransport.tryBuffer(buffered);
                return buffered;
            }
            catch (IOException ex) {
                InputStream fallbackStream = this.primaryFailed(location, monitor, ex);
                if (fallbackStream == null) {
                    throw new CoreException(MarketplaceClientCore.computeStatus(ex, null));
                }
                return fallbackStream;
            }
        }

        private static void tryBuffer(BufferedInputStream buffered) throws IOException {
            buffered.mark(128);
            try {
                buffered.read(new byte[128]);
            }
            finally {
                buffered.reset();
            }
        }

        private InputStream primaryFailed(URI location, IProgressMonitor monitor, Exception ex) throws FileNotFoundException, ServiceUnavailableException, CoreException {
            ++this.connectionFailures;
            if (this.fallbackTransport != null) {
                String problemKey = String.valueOf(ex.getClass().getName()) + ": " + ex.getMessage() + "\n\t" + ex.getStackTrace()[0];
                if (this.reportedProblems.add(problemKey)) {
                    MarketplaceClientCore.getLog().log(MarketplaceClientCore.computeStatus(ex, NLS.bind((String)Messages.FallbackTransportFactory_fallbackStream, (Object)this.primaryTransport, (Object)this.fallbackTransport)));
                }
                return this.fallbackTransport.stream(location, monitor);
            }
            return null;
        }
    }
}

