/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.service;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.service.Messages;
import org.eclipse.epp.internal.mpc.core.service.xml.Unmarshaller;
import org.eclipse.epp.mpc.core.service.IMarketplaceUnmarshaller;
import org.eclipse.epp.mpc.core.service.UnmarshalException;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarketplaceUnmarshaller
implements IMarketplaceUnmarshaller {
    @Override
    public <T> T unmarshal(InputStream in, Class<T> type, IProgressMonitor monitor) throws IOException, UnmarshalException {
        if (in == null) {
            throw new IOException(Messages.MarketplaceUnmarshaller_errorNullStream);
        }
        Unmarshaller unmarshaller = new Unmarshaller();
        XMLReader xmlReader = Unmarshaller.createXMLReader(unmarshaller);
        BufferedInputStream bufferedInput = in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
        ByteBuffer peekBuffer = this.peekResponseContent(bufferedInput);
        InputStreamReader reader = new InputStreamReader((InputStream)bufferedInput, "UTF-8");
        try {
            xmlReader.parse(new InputSource(reader));
        }
        catch (SAXException e) {
            IStatus error = this.createContentError(peekBuffer, NLS.bind((String)Messages.MarketplaceUnmarshaller_invalidResponseContent, (Object)e.getMessage()), e);
            throw new UnmarshalException(error);
        }
        Object model = unmarshaller.getModel();
        if (model == null) {
            IStatus error = this.createContentError(peekBuffer, Messages.MarketplaceUnmarshaller_unexpectedResponseContentNullResult, null);
            throw new UnmarshalException(error);
        }
        try {
            return type.cast(model);
        }
        catch (Exception e) {
            String message = NLS.bind((String)Messages.DefaultMarketplaceService_unexpectedResponseContent, (Object)model.getClass().getSimpleName());
            IStatus error = this.createContentError(peekBuffer, message, e);
            throw new UnmarshalException(error);
        }
    }

    private ByteBuffer peekResponseContent(BufferedInputStream bufferedInput) throws IOException {
        bufferedInput.mark(2049);
        ReadableByteChannel inputChannel = Channels.newChannel(bufferedInput);
        ByteBuffer peekBuffer = ByteBuffer.allocate(2048);
        while (peekBuffer.hasRemaining()) {
            int read = inputChannel.read(peekBuffer);
            if (read == -1) break;
        }
        bufferedInput.reset();
        peekBuffer.flip();
        return peekBuffer;
    }

    private IStatus createContentError(ByteBuffer peekBuffer, String message, Throwable t) {
        IStatus contentInfo;
        IStatus status = this.createErrorStatus(message, t);
        if (peekBuffer != null && peekBuffer.hasRemaining() && (contentInfo = this.createContentInfo(peekBuffer)) != null) {
            MultiStatus multiStatus = new MultiStatus(status.getPlugin(), status.getCode(), status.getMessage(), status.getException());
            multiStatus.add(contentInfo);
            status = multiStatus;
        }
        return status;
    }

    private IStatus createContentInfo(ByteBuffer peekBuffer) {
        try {
            StringBuilder message = new StringBuilder("Received response begins with:\n\n");
            CharsetDecoder decoder = Charset.forName("ASCII").newDecoder();
            decoder.onMalformedInput(CodingErrorAction.REPLACE);
            decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            decoder.replaceWith("?");
            CharBuffer charBuffer = decoder.decode(peekBuffer);
            BufferedReader reader = new BufferedReader(new CharArrayReader(charBuffer.array(), 0, charBuffer.limit()));
            int i = 0;
            while (i < 3) {
                String line = reader.readLine();
                if (line == null) break;
                char[] safeChars = line.toCharArray();
                int j = 0;
                while (j < safeChars.length) {
                    char c = safeChars[j];
                    if (c < ' ' || c >= '\u007f') {
                        safeChars[j] = 63;
                    }
                    ++j;
                }
                message.append(i + 1).append(": ").append(new String(safeChars)).append("\n");
                ++i;
            }
            return new Status(1, "org.eclipse.epp.mpc.core", 0, message.toString(), null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected IStatus createErrorStatus(String message, Throwable t) {
        return new Status(4, "org.eclipse.epp.mpc.core", 0, message, t);
    }
}

