/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.model.IChangeReverseMethodHandler;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ReflectionSequence;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.service.IReverseRunControl2;
import org.eclipse.cdt.dsf.gdb.service.StartOrRestartProcessSequence_7_3;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class StartOrRestartProcessSequence_7_10
extends StartOrRestartProcessSequence_7_3 {
    private IGDBControl fCommandControl;
    private IReverseRunControl2 fReverseService;
    private IChangeReverseMethodHandler.ReverseDebugMethod fReverseMode = IChangeReverseMethodHandler.ReverseDebugMethod.SOFTWARE;
    private final Map<String, Object> fAttributes;

    public StartOrRestartProcessSequence_7_10(DsfExecutor executor, IRunControl.IContainerDMContext containerDmc, Map<String, Object> attributes, boolean restart, DataRequestMonitor<IRunControl.IContainerDMContext> rm) {
        super(executor, containerDmc, attributes, restart, rm);
        this.fAttributes = attributes;
    }

    @Override
    protected String[] getExecutionOrder(String group) {
        if ("GROUP_TOP_LEVEL".equals(group)) {
            ArrayList<String> orderList = new ArrayList<String>(Arrays.asList(super.getExecutionOrder("GROUP_TOP_LEVEL")));
            orderList.add(orderList.indexOf("stepSetReverseOff") + 1, "stepSetReverseMode");
            return orderList.toArray(new String[orderList.size()]);
        }
        return null;
    }

    @Override
    @ReflectionSequence.Execute
    public void stepInitializeBaseSequence(final RequestMonitor rm) {
        super.stepInitializeBaseSequence((RequestMonitor)new ImmediateRequestMonitor(rm){

            protected void handleSuccess() {
                DsfServicesTracker tracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), StartOrRestartProcessSequence_7_10.this.getContainerContext().getSessionId());
                StartOrRestartProcessSequence_7_10.this.fCommandControl = (IGDBControl)tracker.getService(IGDBControl.class);
                StartOrRestartProcessSequence_7_10.this.fReverseService = (IReverseRunControl2)tracker.getService(IReverseRunControl2.class);
                tracker.dispose();
                if (StartOrRestartProcessSequence_7_10.this.fReverseService != null) {
                    String reverseMode = (String)CDebugUtils.getAttribute((Map)StartOrRestartProcessSequence_7_10.this.fAttributes, (String)"org.eclipse.cdt.dsf.gdb.REVERSE_MODE", (Object)"UseSoftTrace");
                    if (reverseMode.equals("UseHardTrace")) {
                        String hwTracePref = Platform.getPreferencesService().getString("org.eclipse.cdt.dsf.gdb", "org.eclipse.cdt.dsf.gdb..reversedebugpref.tracemethodHardware", "UseGdbTrace", null);
                        if (hwTracePref.equals("UseBranchTrace")) {
                            StartOrRestartProcessSequence_7_10.this.fReverseMode = IChangeReverseMethodHandler.ReverseDebugMethod.BRANCH_TRACE;
                        } else if (hwTracePref.equals("UseProcessorTrace")) {
                            StartOrRestartProcessSequence_7_10.this.fReverseMode = IChangeReverseMethodHandler.ReverseDebugMethod.PROCESSOR_TRACE;
                        } else {
                            StartOrRestartProcessSequence_7_10.this.fReverseMode = IChangeReverseMethodHandler.ReverseDebugMethod.GDB_TRACE;
                        }
                    } else if (reverseMode.equals("UseSoftTrace")) {
                        StartOrRestartProcessSequence_7_10.this.fReverseMode = IChangeReverseMethodHandler.ReverseDebugMethod.SOFTWARE;
                    } else {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10005, "Unexpected reverse debugging type: " + reverseMode, null));
                    }
                }
                rm.done();
            }
        });
    }

    @ReflectionSequence.Execute
    public void stepSetReverseMode(RequestMonitor rm) {
        if (this.getReverseEnabled() && this.fReverseService != null) {
            this.fReverseService.enableReverseMode(this.fCommandControl.getContext(), this.fReverseMode, rm);
        } else {
            rm.done();
        }
    }
}

