/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.cdt.autotools.ui.AutotoolsUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class MakeUIImages {
    private static ImageRegistry imageRegistry = new ImageRegistry();
    private static URL fgIconBaseURL;
    private static final String NAME_PREFIX;
    private static final int NAME_PREFIX_LENGTH;
    public static final String OBJ = "obj16/";
    public static final String T_TOOL = "tool16/";
    public static final String T_LCL = "lcl16/";
    public static final String IMG_OBJS_BUILD_TARGET;
    public static final ImageDescriptor DESC_BUILD_TARGET;
    public static final String IMG_OBJS_ERROR;
    public static final ImageDescriptor DESC_OBJ_ERROR;
    public static final String IMG_OBJS_WARNING;
    public static final ImageDescriptor DESC_OBJ_WARNING;
    public static final String IMG_TOOLS_MAKE_TARGET_BUILD;
    public static final String IMG_TOOLS_MAKE_TARGET_ADD;
    public static final String IMG_TOOLS_MAKE_TARGET_DELETE;
    public static final String IMG_TOOLS_MAKE_TARGET_EDIT;
    public static final String IMG_TOOLS_MAKE_TARGET_FILTER;
    public static final String IMG_OBJS_MAKEFILE_MACRO;
    public static final ImageDescriptor DESC_MAKEFILE_MACRO;
    public static final String IMG_OBJS_MAKEFILE_ACMACRO;
    public static final ImageDescriptor DESC_MAKEFILE_ACMACRO;
    public static final String IMG_OBJS_MAKEFILE_TARGET_RULE;
    public static final ImageDescriptor DESC_MAKEFILE_TARGET_RULE;
    public static final String IMG_OBJS_MAKEFILE_INFERENCE_RULE;
    public static final ImageDescriptor DESC_MAKEFILE_INFERENCE_RULE;
    public static final String IMG_OBJS_MAKEFILE_RELATION;
    public static final ImageDescriptor DESC_MAKEFILE_RELATION;
    public static final String IMG_OBJS_MAKEFILE_COMMAND;
    public static final ImageDescriptor DESC_MAKEFILE_COMMAND;
    public static final String IMG_OBJS_MAKEFILE_INCLUDE;
    public static final ImageDescriptor DESC_MAKEFILE_INCLUDE;
    public static final String IMG_OBJS_ENVIRONMNET;
    public static final ImageDescriptor DESC_ENVIRONMENT;
    public static final String IMG_OBJS_ENV_VAR;
    public static final ImageDescriptor DESC_ENV_VAR;
    public static final String IMG_TOOLS_ALPHA_SORTING;
    public static final String IMG_TOOLS_MAKEFILE_SEGMENT_EDIT;
    public static final String IMG_MENU_OPEN_INCLUDE;

    static {
        try {
            fgIconBaseURL = new URL(AutotoolsUIPlugin.getDefault().getBundle().getEntry("/"), "icons/");
        }
        catch (MalformedURLException e) {
            AutotoolsUIPlugin.log(e);
        }
        NAME_PREFIX = String.valueOf(AutotoolsUIPlugin.getUniqueIdentifier()) + '.';
        NAME_PREFIX_LENGTH = NAME_PREFIX.length();
        IMG_OBJS_BUILD_TARGET = String.valueOf(NAME_PREFIX) + "target_obj.gif";
        DESC_BUILD_TARGET = MakeUIImages.createManaged(OBJ, IMG_OBJS_BUILD_TARGET);
        IMG_OBJS_ERROR = String.valueOf(NAME_PREFIX) + "error_obj.gif";
        DESC_OBJ_ERROR = MakeUIImages.createManaged(OBJ, IMG_OBJS_ERROR);
        IMG_OBJS_WARNING = String.valueOf(NAME_PREFIX) + "warning_obj.gif";
        DESC_OBJ_WARNING = MakeUIImages.createManaged(OBJ, IMG_OBJS_WARNING);
        IMG_TOOLS_MAKE_TARGET_BUILD = String.valueOf(NAME_PREFIX) + "target_build.gif";
        IMG_TOOLS_MAKE_TARGET_ADD = String.valueOf(NAME_PREFIX) + "target_add.gif";
        IMG_TOOLS_MAKE_TARGET_DELETE = String.valueOf(NAME_PREFIX) + "target_delete.gif";
        IMG_TOOLS_MAKE_TARGET_EDIT = String.valueOf(NAME_PREFIX) + "target_edit.gif";
        IMG_TOOLS_MAKE_TARGET_FILTER = String.valueOf(NAME_PREFIX) + "target_filter.gif";
        IMG_OBJS_MAKEFILE_MACRO = String.valueOf(NAME_PREFIX) + "macro_obj.gif";
        DESC_MAKEFILE_MACRO = MakeUIImages.createManaged(OBJ, IMG_OBJS_MAKEFILE_MACRO);
        IMG_OBJS_MAKEFILE_ACMACRO = String.valueOf(NAME_PREFIX) + "acmacro_obj.gif";
        DESC_MAKEFILE_ACMACRO = MakeUIImages.createManaged(OBJ, IMG_OBJS_MAKEFILE_ACMACRO);
        IMG_OBJS_MAKEFILE_TARGET_RULE = String.valueOf(NAME_PREFIX) + "trule_obj.gif";
        DESC_MAKEFILE_TARGET_RULE = MakeUIImages.createManaged(OBJ, IMG_OBJS_MAKEFILE_TARGET_RULE);
        IMG_OBJS_MAKEFILE_INFERENCE_RULE = String.valueOf(NAME_PREFIX) + "irule_obj.gif";
        DESC_MAKEFILE_INFERENCE_RULE = MakeUIImages.createManaged(OBJ, IMG_OBJS_MAKEFILE_INFERENCE_RULE);
        IMG_OBJS_MAKEFILE_RELATION = String.valueOf(NAME_PREFIX) + "relation_obj.gif";
        DESC_MAKEFILE_RELATION = MakeUIImages.createManaged(OBJ, IMG_OBJS_MAKEFILE_RELATION);
        IMG_OBJS_MAKEFILE_COMMAND = String.valueOf(NAME_PREFIX) + "command_obj.gif";
        DESC_MAKEFILE_COMMAND = MakeUIImages.createManaged(OBJ, IMG_OBJS_MAKEFILE_COMMAND);
        IMG_OBJS_MAKEFILE_INCLUDE = String.valueOf(NAME_PREFIX) + "include_obj.gif";
        DESC_MAKEFILE_INCLUDE = MakeUIImages.createManaged(OBJ, IMG_OBJS_MAKEFILE_INCLUDE);
        IMG_OBJS_ENVIRONMNET = String.valueOf(NAME_PREFIX) + "environment_obj.gif";
        DESC_ENVIRONMENT = MakeUIImages.createManaged(OBJ, IMG_OBJS_ENVIRONMNET);
        IMG_OBJS_ENV_VAR = String.valueOf(NAME_PREFIX) + "envvar_obj.gif";
        DESC_ENV_VAR = MakeUIImages.createManaged(OBJ, IMG_OBJS_ENV_VAR);
        IMG_TOOLS_ALPHA_SORTING = String.valueOf(NAME_PREFIX) + "alphab_sort_co.gif";
        IMG_TOOLS_MAKEFILE_SEGMENT_EDIT = String.valueOf(NAME_PREFIX) + "segment_edit.gif";
        IMG_MENU_OPEN_INCLUDE = String.valueOf(NAME_PREFIX) + "open_include.gif";
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        return MakeUIImages.createManaged(imageRegistry, prefix, name);
    }

    private static ImageDescriptor createManaged(ImageRegistry registry, String prefix, String name) {
        ImageDescriptor result = ImageDescriptor.createFromURL((URL)MakeUIImages.makeIconFileURL(prefix, name.substring(NAME_PREFIX_LENGTH)));
        registry.put(name, result);
        return result;
    }

    public static Image getImage(String key) {
        return imageRegistry.get(key);
    }

    private static ImageDescriptor create(String prefix, String name) {
        return ImageDescriptor.createFromURL((URL)MakeUIImages.makeIconFileURL(prefix, name));
    }

    private static URL makeIconFileURL(String prefix, String name) {
        StringBuilder buffer = new StringBuilder(prefix);
        buffer.append(name);
        try {
            return new URL(fgIconBaseURL, buffer.toString());
        }
        catch (MalformedURLException e) {
            AutotoolsUIPlugin.log(e);
            return null;
        }
    }

    public static void setImageDescriptors(IAction action, String type, String relPath) {
        relPath = relPath.substring(NAME_PREFIX_LENGTH);
        action.setDisabledImageDescriptor(MakeUIImages.create("d" + type + "/", relPath));
        action.setImageDescriptor(MakeUIImages.create("e" + type + "/", relPath));
    }

    static ImageRegistry getImageRegistry() {
        return imageRegistry;
    }
}

