/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.struct;

import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.AbstractScopedCommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.AlignmentParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.struct.StructBodyParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.StructDeclarationFlattener;

public final class StructParser
extends AbstractScopedCommonTreeParser {
    public static final StructParser INSTANCE = new StructParser();

    private StructParser() {
    }

    @Override
    public StructDeclaration parse(CommonTree struct, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        DeclarationScope scope = ((Param)param).fDeclarationScope;
        CommonTree identifier = ((Param)param).fIdentifier;
        List children = struct.getChildren();
        StructDeclaration structDeclaration = null;
        String structName = null;
        boolean hasName = false;
        CommonTree structBody = null;
        boolean hasBody = false;
        long structAlign = 0L;
        for (CommonTree child : children) {
            switch (child.getType()) {
                case 106: {
                    hasName = true;
                    CommonTree structNameIdentifier = (CommonTree)child.getChild(0);
                    structName = structNameIdentifier.getText();
                    break;
                }
                case 105: {
                    hasBody = true;
                    structBody = child;
                    break;
                }
                case 81: {
                    CommonTree structAlignExpression = (CommonTree)child.getChild(0);
                    structAlign = AlignmentParser.INSTANCE.parse(structAlignExpression, null);
                    break;
                }
                default: {
                    throw TsdlUtils.childTypeError(child);
                }
            }
        }
        if (!hasName && identifier != null) {
            structName = identifier.getText();
            hasName = true;
        }
        if (hasBody) {
            if (hasName && scope.lookupStruct(structName) != null) {
                throw new ParseException("struct " + structName + " already defined.");
            }
            structDeclaration = new StructDeclaration(structAlign);
            CTFTrace trace = ((Param)param).fTrace;
            StructBodyParser.INSTANCE.parse(structBody, new StructBodyParser.Param(structDeclaration, trace, structName, scope));
            if (hasName) {
                scope.registerStruct(structName, structDeclaration);
            }
        } else if (hasName) {
            structDeclaration = scope.lookupStructRecursive(structName);
            if (structDeclaration == null) {
                throw new ParseException("struct " + structName + " is not defined");
            }
        } else {
            throw new ParseException("struct with no name and no body");
        }
        return StructDeclarationFlattener.tryFlattenStruct(structDeclaration);
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final DeclarationScope fDeclarationScope;
        private final @Nullable CommonTree fIdentifier;
        private final CTFTrace fTrace;

        public Param(CTFTrace trace, @Nullable CommonTree identifier, DeclarationScope scope) {
            this.fTrace = trace;
            this.fIdentifier = identifier;
            this.fDeclarationScope = scope;
        }
    }
}

