/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.IName;
import org.eclipse.cdt.core.dom.ast.ASTNodeProperty;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.EScopeKind;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNamedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.c.ICASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICScope;
import org.eclipse.cdt.core.dom.ast.gnu.c.ICASTKnRFunctionDeclarator;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.IContentAssistMatcher;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousParameterDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguousSimpleDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalScope;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.cdt.internal.core.parser.util.ContentAssistMatcherFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class CScope
implements ICScope,
IASTInternalScope {
    public static final int NAMESPACE_TYPE_TAG = 0;
    public static final int NAMESPACE_TYPE_OTHER = 1;
    public static final int NAMESPACE_TYPE_BOTH = 2;
    private static final IndexFilter[] INDEX_FILTERS = new IndexFilter[]{new IndexFilter(){

        @Override
        public boolean acceptBinding(IBinding binding) throws CoreException {
            return IndexFilter.C_DECLARED_OR_IMPLICIT.acceptBinding(binding) && (binding instanceof ICompositeType || binding instanceof IEnumeration);
        }

        @Override
        public boolean acceptLinkage(ILinkage linkage) {
            return IndexFilter.C_DECLARED_OR_IMPLICIT.acceptLinkage(linkage);
        }
    }, new IndexFilter(){

        @Override
        public boolean acceptBinding(IBinding binding) throws CoreException {
            return IndexFilter.C_DECLARED_OR_IMPLICIT.acceptBinding(binding) && !(binding instanceof ICompositeType) && !(binding instanceof IEnumeration);
        }

        @Override
        public boolean acceptLinkage(ILinkage linkage) {
            return IndexFilter.C_DECLARED_OR_IMPLICIT.acceptLinkage(linkage);
        }
    }, IndexFilter.C_DECLARED_OR_IMPLICIT};
    private IASTNode physicalNode;
    private boolean isCached;
    private final CharArrayObjectMap<?>[] mapsToNameOrBinding = new CharArrayObjectMap[]{CharArrayObjectMap.EMPTY_MAP, CharArrayObjectMap.EMPTY_MAP};
    private final EScopeKind kind;

    public CScope(IASTNode physical, EScopeKind eKind) {
        this.physicalNode = physical;
        this.kind = eKind;
    }

    @Override
    public EScopeKind getKind() {
        return this.kind;
    }

    @Override
    public IScope getParent() {
        return CVisitor.getContainingScope(this.physicalNode);
    }

    @Override
    public IBinding[] find(String name, IASTTranslationUnit tu) {
        return this.find(name);
    }

    @Override
    public IBinding[] find(String name) {
        return CVisitor.findBindings(this, name);
    }

    public IBinding getBinding(int namespaceType, char[] name) {
        Object o = this.mapsToNameOrBinding[namespaceType].get(name);
        if (o instanceof IBinding) {
            return (IBinding)o;
        }
        if (o instanceof IASTName) {
            return ((IASTName)o).resolveBinding();
        }
        if (o instanceof IASTName[]) {
            return ((IASTName[])o)[0].resolveBinding();
        }
        return null;
    }

    @Override
    public IASTNode getPhysicalNode() {
        return this.physicalNode;
    }

    @Override
    public void addName(IASTName name) {
        Object o;
        char[] nchars = name.toCharArray();
        if (nchars.length == 0) {
            return;
        }
        int type = this.getNamespaceType(name);
        CharArrayObjectMap<Object> map = this.mapsToNameOrBinding[type];
        if (map == CharArrayObjectMap.EMPTY_MAP) {
            map = new CharArrayObjectMap(1);
            this.mapsToNameOrBinding[type] = map;
        }
        if ((o = map.get(nchars)) instanceof IASTName) {
            if (o != name) {
                map.put(nchars, new IASTName[]{(IASTName)o, name});
            }
        } else if (o instanceof IASTName[]) {
            IASTName[] newNames;
            IASTName[] names;
            IASTName[] iASTNameArray = names = (IASTName[])o;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                IASTName n3 = iASTNameArray[n2];
                if (n3 == null) break;
                if (n3 == name) {
                    return;
                }
                ++n2;
            }
            if ((newNames = ArrayUtil.append(IASTName.class, names, name)) != names) {
                map.put(nchars, newNames);
            }
        } else {
            map.put(nchars, name);
        }
    }

    private int getNamespaceType(IASTName name) {
        ASTNodeProperty prop = name.getPropertyInParent();
        if (prop == IASTCompositeTypeSpecifier.TYPE_NAME || prop == IASTElaboratedTypeSpecifier.TYPE_NAME || prop == IASTEnumerationSpecifier.ENUMERATION_NAME || prop == CVisitor.STRING_LOOKUP_TAGS_PROPERTY) {
            return 0;
        }
        return 1;
    }

    @Override
    public final IBinding getBinding(IASTName name, boolean resolve) {
        return this.getBinding(name, resolve, IIndexFileSet.EMPTY);
    }

    @Override
    public final IBinding[] getBindings(IASTName name, boolean resolve, boolean prefix) {
        return this.getBindings(new IScope.ScopeLookupData(name, resolve, prefix));
    }

    @Override
    public final IBinding getBinding(IASTName name, boolean resolve, IIndexFileSet fileSet) {
        IASTTranslationUnit tu;
        IIndex index;
        char[] c = name.toCharArray();
        if (c.length == 0) {
            return null;
        }
        this.populateCache();
        int type = this.getNamespaceType(name);
        Object o = this.mapsToNameOrBinding[type].get(name.toCharArray());
        if (o instanceof IBinding) {
            return (IBinding)o;
        }
        if (o instanceof IASTName) {
            IBinding b = this.extractBinding((IASTName)o, resolve, name);
            if (b != null) {
                return b;
            }
        } else if (o instanceof IASTName[]) {
            IASTName[] iASTNameArray = (IASTName[])o;
            int n = iASTNameArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTName n3 = iASTNameArray[n2];
                if (n3 == null) break;
                IBinding b = this.extractBinding(n3, resolve, name);
                if (b != null) {
                    return b;
                }
                ++n2;
            }
        }
        IBinding result = null;
        if (resolve && this.physicalNode instanceof IASTTranslationUnit && (index = (tu = (IASTTranslationUnit)this.physicalNode).getIndex()) != null) {
            try {
                IBinding[] bindings = index.findBindings(name.toCharArray(), INDEX_FILTERS[type], (IProgressMonitor)new NullProgressMonitor());
                if (fileSet != null) {
                    bindings = fileSet.filterFileLocalBindings(bindings);
                }
                result = this.processIndexResults(name, bindings);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        return result;
    }

    private IBinding extractBinding(IASTName candidate, boolean resolve, IASTName forName) {
        if (!resolve || this.acceptDeclaredAfter(forName, candidate) || CVisitor.declaredBefore(candidate, forName)) {
            if (resolve && candidate != forName) {
                return candidate.resolveBinding();
            }
            return candidate.getBinding();
        }
        return null;
    }

    private boolean acceptDeclaredAfter(IASTName name, IASTName candidate) {
        if (!(candidate.getParent() instanceof IASTFunctionDeclarator)) {
            return false;
        }
        if (this.getKind() != EScopeKind.eGlobal) {
            return false;
        }
        ASTNodeProperty propertyInParent = name.getPropertyInParent();
        if (propertyInParent == IASTNamedTypeSpecifier.NAME || propertyInParent == IASTElaboratedTypeSpecifier.TYPE_NAME) {
            return false;
        }
        IASTNode parent = name.getParent();
        while (parent != null) {
            if (parent instanceof IASTSimpleDeclSpecifier ? ((IASTSimpleDeclSpecifier)parent).getDeclTypeExpression() != null : parent instanceof IASTTypeIdExpression && ((IASTTypeIdExpression)parent).getOperator() == 3) {
                return false;
            }
            parent = parent.getParent();
        }
        return true;
    }

    @Override
    @Deprecated
    public final IBinding[] getBindings(IASTName name, boolean resolve, boolean prefixLookup, IIndexFileSet fileSet) {
        return this.getBindings(new IScope.ScopeLookupData(name, resolve, prefixLookup));
    }

    @Override
    public final IBinding[] getBindings(IScope.ScopeLookupData lookup) {
        IASTTranslationUnit tu;
        IIndex index;
        char[] c = lookup.getLookupKey();
        Object[] obj = null;
        this.populateCache();
        CharArrayObjectMap<?>[] charArrayObjectMapArray = this.mapsToNameOrBinding;
        int n = this.mapsToNameOrBinding.length;
        int n2 = 0;
        while (n2 < n) {
            CharArrayObjectMap<?> map = charArrayObjectMapArray[n2];
            if (lookup.isPrefixLookup()) {
                char[][] keys;
                IContentAssistMatcher matcher = ContentAssistMatcherFactory.getInstance().createMatcher(c);
                char[][] cArray = keys = map.keys();
                int n3 = keys.length;
                int n4 = 0;
                while (n4 < n3) {
                    char[] key = cArray[n4];
                    if (matcher.match(key)) {
                        obj = ArrayUtil.append(obj, map.get(key));
                    }
                    ++n4;
                }
            } else {
                obj = ArrayUtil.append(obj, map.get(c));
            }
            ++n2;
        }
        if (this.physicalNode instanceof IASTTranslationUnit && (index = (tu = (IASTTranslationUnit)this.physicalNode).getIndex()) != null) {
            try {
                Object[] bindings = lookup.isPrefixLookup() ? index.findBindingsForContentAssist(lookup.getLookupKey(), true, INDEX_FILTERS[2], null) : index.findBindings(lookup.getLookupKey(), INDEX_FILTERS[2], null);
                IIndexFileSet filter = lookup.getIncludedFiles();
                if (filter != null) {
                    bindings = filter.filterFileLocalBindings((IBinding[])bindings);
                }
                obj = ArrayUtil.addAll(Object.class, obj, bindings);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        }
        obj = ArrayUtil.trim(Object.class, obj);
        IBinding[] result = null;
        Object[] objectArray = obj;
        int n5 = obj.length;
        n = 0;
        while (n < n5) {
            Object element = objectArray[n];
            if (element instanceof IBinding) {
                result = ArrayUtil.append(IBinding.class, result, (IBinding)element);
            } else {
                IASTName n6 = null;
                if (element instanceof IASTName) {
                    n6 = (IASTName)element;
                } else if (element instanceof IASTName[]) {
                    n6 = ((IASTName[])element)[0];
                }
                if (n6 != null) {
                    IBinding b = n6.getBinding();
                    if (b == null && lookup.isResolve() && n6 != lookup.getLookupPoint()) {
                        b = n6.resolveBinding();
                    }
                    if (b != null) {
                        result = ArrayUtil.append(IBinding.class, result, b);
                    }
                }
            }
            ++n;
        }
        return ArrayUtil.trim(IBinding.class, result);
    }

    private IBinding processIndexResults(IASTName name, IBinding[] bindings) {
        if (bindings.length != 1) {
            return null;
        }
        return bindings[0];
    }

    @Override
    public void populateCache() {
        if (this.isCached) {
            return;
        }
        this.doPopulateCache();
        this.isCached = true;
    }

    @Override
    public void removeNestedFromCache(IASTNode container) {
        if (this.mapsToNameOrBinding != null) {
            this.removeFromMap(this.mapsToNameOrBinding[0], container);
            this.removeFromMap(this.mapsToNameOrBinding[1], container);
        }
    }

    private void removeFromMap(CharArrayObjectMap<?> map, IASTNode container) {
        int i = 0;
        while (i < map.size()) {
            Object o = map.getAt(i);
            if (o instanceof IASTName) {
                if (container.contains((IASTNode)o)) {
                    char[] key = map.keyAt(i);
                    map.remove(key, 0, key.length);
                    --i;
                }
            } else if (o instanceof IASTName[]) {
                IASTName[] set = (IASTName[])o;
                this.removeFromSet(set, container);
            }
            ++i;
        }
    }

    private void removeFromSet(IASTName[] set, IASTNode container) {
        int j = 0;
        int i = 0;
        while (i < set.length) {
            IASTName n = set[i];
            if (n == null) break;
            if (container.contains(n)) {
                set[i] = null;
            } else if (i != j) {
                set[j++] = n;
                set[i] = null;
            }
            ++i;
        }
    }

    protected void doPopulateCache() {
        IASTFunctionDeclarator dtor;
        IASTNode scopeNode = this.physicalNode;
        IASTNode[] nodes = null;
        if (scopeNode instanceof IASTCompoundStatement) {
            IASTCompoundStatement compound = (IASTCompoundStatement)scopeNode;
            if (scopeNode.getParent() instanceof IASTFunctionDefinition) {
                IASTFunctionDeclarator dtor2 = ((IASTFunctionDefinition)scopeNode.getParent()).getDeclarator();
                if (dtor2 instanceof IASTStandardFunctionDeclarator) {
                    nodes = ((IASTStandardFunctionDeclarator)dtor2).getParameters();
                } else if (dtor2 instanceof ICASTKnRFunctionDeclarator) {
                    nodes = ((ICASTKnRFunctionDeclarator)dtor2).getParameterDeclarations();
                }
            }
            if (nodes == null || nodes.length == 0) {
                nodes = compound.getStatements();
            }
        } else if (scopeNode instanceof IASTTranslationUnit) {
            IASTTranslationUnit translation = (IASTTranslationUnit)scopeNode;
            nodes = translation.getDeclarations();
        } else if (scopeNode instanceof IASTStandardFunctionDeclarator) {
            dtor = (IASTStandardFunctionDeclarator)scopeNode;
            nodes = dtor.getParameters();
        } else if (scopeNode instanceof ICASTKnRFunctionDeclarator) {
            dtor = (ICASTKnRFunctionDeclarator)scopeNode;
            nodes = dtor.getParameterDeclarations();
        } else if (scopeNode instanceof IASTForStatement) {
            IASTForStatement forStmt = (IASTForStatement)scopeNode;
            nodes = new IASTNode[]{forStmt.getInitializerStatement()};
        }
        if (nodes != null) {
            int idx = -1;
            IASTNode node = nodes.length > 0 ? nodes[++idx] : null;
            while (node != null) {
                this.collectNames(node);
                if (idx > -1 && ++idx < nodes.length) {
                    node = nodes[idx];
                    continue;
                }
                node = null;
                if (nodes[0].getPropertyInParent() != ICASTKnRFunctionDeclarator.FUNCTION_PARAMETER && nodes[0].getPropertyInParent() != IASTStandardFunctionDeclarator.FUNCTION_PARAMETER) continue;
                IASTCompoundStatement compound = null;
                if (scopeNode instanceof IASTCompoundStatement) {
                    compound = (IASTCompoundStatement)scopeNode;
                } else if (scopeNode instanceof IASTFunctionDeclarator) {
                    IASTNode n = scopeNode.getParent();
                    while (n instanceof IASTDeclarator) {
                        n = n.getParent();
                    }
                    if (n instanceof IASTFunctionDefinition) {
                        compound = (IASTCompoundStatement)((IASTFunctionDefinition)n).getBody();
                    }
                }
                if (compound == null || (nodes = compound.getStatements()).length <= 0) continue;
                idx = 0;
                node = nodes[0];
            }
        }
    }

    public void collectNames(IASTNode node) {
        if (node instanceof IASTDeclaration) {
            this.collectNames((IASTDeclaration)node);
        } else if (node instanceof IASTParameterDeclaration) {
            this.collectNames((IASTParameterDeclaration)node);
        } else if (node instanceof IASTDeclarationStatement) {
            this.collectNames(((IASTDeclarationStatement)node).getDeclaration());
        }
    }

    private void collectNames(IASTParameterDeclaration paramDecl) {
        if (paramDecl == null || paramDecl instanceof IASTAmbiguousParameterDeclaration) {
            return;
        }
        this.collectNames(paramDecl.getDeclarator());
        this.collectNames(paramDecl.getDeclSpecifier(), false);
    }

    private void collectNames(IASTDeclarator dtor) {
        IASTDeclarator innermost = null;
        while (dtor != null) {
            if (dtor instanceof IASTAmbiguousDeclarator) {
                innermost = null;
                break;
            }
            innermost = dtor;
            dtor = dtor.getNestedDeclarator();
        }
        if (innermost != null) {
            ASTInternal.addName(this, innermost.getName());
        }
    }

    private void collectNames(IASTDeclaration declaration) {
        if (declaration instanceof IASTAmbiguousSimpleDeclaration) {
            return;
        }
        if (declaration instanceof IASTSimpleDeclaration) {
            IASTDeclarator[] declarators;
            IASTSimpleDeclaration simpleDeclaration = (IASTSimpleDeclaration)declaration;
            IASTDeclarator[] iASTDeclaratorArray = declarators = simpleDeclaration.getDeclarators();
            int n = declarators.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclarator dtor = iASTDeclaratorArray[n2];
                this.collectNames(dtor);
                ++n2;
            }
            this.collectNames(simpleDeclaration.getDeclSpecifier(), declarators.length == 0);
        } else if (declaration instanceof IASTFunctionDefinition) {
            IASTFunctionDefinition functionDef = (IASTFunctionDefinition)declaration;
            this.collectNames(functionDef.getDeclarator());
            this.collectNames(functionDef.getDeclSpecifier(), false);
        }
    }

    private void collectNames(IASTDeclSpecifier declSpec, boolean forceElabSpec) {
        block7: {
            IASTName tempName;
            block8: {
                tempName = null;
                if (!(declSpec instanceof ICASTElaboratedTypeSpecifier)) break block8;
                if (!forceElabSpec && !(this.physicalNode instanceof IASTTranslationUnit)) break block7;
                tempName = ((ICASTElaboratedTypeSpecifier)declSpec).getName();
                ASTInternal.addName(this, tempName);
                break block7;
            }
            if (declSpec instanceof ICASTCompositeTypeSpecifier) {
                IASTDeclaration[] nested;
                tempName = ((ICASTCompositeTypeSpecifier)declSpec).getName();
                ASTInternal.addName(this, tempName);
                IASTDeclaration[] iASTDeclarationArray = nested = ((ICASTCompositeTypeSpecifier)declSpec).getMembers();
                int n = nested.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTDeclSpecifier d;
                    IASTDeclaration element = iASTDeclarationArray[n2];
                    if (element instanceof IASTSimpleDeclaration && ((d = ((IASTSimpleDeclaration)element).getDeclSpecifier()) instanceof ICASTCompositeTypeSpecifier || d instanceof IASTEnumerationSpecifier)) {
                        this.collectNames(d, false);
                    }
                    ++n2;
                }
            } else if (declSpec instanceof ICASTEnumerationSpecifier) {
                IASTEnumerationSpecifier.IASTEnumerator[] list;
                ICASTEnumerationSpecifier enumeration = (ICASTEnumerationSpecifier)declSpec;
                tempName = enumeration.getName();
                ASTInternal.addName(this, tempName);
                IASTEnumerationSpecifier.IASTEnumerator[] iASTEnumeratorArray = list = ((ICASTEnumerationSpecifier)declSpec).getEnumerators();
                int n = list.length;
                int n3 = 0;
                while (n3 < n) {
                    IASTEnumerationSpecifier.IASTEnumerator enumerator = iASTEnumeratorArray[n3];
                    if (enumerator != null) {
                        tempName = enumerator.getName();
                        ASTInternal.addName(this, tempName);
                        ++n3;
                        continue;
                    }
                    break;
                }
            }
        }
    }

    @Override
    public IName getScopeName() {
        if (this.physicalNode instanceof IASTCompositeTypeSpecifier) {
            return ((IASTCompositeTypeSpecifier)this.physicalNode).getName();
        }
        return null;
    }

    @Override
    public void addBinding(IBinding binding) {
        CharArrayObjectMap<Object> map;
        int type = 1;
        if (binding instanceof ICompositeType || binding instanceof IEnumeration) {
            type = 0;
        }
        if ((map = this.mapsToNameOrBinding[type]) == CharArrayObjectMap.EMPTY_MAP) {
            map = new CharArrayObjectMap(2);
            this.mapsToNameOrBinding[type] = map;
        }
        map.put(binding.getNameCharArray(), binding);
    }

    public void markAsUncached() {
        this.isCached = false;
    }

    protected static class CollectNamesAction
    extends ASTVisitor {
        private final char[] name;
        private IASTName[] result;

        CollectNamesAction(char[] n) {
            this.name = n;
            this.shouldVisitNames = true;
        }

        @Override
        public int visit(IASTName n) {
            ASTNodeProperty prop = n.getPropertyInParent();
            if ((prop == IASTElaboratedTypeSpecifier.TYPE_NAME || prop == IASTCompositeTypeSpecifier.TYPE_NAME || prop == IASTDeclarator.DECLARATOR_NAME) && CharArrayUtils.equals(n.toCharArray(), this.name)) {
                this.result = ArrayUtil.append(IASTName.class, this.result, n);
            }
            return 3;
        }

        @Override
        public int visit(IASTStatement statement) {
            if (statement instanceof IASTDeclarationStatement) {
                return 3;
            }
            return 1;
        }

        public IASTName[] getNames() {
            return ArrayUtil.trim(IASTName.class, this.result);
        }
    }
}

