/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTCastExpression;
import org.eclipse.cdt.core.dom.ast.IASTConditionalExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTLiteralExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeConstructorExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTTranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.SizeofCalculator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ClassTypeHelper;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinary;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeTraits;
import org.eclipse.cdt.internal.core.parser.scanner.ExpressionEvaluator;
import org.eclipse.core.runtime.CoreException;

public class Value
implements IValue {
    public static final int MAX_RECURSION_DEPTH = 25;
    public static final Value UNKNOWN = new Value("<unknown>".toCharArray(), null);
    public static final Value ERROR = new Value("<error>".toCharArray(), null);
    public static final Value NOT_INITIALIZED = new Value("<__>".toCharArray(), null);
    private static final Number VALUE_CANNOT_BE_DETERMINED = new Number(){

        @Override
        public int intValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long longValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public float floatValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double doubleValue() {
            throw new UnsupportedOperationException();
        }
    };
    private static final char UNIQUE_CHAR = '_';
    private static final IValue[] TYPICAL = new IValue[]{new Value(new char[]{'0'}, null), new Value(new char[]{'1'}, null), new Value(new char[]{'2'}, null), new Value(new char[]{'3'}, null), new Value(new char[]{'4'}, null), new Value(new char[]{'5'}, null), new Value(new char[]{'6'}, null)};
    private static int sUnique = 0;
    private final char[] fFixedValue;
    private final ICPPEvaluation fEvaluation;
    private char[] fSignature;

    private Value(char[] fixedValue, ICPPEvaluation evaluation) {
        assert (fixedValue == null != (evaluation == null));
        this.fFixedValue = fixedValue;
        this.fEvaluation = evaluation;
    }

    @Override
    public Long numericalValue() {
        return this.fFixedValue == null ? null : Value.parseLong(this.fFixedValue);
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        return this.fEvaluation;
    }

    @Override
    public char[] getSignature() {
        if (this.fSignature == null) {
            this.fSignature = this.fFixedValue != null ? this.fFixedValue : this.fEvaluation.getSignature();
        }
        return this.fSignature;
    }

    @Override
    @Deprecated
    public char[] getInternalExpression() {
        return CharArrayUtils.EMPTY_CHAR_ARRAY;
    }

    @Override
    @Deprecated
    public IBinding[] getUnknownBindings() {
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    public void marshal(ITypeMarshalBuffer buf) throws CoreException {
        if (UNKNOWN == this) {
            buf.putShort((short)42);
        } else {
            Long num = this.numericalValue();
            if (num != null) {
                long lv = num;
                if (lv >= 0L) {
                    buf.putShort((short)74);
                    buf.putLong(lv);
                } else {
                    buf.putShort((short)138);
                    buf.putLong(-lv);
                }
            } else if (this.fFixedValue != null) {
                buf.putShort((short)266);
                buf.putCharArray(this.fFixedValue);
            } else {
                buf.putShort((short)10);
                this.fEvaluation.marshal(buf, true);
            }
        }
    }

    public static IValue unmarshal(ITypeMarshalBuffer buf) throws CoreException {
        short firstBytes = buf.getShort();
        if (firstBytes == 0) {
            return UNKNOWN;
        }
        if ((firstBytes & 0x20) != 0) {
            return UNKNOWN;
        }
        if ((firstBytes & 0x40) != 0) {
            return Value.create(buf.getLong());
        }
        if ((firstBytes & 0x80) != 0) {
            return Value.create(-buf.getLong());
        }
        if ((firstBytes & 0x100) != 0) {
            return new Value(buf.getCharArray(), null);
        }
        ISerializableEvaluation eval = buf.unmarshalEvaluation();
        if (eval instanceof ICPPEvaluation) {
            return new Value(null, (ICPPEvaluation)eval);
        }
        return UNKNOWN;
    }

    public int hashCode() {
        return CharArrayUtils.hash(this.getSignature());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Value)) {
            return false;
        }
        Value rhs = (Value)obj;
        if (this.fFixedValue != null) {
            return CharArrayUtils.equals(this.fFixedValue, rhs.fFixedValue);
        }
        return CharArrayUtils.equals(this.getSignature(), rhs.getSignature());
    }

    public String toString() {
        return new String(this.getSignature());
    }

    public static IValue create(long value) {
        if (value >= 0L && value < (long)TYPICAL.length) {
            return TYPICAL[(int)value];
        }
        return new Value(Value.toCharArray(value), null);
    }

    public static IValue create(boolean value) {
        return Value.create(value ? 1 : 0);
    }

    public static IValue create(ICPPTemplateDefinition template, ICPPTemplateNonTypeParameter tntp) {
        EvalBinding eval = new EvalBinding((IBinding)tntp, null, template);
        return new Value(null, eval);
    }

    public static IValue create(ICPPEvaluation eval) {
        return new Value(null, eval);
    }

    public static IValue evaluateBinaryExpression(int op, long v1, long v2) {
        Number val = Value.applyBinaryOperator(op, v1, v2);
        if (val != null && val != VALUE_CANNOT_BE_DETERMINED) {
            return Value.create(val.longValue());
        }
        return UNKNOWN;
    }

    public static IValue evaluateUnaryExpression(int unaryOp, long value) {
        Number val = Value.applyUnaryOperator(unaryOp, value);
        if (val != null && val != VALUE_CANNOT_BE_DETERMINED) {
            return Value.create(val.longValue());
        }
        return UNKNOWN;
    }

    public static IValue evaluateUnaryTypeIdExpression(int operator, IType type, IASTNode point) {
        Number val = Value.applyUnaryTypeIdOperator(operator, type, point);
        if (val != null && val != VALUE_CANNOT_BE_DETERMINED) {
            return Value.create(val.longValue());
        }
        return UNKNOWN;
    }

    public static IValue evaluateBinaryTypeIdExpression(IASTBinaryTypeIdExpression.Operator operator, IType type1, IType type2, IASTNode point) {
        Number val = Value.applyBinaryTypeIdOperator(operator, type1, type2, point);
        if (val != null && val != VALUE_CANNOT_BE_DETERMINED) {
            return Value.create(val.longValue());
        }
        return UNKNOWN;
    }

    public static IValue incrementedValue(IValue value, int increment) {
        if (value == UNKNOWN) {
            return UNKNOWN;
        }
        Long val = value.numericalValue();
        if (val != null) {
            return Value.create(val + (long)increment);
        }
        ICPPEvaluation arg1 = value.getEvaluation();
        EvalFixed arg2 = new EvalFixed(CPPBasicType.INT, IASTExpression.ValueCategory.PRVALUE, Value.create(increment));
        return Value.create(new EvalBinary(4, arg1, (ICPPEvaluation)arg2, arg1.getTemplateDefinition()));
    }

    private static Number applyUnaryTypeIdOperator(int operator, IType type, IASTNode point) {
        switch (operator) {
            case 0: {
                return Value.getSize(type, point);
            }
            case 2: {
                return Value.getAlignment(type, point);
            }
            case 1: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 9: {
                break;
            }
            case 8: {
                return !(type instanceof ICPPClassType) || TypeTraits.hasTrivialCopyCtor((ICPPClassType)type, point) ? 1 : 0;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                return type instanceof ICPPClassType && TypeTraits.isAbstract((ICPPClassType)type, point) ? 1 : 0;
            }
            case 13: {
                return type instanceof ICompositeType && ((ICompositeType)type).getKey() != 2 ? 1 : 0;
            }
            case 14: {
                return TypeTraits.isEmpty(type, point) ? 1 : 0;
            }
            case 15: {
                return type instanceof IEnumeration ? 1 : 0;
            }
            case 23: {
                return type instanceof ICPPClassType && ((ICPPClassType)type).isFinal() ? 1 : 0;
            }
            case 19: {
                break;
            }
            case 16: {
                return TypeTraits.isPOD(type, point) ? 1 : 0;
            }
            case 17: {
                return type instanceof ICPPClassType && TypeTraits.isPolymorphic((ICPPClassType)type, point) ? 1 : 0;
            }
            case 20: {
                return TypeTraits.isStandardLayout(type, point) ? 1 : 0;
            }
            case 21: {
                return type instanceof ICPPClassType && TypeTraits.isTrivial((ICPPClassType)type, point) ? 1 : 0;
            }
            case 24: {
                return TypeTraits.isTriviallyCopyable(type, point) ? 1 : 0;
            }
            case 18: {
                return type instanceof ICompositeType && ((ICompositeType)type).getKey() == 2 ? 1 : 0;
            }
        }
        return VALUE_CANNOT_BE_DETERMINED;
    }

    public static Number applyBinaryTypeIdOperator(IASTBinaryTypeIdExpression.Operator operator, IType type1, IType type2, IASTNode point) {
        switch (operator) {
            case __is_base_of: {
                type1 = SemanticUtil.getNestedType(type1, 1);
                type2 = SemanticUtil.getNestedType(type2, 1);
                if (type1 instanceof ICPPClassType && type2 instanceof ICPPClassType && (type1.isSameType(type2) || ClassTypeHelper.isSubclass((ICPPClassType)type2, (ICPPClassType)type1, point))) {
                    return 1;
                }
                return 0;
            }
            case __is_trivially_assignable: {
                return VALUE_CANNOT_BE_DETERMINED;
            }
        }
        return VALUE_CANNOT_BE_DETERMINED;
    }

    private static Number getAlignment(IType type, IASTNode point) {
        SizeofCalculator.SizeAndAlignment sizeAndAlignment = SizeofCalculator.getSizeAndAlignment(type, point);
        if (sizeAndAlignment == null) {
            return VALUE_CANNOT_BE_DETERMINED;
        }
        return sizeAndAlignment.alignment;
    }

    private static Number getSize(IType type, IASTNode point) {
        SizeofCalculator.SizeAndAlignment sizeAndAlignment = SizeofCalculator.getSizeAndAlignment(type, point);
        if (sizeAndAlignment == null) {
            return VALUE_CANNOT_BE_DETERMINED;
        }
        return sizeAndAlignment.size;
    }

    public static int isTemplateParameter(IValue tval) {
        ICPPEvaluation eval = tval.getEvaluation();
        if (eval instanceof EvalBinding) {
            return ((EvalBinding)eval).getTemplateParameterID();
        }
        return -1;
    }

    public static boolean referencesTemplateParameter(IValue tval) {
        ICPPEvaluation eval = tval.getEvaluation();
        if (eval == null) {
            return false;
        }
        return eval.referencesTemplateParameter();
    }

    public static boolean isDependentValue(IValue nonTypeValue) {
        if (nonTypeValue == null) {
            return false;
        }
        ICPPEvaluation eval = nonTypeValue.getEvaluation();
        return eval != null && eval.isValueDependent();
    }

    public static IValue create(IASTExpression expr) {
        Number val = Value.evaluate(expr);
        if (val == VALUE_CANNOT_BE_DETERMINED) {
            return UNKNOWN;
        }
        if (val != null) {
            return Value.create(val.longValue());
        }
        if (expr instanceof ICPPASTInitializerClause) {
            ICPPEvaluation evaluation = ((ICPPASTInitializerClause)((Object)expr)).getEvaluation();
            return evaluation.getValue(expr);
        }
        return UNKNOWN;
    }

    public static IValue fromInternalRepresentation(ICPPEvaluation evaluation) {
        return new Value(null, evaluation);
    }

    public static IValue unique() {
        StringBuilder buf = new StringBuilder(10);
        buf.append('_');
        buf.append(++sUnique);
        return new Value(CharArrayUtils.extractChars(buf), null);
    }

    private static Number evaluate(IASTExpression exp) {
        IASTExpression typeIdExp;
        if (exp == null) {
            return VALUE_CANNOT_BE_DETERMINED;
        }
        if (exp instanceof IASTArraySubscriptExpression) {
            return VALUE_CANNOT_BE_DETERMINED;
        }
        if (exp instanceof IASTBinaryExpression) {
            return Value.evaluateBinaryExpression((IASTBinaryExpression)exp);
        }
        if (exp instanceof IASTCastExpression) {
            return Value.evaluate(((IASTCastExpression)exp).getOperand());
        }
        if (exp instanceof IASTUnaryExpression) {
            return Value.evaluateUnaryExpression((IASTUnaryExpression)exp);
        }
        if (exp instanceof IASTConditionalExpression) {
            IASTConditionalExpression cexpr = (IASTConditionalExpression)exp;
            Number v = Value.evaluate(cexpr.getLogicalConditionExpression());
            if (v == null || v == VALUE_CANNOT_BE_DETERMINED) {
                return v;
            }
            if (v.longValue() == 0L) {
                return Value.evaluate(cexpr.getNegativeResultExpression());
            }
            IASTExpression pe = cexpr.getPositiveResultExpression();
            if (pe == null) {
                return v;
            }
            return Value.evaluate(pe);
        }
        if (exp instanceof IASTIdExpression) {
            IBinding b = ((IASTIdExpression)exp).getName().resolvePreBinding();
            return Value.evaluateBinding(b);
        }
        if (exp instanceof IASTLiteralExpression) {
            IASTLiteralExpression litEx = (IASTLiteralExpression)exp;
            switch (litEx.getKind()) {
                case 6: 
                case 7: {
                    return 0L;
                }
                case 5: {
                    return 1L;
                }
                case 0: {
                    try {
                        return ExpressionEvaluator.getNumber(litEx.getValue());
                    }
                    catch (ExpressionEvaluator.EvalException e) {
                        return VALUE_CANNOT_BE_DETERMINED;
                    }
                }
                case 2: {
                    try {
                        char[] image = litEx.getValue();
                        if (image.length > 1 && image[0] == 'L') {
                            return ExpressionEvaluator.getChar(image, 2);
                        }
                        return ExpressionEvaluator.getChar(image, 1);
                    }
                    catch (ExpressionEvaluator.EvalException e) {
                        return VALUE_CANNOT_BE_DETERMINED;
                    }
                }
            }
        }
        if (exp instanceof IASTTypeIdExpression) {
            typeIdExp = (IASTTypeIdExpression)exp;
            ASTTranslationUnit ast = (ASTTranslationUnit)exp.getTranslationUnit();
            IType type = ast.createType(typeIdExp.getTypeId());
            if (type instanceof ICPPUnknownType) {
                return null;
            }
            return Value.applyUnaryTypeIdOperator(typeIdExp.getOperator(), type, exp);
        }
        if (exp instanceof IASTBinaryTypeIdExpression) {
            typeIdExp = (IASTBinaryTypeIdExpression)exp;
            ASTTranslationUnit ast = (ASTTranslationUnit)exp.getTranslationUnit();
            IType t1 = ast.createType(typeIdExp.getOperand1());
            IType t2 = ast.createType(typeIdExp.getOperand2());
            if (CPPTemplates.isDependentType(t1) || CPPTemplates.isDependentType(t2)) {
                return null;
            }
            return Value.applyBinaryTypeIdOperator(typeIdExp.getOperator(), t1, t2, exp);
        }
        if (exp instanceof IASTFunctionCallExpression || exp instanceof ICPPASTSimpleTypeConstructorExpression) {
            return null;
        }
        return VALUE_CANNOT_BE_DETERMINED;
    }

    private static Number evaluateBinding(IBinding b) {
        if (b instanceof IType) {
            return VALUE_CANNOT_BE_DETERMINED;
        }
        if (b instanceof ICPPTemplateNonTypeParameter) {
            return null;
        }
        if (b instanceof ICPPUnknownBinding) {
            return null;
        }
        IValue value = null;
        if (b instanceof IVariable) {
            value = ((IVariable)b).getInitialValue();
        } else if (b instanceof IEnumerator) {
            value = ((IEnumerator)b).getValue();
        }
        if (value != null && value != UNKNOWN) {
            return value.numericalValue();
        }
        return VALUE_CANNOT_BE_DETERMINED;
    }

    private static Number evaluateUnaryExpression(IASTUnaryExpression exp) {
        int unaryOp = exp.getOperator();
        if (unaryOp == 8) {
            IASTExpression operand = exp.getOperand();
            if (operand != null) {
                IType type = operand.getExpressionType();
                if (type instanceof ICPPUnknownType) {
                    return null;
                }
                ASTTranslationUnit ast = (ASTTranslationUnit)exp.getTranslationUnit();
                SizeofCalculator calculator = ast.getSizeofCalculator();
                SizeofCalculator.SizeAndAlignment info = calculator.sizeAndAlignment(type);
                if (info != null) {
                    return info.size;
                }
            }
            return VALUE_CANNOT_BE_DETERMINED;
        }
        if (unaryOp == 5 || unaryOp == 4 || unaryOp == 16) {
            return VALUE_CANNOT_BE_DETERMINED;
        }
        Number value = Value.evaluate(exp.getOperand());
        if (value == null || value == VALUE_CANNOT_BE_DETERMINED) {
            return value;
        }
        return Value.applyUnaryOperator(unaryOp, value.longValue());
    }

    private static Number applyUnaryOperator(int unaryOp, long value) {
        switch (unaryOp) {
            case 2: 
            case 11: {
                return value;
            }
        }
        switch (unaryOp) {
            case 0: 
            case 9: {
                return value + 1L;
            }
            case 1: 
            case 10: {
                return value - 1L;
            }
            case 3: {
                return -value;
            }
            case 6: {
                return value ^ 0xFFFFFFFFFFFFFFFFL;
            }
            case 7: {
                return value == 0L ? 1 : 0;
            }
        }
        return VALUE_CANNOT_BE_DETERMINED;
    }

    private static Number evaluateBinaryExpression(IASTBinaryExpression exp) {
        int op = exp.getOperator();
        switch (op) {
            case 28: {
                if (!exp.getOperand1().equals(exp.getOperand2())) break;
                return 1L;
            }
            case 29: {
                if (!exp.getOperand1().equals(exp.getOperand2())) break;
                return 0L;
            }
        }
        Number o1 = Value.evaluate(exp.getOperand1());
        if (o1 == null || o1 == VALUE_CANNOT_BE_DETERMINED) {
            return o1;
        }
        Number o2 = Value.evaluate(exp.getOperand2());
        if (o2 == null || o2 == VALUE_CANNOT_BE_DETERMINED) {
            return o2;
        }
        return Value.applyBinaryOperator(op, o1.longValue(), o2.longValue());
    }

    private static Number applyBinaryOperator(int op, long v1, long v2) {
        switch (op) {
            case 1: {
                return v1 * v2;
            }
            case 2: {
                if (v2 == 0L) {
                    return VALUE_CANNOT_BE_DETERMINED;
                }
                return v1 / v2;
            }
            case 3: {
                if (v2 == 0L) {
                    return VALUE_CANNOT_BE_DETERMINED;
                }
                return v1 % v2;
            }
            case 4: {
                return v1 + v2;
            }
            case 5: {
                return v1 - v2;
            }
            case 6: {
                return v1 << (int)v2;
            }
            case 7: {
                return v1 >> (int)v2;
            }
            case 8: {
                return v1 < v2 ? 1 : 0;
            }
            case 9: {
                return v1 > v2 ? 1 : 0;
            }
            case 10: {
                return v1 <= v2 ? 1 : 0;
            }
            case 11: {
                return v1 >= v2 ? 1 : 0;
            }
            case 12: {
                return v1 & v2;
            }
            case 13: {
                return v1 ^ v2;
            }
            case 14: {
                return v1 | v2;
            }
            case 15: {
                return v1 != 0L && v2 != 0L ? 1 : 0;
            }
            case 16: {
                return v1 != 0L || v2 != 0L ? 1 : 0;
            }
            case 28: {
                return v1 == v2 ? 1 : 0;
            }
            case 29: {
                return v1 != v2 ? 1 : 0;
            }
            case 32: {
                return Math.max(v1, v2);
            }
            case 33: {
                return Math.min(v1, v2);
            }
        }
        return VALUE_CANNOT_BE_DETERMINED;
    }

    /*
     * Unable to fully structure code
     */
    private static Long parseLong(char[] value) {
        maxvalue = 0xCCCCCCCCCCCCCCCL;
        len = value.length;
        negative = false;
        result = 0L;
        i = 0;
        if (len > 0 && value[0] == '-') {
            negative = true;
            ++i;
        }
        if (i != len) ** GOTO lbl18
        return null;
lbl-1000:
        // 1 sources

        {
            if (result > 0xCCCCCCCCCCCCCCCL) {
                return null;
            }
            digit = value[i] - 48;
            if (digit < 0 || digit > 9) {
                return null;
            }
            result = result * 10L + (long)digit;
            ++i;
lbl18:
            // 2 sources

            ** while (i < len)
        }
lbl19:
        // 1 sources

        return negative != false ? -result : result;
    }

    private static char[] toCharArray(long value) {
        StringBuilder buf = new StringBuilder();
        buf.append(value);
        return CharArrayUtils.extractChars(buf);
    }
}

