/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.util.Arrays;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IProblemMarkerFilter;
import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

class ProblemMarkerFilterDesc {
    private static final String ATTR_CLASS = "class";
    private static final String VAR_PROJECTNATURES = "projectNatures";
    private final IConfigurationElement element;
    private final Expression enablementExpression;
    private Boolean fStatus = null;
    private String id;
    private IProblemMarkerFilter filter;
    private static final IProblemMarkerFilter NULL_FILTER = new IProblemMarkerFilter(){

        @Override
        public boolean acceptMarker(ProblemMarkerInfo markerInfo) {
            return true;
        }
    };

    ProblemMarkerFilterDesc(IConfigurationElement element) {
        this.element = element;
        Expression expr = null;
        IConfigurationElement[] children = element.getChildren("enablement");
        switch (children.length) {
            case 0: {
                this.fStatus = Boolean.TRUE;
                break;
            }
            case 1: {
                try {
                    ExpressionConverter parser = ExpressionConverter.getDefault();
                    expr = parser.perform(children[0]);
                }
                catch (CoreException e) {
                    CCorePlugin.log("Error in enablement expression of " + this.id, e);
                    this.fStatus = Boolean.FALSE;
                }
                break;
            }
            default: {
                CCorePlugin.log("Too many enablement expressions for " + this.id);
                this.fStatus = Boolean.FALSE;
            }
        }
        this.enablementExpression = expr;
    }

    public boolean matches(IProject project) {
        if (this.fStatus != null) {
            return this.fStatus;
        }
        if (this.enablementExpression != null) {
            try {
                EvaluationContext evalContext = new EvaluationContext(null, (Object)project);
                String[] natures = project.getDescription().getNatureIds();
                evalContext.addVariable(VAR_PROJECTNATURES, Arrays.asList(natures));
                return this.enablementExpression.evaluate((IEvaluationContext)evalContext) == EvaluationResult.TRUE;
            }
            catch (CoreException e) {
                CCorePlugin.log("Error while evaluating enablement expression for " + this.id, e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IProblemMarkerFilter getFilter() {
        if (this.filter == null) {
            ProblemMarkerFilterDesc problemMarkerFilterDesc = this;
            synchronized (problemMarkerFilterDesc) {
                if (this.filter == null) {
                    try {
                        this.filter = (IProblemMarkerFilter)this.element.createExecutableExtension(ATTR_CLASS);
                    }
                    catch (CoreException e) {
                        String id = String.valueOf(this.element.getDeclaringExtension().getNamespaceIdentifier()) + '.' + this.element.getDeclaringExtension().getSimpleIdentifier();
                        CCorePlugin.log("Error in class attribute of " + id, e);
                        this.filter = NULL_FILTER;
                    }
                }
            }
        }
        return this.filter;
    }
}

