/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.html;

import java.util.Map;
import java.util.Vector;
import org.eclipse.ui.internal.intro.impl.html.HTMLElement;
import org.eclipse.ui.internal.intro.impl.html.HTMLUtil;

public class FormattedHTMLElement
extends HTMLElement {
    private int indentLevel;
    private boolean spanMultipleLines;
    private boolean endTagRequired = true;

    public FormattedHTMLElement(String name, int indentLevel, boolean spanMultipleLines) {
        super(name);
        this.indentLevel = indentLevel;
        this.spanMultipleLines = spanMultipleLines;
        boolean isVoidTag = "meta".equalsIgnoreCase(name) || "BASE".equalsIgnoreCase(name) || "LINK".equalsIgnoreCase(name);
        this.endTagRequired = !isVoidTag;
    }

    public FormattedHTMLElement(String name, int indentLevel, boolean spanMultipleLines, boolean endTagRequired) {
        super(name);
        this.indentLevel = indentLevel;
        this.spanMultipleLines = spanMultipleLines;
        this.endTagRequired = endTagRequired;
    }

    public FormattedHTMLElement(String name, Map<String, String> attributes, Vector<Object> content, int indentLevel, boolean spanMultipleLines) {
        super(name, attributes, content);
        this.indentLevel = indentLevel;
        this.spanMultipleLines = spanMultipleLines;
        this.endTagRequired = true;
    }

    public void setEndTagRequired(boolean required) {
        this.endTagRequired = required;
    }

    public void setIndentLevel(int indentLevel) {
        this.indentLevel = indentLevel;
    }

    public void setSpanMultipleLines(boolean spanMultipleLines) {
        this.spanMultipleLines = spanMultipleLines;
    }

    private StringBuffer getIndent(int indentLevel) {
        StringBuffer indent = new StringBuffer();
        int i = 0;
        while (i < indentLevel) {
            indent.append("    ");
            ++i;
        }
        return indent;
    }

    @Override
    public String toString() {
        StringBuffer element = new StringBuffer();
        element.append(this.getIndent(this.indentLevel));
        element.append(HTMLUtil.createHTMLStartTag(this.getElementName(), this.getElementAttributes(), this.spanMultipleLines));
        if (this.getElementContent().isEmpty() && !this.endTagRequired) {
            return element.toString();
        }
        for (Object content : this.getElementContent()) {
            element.append(content);
        }
        if (this.indentLevel > 0 && this.spanMultipleLines) {
            element.append(this.getIndent(this.indentLevel));
        }
        element.append(HTMLUtil.createHTMLEndTag(this.getElementName(), true));
        return element.toString();
    }
}

