/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.transport.httpclient;

import java.io.IOException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.HttpContextInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExecutorClientWrapper
implements HttpClient {
    private final HttpClient client;
    private final HttpContextInterceptor[] contextInterceptors;

    ExecutorClientWrapper(HttpClient client, HttpContextInterceptor ... interceptors) {
        this.client = client;
        if (interceptors != null && interceptors.length == 0) {
            interceptors = null;
        }
        this.contextInterceptors = interceptors;
    }

    ExecutorClientWrapper(HttpClient client, HttpContextInterceptor interceptor) {
        HttpContextInterceptor[] httpContextInterceptorArray;
        this.client = client;
        if (interceptor == null) {
            httpContextInterceptorArray = null;
        } else {
            HttpContextInterceptor[] httpContextInterceptorArray2 = new HttpContextInterceptor[1];
            httpContextInterceptorArray = httpContextInterceptorArray2;
            httpContextInterceptorArray2[0] = interceptor;
        }
        this.contextInterceptors = httpContextInterceptorArray;
    }

    @Deprecated
    public HttpParams getParams() {
        return this.client.getParams();
    }

    @Deprecated
    public ClientConnectionManager getConnectionManager() {
        return this.client.getConnectionManager();
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException, ClientProtocolException {
        return this.client.execute(request);
    }

    public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException, ClientProtocolException {
        HttpResponse response = null;
        response = this.client.execute(request, this.intercept(context));
        return response;
    }

    public HttpResponse execute(HttpHost target, HttpRequest request) throws IOException, ClientProtocolException {
        return this.client.execute(target, request);
    }

    public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        HttpResponse response = null;
        response = this.client.execute(target, request, this.intercept(context));
        return response;
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return (T)this.client.execute(request, responseHandler);
    }

    public <T> T execute(HttpUriRequest request, final ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        final HttpResponse[] response = new HttpResponse[1];
        return (T)this.client.execute(request, new ResponseHandler<T>(){

            public T handleResponse(HttpResponse theResponse) throws ClientProtocolException, IOException {
                response[0] = theResponse;
                return responseHandler.handleResponse(theResponse);
            }
        }, this.intercept(context));
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return (T)this.client.execute(target, request, responseHandler);
    }

    public <T> T execute(HttpHost target, HttpRequest request, final ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        final HttpResponse[] response = new HttpResponse[1];
        return (T)this.client.execute(target, request, new ResponseHandler<T>(){

            public T handleResponse(HttpResponse theResponse) throws ClientProtocolException, IOException {
                response[0] = theResponse;
                return responseHandler.handleResponse(theResponse);
            }
        }, this.intercept(context));
    }

    private HttpContext intercept(HttpContext context) {
        if (this.contextInterceptors == null) {
            return context;
        }
        HttpContextInterceptor[] httpContextInterceptorArray = this.contextInterceptors;
        int n = this.contextInterceptors.length;
        int n2 = 0;
        while (n2 < n) {
            HttpContextInterceptor interceptor = httpContextInterceptorArray[n2];
            context = interceptor.intercept(this, context);
            ++n2;
        }
        return context;
    }
}

