/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class FallbackScrolledComposite
extends ScrolledComposite {
    private static final int H_SCROLL_INCREMENT = 5;
    private static final int V_SCROLL_INCREMENT = 64;

    public FallbackScrolledComposite(Composite parent, int style) {
        super(parent, style);
        this.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                FallbackScrolledComposite.this.reflow(true);
            }
        });
        this.setExpandVertical(true);
        this.setExpandHorizontal(true);
        this.initializeScrollBars();
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.getContent() != null) {
            this.getContent().setForeground(fg);
        }
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.getContent() != null) {
            this.getContent().setBackground(bg);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.getContent() != null) {
            this.getContent().setFont(font);
        }
    }

    public void setContent(Control content) {
        super.setContent(content);
        if (content != null) {
            content.setForeground(this.getForeground());
            content.setBackground(this.getBackground());
            content.setFont(this.getFont());
        }
    }

    public boolean setFocus() {
        if (this.getContent() != null) {
            return this.getContent().setFocus();
        }
        return super.setFocus();
    }

    public void reflow(boolean flushCache) {
        Composite c = (Composite)this.getContent();
        Rectangle clientArea = this.getClientArea();
        if (c == null) {
            return;
        }
        Point newSize = c.computeSize(clientArea.width, -1, flushCache);
        this.setMinSize(newSize);
        this.updatePageIncrement();
        this.layout(flushCache);
    }

    private void updatePageIncrement() {
        ScrollBar vbar = this.getVerticalBar();
        if (vbar != null) {
            Rectangle clientArea = this.getClientArea();
            int increment = clientArea.height - 5;
            vbar.setPageIncrement(increment);
        }
    }

    private void initializeScrollBars() {
        ScrollBar vbar;
        ScrollBar hbar = this.getHorizontalBar();
        if (hbar != null) {
            hbar.setIncrement(5);
        }
        if ((vbar = this.getVerticalBar()) != null) {
            vbar.setIncrement(64);
        }
        this.updatePageIncrement();
    }
}

