/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.project.model;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.tmf.core.analysis.ondemand.IOnDemandAnalysis;
import org.eclipse.tracecompass.tmf.core.analysis.ondemand.OnDemandAnalysisManager;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.project.model.ITmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfBuiltInOnDemandAnalysisElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfCommonProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOnDemandAnalysisElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectModelIcons;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfUserDefinedOnDemandAnalysisElement;

public class TmfOnDemandAnalysesElement
extends TmfProjectModelElement {
    public static final String PATH_ELEMENT = ".ondemand-analyses";
    private static final String ELEMENT_NAME = Messages.TmfOnDemandAnalysesElement_Name;

    protected TmfOnDemandAnalysesElement(IResource resource, TmfCommonProjectElement parent) {
        super(ELEMENT_NAME, resource, parent);
    }

    @Override
    public TmfCommonProjectElement getParent() {
        return (TmfCommonProjectElement)super.getParent();
    }

    @Override
    public Image getIcon() {
        return TmfProjectModelIcons.ONDEMAND_ANALYSES_ICON;
    }

    @Override
    protected void refreshChildren() {
        ITmfTrace trace = this.getParent().getTrace();
        if (trace == null) {
            return;
        }
        ArrayList<ITmfProjectModelElement> children = new ArrayList<ITmfProjectModelElement>(this.getChildren());
        children.stream().forEach(elem -> this.removeChild((ITmfProjectModelElement)elem));
        Set analyses = OnDemandAnalysisManager.getInstance().getOndemandAnalyses(trace);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath nodePath = this.getResource().getFullPath();
        analyses.forEach(analysis -> {
            IFolder analysisRes = (IFolder)NonNullUtils.checkNotNull((Object)root.getFolder(nodePath.append(analysis.getName())));
            TmfOnDemandAnalysisElement elem = analysis.isUserDefined() ? new TmfUserDefinedOnDemandAnalysisElement(analysis.getName(), (IResource)analysisRes, this, (IOnDemandAnalysis)analysis) : new TmfBuiltInOnDemandAnalysisElement(analysis.getName(), (IResource)analysisRes, this, (IOnDemandAnalysis)analysis);
            this.addChild(elem);
        });
        this.getChildren().forEach(child -> ((TmfProjectModelElement)child).refreshChildren());
    }
}

