/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.segment;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;

public class TmfXmlPatternSegment
implements ISegment {
    private static final long serialVersionUID = 3556323761465412078L;
    private static final byte TYPE_NULL = -1;
    private static final byte TYPE_INTEGER = 0;
    private static final byte TYPE_STRING = 1;
    private static final byte TYPE_LONG = 2;
    private final int fScale;
    private final long fStart;
    private final long fEnd;
    private final String fSegmentName;
    private transient Map<@NonNull String, @NonNull ITmfStateValue> fContent;

    public TmfXmlPatternSegment(long start, long end, int scale, String segmentName, @NonNull Map<@NonNull String, @NonNull ITmfStateValue> fields) {
        this.fStart = start;
        this.fEnd = end;
        this.fScale = scale;
        this.fSegmentName = segmentName;
        this.fContent = Collections.unmodifiableMap(fields);
    }

    public @NonNull ITmfTimestamp getTimestampStart() {
        return TmfTimestamp.create((long)this.fStart, (int)this.fScale);
    }

    public @NonNull ITmfTimestamp getTimestampEnd() {
        return TmfTimestamp.create((long)this.fEnd, (int)this.fScale);
    }

    public Map<@NonNull String, @NonNull ITmfStateValue> getContent() {
        return this.fContent;
    }

    public String getName() {
        return this.fSegmentName;
    }

    public int getScale() {
        return this.fScale;
    }

    public int compareTo(@NonNull ISegment o) {
        int ret = super.compareTo(o);
        if (ret != 0) {
            return ret;
        }
        return this.toString().compareTo(o.toString());
    }

    public long getStart() {
        return this.fStart;
    }

    public long getEnd() {
        return this.fEnd;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", [fTimestampStart=" + this.getTimestampStart() + ", fTimestampEnd=" + this.getTimestampEnd() + ", duration= " + this.getLength() + ", fName=" + this.getName() + ", fContent=" + this.getContent() + "]";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.fContent.size());
        for (Map.Entry<String, ITmfStateValue> entry : this.fContent.entrySet()) {
            out.writeInt(entry.getKey().length());
            out.writeBytes(entry.getKey());
            ITmfStateValue value = entry.getValue();
            byte type = TmfXmlPatternSegment.getByteFromType(value.getType());
            out.writeByte(type);
            switch (type) {
                case -1: {
                    break;
                }
                case 0: {
                    out.writeInt(value.unboxInt());
                    break;
                }
                case 2: {
                    out.writeLong(value.unboxLong());
                    break;
                }
                case 1: {
                    @NonNull String string = value.unboxStr();
                    out.writeInt(string.length());
                    out.writeBytes(string);
                    break;
                }
                default: {
                    throw new IOException("Write object failed : Invalid data");
                }
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int contentSize = in.readInt();
        HashMap<@NonNull String, @NonNull ITmfStateValue> content = new HashMap<String, ITmfStateValue>();
        int i = 0;
        while (i < contentSize) {
            TmfStateValue value;
            int length = in.readInt();
            byte[] bytes = new byte[length];
            in.read(bytes, 0, length);
            String name = new String(bytes).intern();
            Byte type = in.readByte();
            switch (type) {
                case -1: {
                    value = TmfStateValue.nullValue();
                    break;
                }
                case 0: {
                    value = TmfStateValue.newValueInt((int)in.readInt());
                    break;
                }
                case 2: {
                    value = TmfStateValue.newValueLong((long)in.readLong());
                    break;
                }
                case 1: {
                    length = in.readInt();
                    bytes = new byte[length];
                    in.read(bytes, 0, length);
                    value = TmfStateValue.newValueString((String)new String(bytes).intern());
                    break;
                }
                default: {
                    throw new IOException("Read object failed : Invalid data");
                }
            }
            content.put(name, (ITmfStateValue)value);
            ++i;
        }
        this.fContent = content;
    }

    private static byte getByteFromType(ITmfStateValue.Type type) {
        switch (type) {
            case NULL: {
                return -1;
            }
            case INTEGER: {
                return 0;
            }
            case STRING: {
                return 1;
            }
            case LONG: {
                return 2;
            }
        }
        throw new IllegalStateException("Data type " + type + " not supported");
    }
}

