/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.cdt.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IFunction;
import org.eclipse.cdt.core.model.IInclude;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.ui.CElementGrouping;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.ui.views.markers.internal.ConcreteMarker;

public class CDTStructureBridge
extends AbstractContextStructureBridge {
    public static final String CONTENT_TYPE = "c/c++";
    public static final int C_SOURCEROOT = 1000;

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public Object getAdaptedParent(Object object) {
        if (object instanceof IFile) {
            IFile file = (IFile)object;
            return CoreModel.getDefault().create((IResource)file.getParent());
        }
        return super.getAdaptedParent(object);
    }

    public String getParentHandle(String handle) {
        ICElement cElement = (ICElement)this.getObjectForHandle(handle);
        if (cElement != null && cElement.getParent() != null) {
            return CDTStructureBridge.getHandleForElement(cElement.getParent());
        }
        return null;
    }

    public List<String> getChildHandles(String handle) {
        ICElement element;
        Object object = this.getObjectForHandle(handle);
        if (object instanceof ICElement && (element = (ICElement)object) instanceof IParent) {
            IParent parent = (IParent)element;
            try {
                List resourceChildren;
                ICElement[] children = parent.getChildren();
                ArrayList<String> childHandles = new ArrayList<String>();
                ICElement[] iCElementArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    ICElement element2 = iCElementArray[n2];
                    String childHandle = this.getHandleIdentifier(element2);
                    if (childHandle != null) {
                        childHandles.add(childHandle);
                    }
                    ++n2;
                }
                AbstractContextStructureBridge parentBridge = ContextCore.getStructureBridge((String)this.parentContentType);
                if (parentBridge != null && "resource".equals(parentBridge.getContentType()) && element.getElementType() < 61 && !(resourceChildren = parentBridge.getChildHandles(handle)).isEmpty()) {
                    childHandles.addAll(resourceChildren);
                }
                return childHandles;
            }
            catch (CModelException cModelException) {}
        }
        return Collections.emptyList();
    }

    public static ICElement getElementForHandle(String handle) {
        return CoreModel.create((String)handle);
    }

    public Object getObjectForHandle(String handle) {
        return CDTStructureBridge.getElementForHandle(handle);
    }

    public static String getHandleForElement(ICElement element) {
        String projectHandle;
        ICProject cProject;
        String handle = element.getHandleIdentifier();
        if (handle != null && !(element instanceof ICProject) && (cProject = element.getCProject()) != null && handle.equals(projectHandle = CDTStructureBridge.getHandleForElement((ICElement)cProject))) {
            return null;
        }
        return handle;
    }

    public String getHandleIdentifier(Object object) {
        Object adapter;
        if (object instanceof ICElement) {
            return CDTStructureBridge.getHandleForElement((ICElement)object);
        }
        if (object instanceof IAdaptable && (adapter = ((IAdaptable)object).getAdapter(ICElement.class)) instanceof ICElement) {
            return CDTStructureBridge.getHandleForElement((ICElement)adapter);
        }
        return null;
    }

    public String getLabel(Object object) {
        if (object instanceof ICElement) {
            return ((ICElement)object).getElementName();
        }
        return "";
    }

    public boolean canBeLandmark(String handle) {
        ICElement element = (ICElement)this.getObjectForHandle(handle);
        return (element instanceof IMethod || element instanceof IFunction) && element.exists();
    }

    public boolean acceptsObject(Object object) {
        if (object instanceof IResource) {
            object = ((IResource)object).getAdapter(ICElement.class);
        }
        boolean accepts = object instanceof ICElement && !(object instanceof IBinary) || object instanceof CElementGrouping;
        return accepts;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canFilter(Object object) {
        if (!(object instanceof CElementGrouping)) return true;
        try {
            CElementGrouping grouping = (CElementGrouping)object;
            Object[] elements = grouping.getChildren((Object)grouping);
            if (elements == null) return true;
            Object[] objectArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                Object adaptable = objectArray[n2];
                IInteractionElement element = ContextCore.getContextManager().getElement(this.getHandleIdentifier(adaptable));
                if (element != null && element.getInterest().isInteresting()) {
                    return false;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isDocument(String handle) {
        ICElement element = (ICElement)this.getObjectForHandle(handle);
        return element instanceof ITranslationUnit;
    }

    public String getHandleForOffsetInObject(Object object, int offset) {
        ITranslationUnit translationUnit;
        int charStart;
        block10: {
            charStart = 0;
            if (object instanceof ConcreteMarker) {
                IMarker iMarker = ((ConcreteMarker)object).getMarker();
            }
            if (!(object instanceof IMarker)) {
                return null;
            }
            IMarker marker = (IMarker)object;
            Integer attribute = marker.getAttribute("charStart", 0);
            if (attribute instanceof Integer) {
                charStart = attribute;
            }
            try {
                translationUnit = null;
                IResource resource = marker.getResource();
                if (!(resource instanceof IFile)) break block10;
                IFile file = (IFile)resource;
                if (CoreModel.isValidTranslationUnitName(null, (String)file.getName())) {
                    ICElement element = CoreModel.getDefault().create(file);
                    translationUnit = CoreModel.getDefault().createTranslationUnitFrom(element.getCProject(), element.getPath());
                    break block10;
                }
                return null;
            }
            catch (CModelException cModelException) {
                return null;
            }
        }
        if (translationUnit != null) {
            ICElement cElement = translationUnit.getElementAtOffset(charStart);
            if (cElement != null) {
                if (cElement instanceof IInclude) {
                    cElement = cElement.getParent().getParent();
                }
                return cElement.getElementName();
            }
            return null;
        }
        return null;
    }

    public String getContentType(String elementHandle) {
        return this.getContentType();
    }

    public boolean containsProblem(IInteractionElement node) {
        try {
            ICElement element = (ICElement)this.getObjectForHandle(node.getHandleIdentifier());
            switch (element.getElementType()) {
                case 11: 
                case 12: 
                case 30: {
                    return this.getErrorTicksFromMarkers(element.getResource(), 2, null);
                }
                case 60: {
                    return this.getErrorTicksFromMarkers(element.getResource(), 1, null);
                }
                case 61: 
                case 62: 
                case 65: 
                case 70: 
                case 72: 
                case 74: 
                case 75: 
                case 78: 
                case 79: 
                case 80: {
                    ITranslationUnit cu = (ITranslationUnit)element.getAncestor(60);
                    if (cu != null) {
                        return this.getErrorTicksFromMarkers(element.getResource(), 1, null);
                    }
                    break;
                }
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private boolean getErrorTicksFromMarkers(IResource res, int depth, ISourceReference sourceElement) throws CoreException {
        if (res == null || !res.isAccessible()) {
            return false;
        }
        IMarker[] markers = res.findMarkers("org.eclipse.core.resources.problemmarker", true, depth);
        if (markers != null) {
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                int priority;
                IMarker curr = iMarkerArray[n2];
                if (sourceElement == null && (priority = curr.getAttribute("severity", -1)) == 2) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

