/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.kernelmemoryusage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelThreadInformationProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.kernelmemoryusage.KernelMemoryAnalysisModule;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Activator;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.kernelmemoryusage.KernelMemoryUsageEntry;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.kernelmemoryusage.Messages;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractTmfTreeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeColumnDataProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeViewerEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeColumnData;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfTreeViewerEntry;

public class KernelMemoryUsageTreeViewer
extends AbstractTmfTreeViewer {
    private KernelMemoryAnalysisModule fModule = null;
    private String fSelectedThread = null;
    private static final String[] COLUMN_NAMES = new String[]{Messages.KernelMemoryUsageComposite_ColumnTID, Messages.KernelMemoryUsageComposite_ColumnProcess};
    private final Map<String, String> fProcessNameMap = new HashMap<String, String>();

    public KernelMemoryUsageTreeViewer(Composite parent) {
        super(parent, false);
        this.setLabelProvider((IBaseLabelProvider)new KernelMemoryLabelProvider());
    }

    protected ITmfTreeColumnDataProvider getColumnDataProvider() {
        return new ITmfTreeColumnDataProvider(){

            public List<TmfTreeColumnData> getColumnData() {
                ArrayList<TmfTreeColumnData> columns = new ArrayList<TmfTreeColumnData>();
                TmfTreeColumnData column = new TmfTreeColumnData(COLUMN_NAMES[0]);
                column.setComparator(new ViewerComparator(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        KernelMemoryUsageEntry n1 = (KernelMemoryUsageEntry)((Object)e1);
                        KernelMemoryUsageEntry n2 = (KernelMemoryUsageEntry)((Object)e2);
                        return n1.getTid().compareTo(n2.getTid());
                    }
                });
                columns.add(column);
                column = new TmfTreeColumnData(COLUMN_NAMES[1]);
                column.setComparator(new ViewerComparator(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        KernelMemoryUsageEntry n1 = (KernelMemoryUsageEntry)((Object)e1);
                        KernelMemoryUsageEntry n2 = (KernelMemoryUsageEntry)((Object)e2);
                        return n1.getProcessName().compareTo(n2.getProcessName());
                    }
                });
                columns.add(column);
                return columns;
            }
        };
    }

    protected void contentChanged(ITmfTreeViewerEntry rootEntry) {
        String selectedThread = this.fSelectedThread;
        if (selectedThread != null) {
            for (ITmfTreeViewerEntry entry : rootEntry.getChildren()) {
                if (!(entry instanceof KernelMemoryUsageEntry) || !selectedThread.equals(((KernelMemoryUsageEntry)entry).getTid())) continue;
                List<ITmfTreeViewerEntry> list = Collections.singletonList(entry);
                super.setSelection(list);
                return;
            }
        }
    }

    public void initializeDataSource() {
        ITmfTrace trace = (ITmfTrace)NonNullUtils.checkNotNull((Object)this.getTrace());
        this.fModule = (KernelMemoryAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelMemoryAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.core.kernelmemory");
        if (this.fModule == null) {
            return;
        }
        this.fModule.schedule();
        this.fModule.waitForInitialization();
        this.fProcessNameMap.clear();
    }

    protected ITmfTreeViewerEntry updateElements(long start, long end, boolean isSelection) {
        if (isSelection || start == end) {
            return null;
        }
        KernelMemoryAnalysisModule module = this.fModule;
        if (this.getTrace() == null || module == null) {
            return null;
        }
        module.waitForInitialization();
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            return null;
        }
        ss.waitUntilBuilt();
        TmfTreeViewerEntry root = new TmfTreeViewerEntry("");
        List entryList = root.getChildren();
        try {
            long newStart = Math.max(start, ss.getStartTime());
            long newEnd = Math.min(end, ss.getCurrentEndTime());
            if (ss.getStartTime() > newEnd || ss.getCurrentEndTime() < start) {
                return root;
            }
            List memoryStates = ss.queryFullState(newStart);
            List threadQuarkList = ss.getSubAttributes(-1, false);
            for (Integer threadQuark : threadQuarkList) {
                ITmfStateInterval threadMemoryInterval = (ITmfStateInterval)memoryStates.get(threadQuark);
                if (threadMemoryInterval.getEndTime() >= end) continue;
                String tid = ss.getAttributeName(threadQuark.intValue());
                String procname = this.getProcessName(tid);
                KernelMemoryUsageEntry obj = new KernelMemoryUsageEntry(tid, procname);
                entryList.add(obj);
            }
        }
        catch (StateSystemDisposedException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
        return root;
    }

    private String getProcessName(String tid) {
        String execName = this.fProcessNameMap.get(tid);
        if (execName != null) {
            return execName;
        }
        if (tid.equals("other")) {
            this.fProcessNameMap.put(tid, tid);
            return tid;
        }
        ITmfTrace trace = (ITmfTrace)NonNullUtils.checkNotNull((Object)this.getTrace());
        KernelAnalysisModule kernelModule = (KernelAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        if (kernelModule == null) {
            return tid;
        }
        execName = KernelThreadInformationProvider.getExecutableName((KernelAnalysisModule)kernelModule, (Integer)Integer.parseInt(tid));
        if (execName == null) {
            return tid;
        }
        this.fProcessNameMap.put(tid, execName);
        return execName;
    }

    public void setSelectedThread(String tid) {
        this.fSelectedThread = tid;
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        this.initSelection();
        super.traceSelected(signal);
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        this.initSelection();
        super.traceOpened(signal);
    }

    private void initSelection() {
        TmfTraceContext ctx = TmfTraceManager.getInstance().getCurrentTraceContext();
        @Nullable Object data = ctx.getData("org.eclipse.tracecompass.analysis.os.linux.ui.kernelmemoryusageview.KERNEL_MEMORY");
        String thread = data instanceof String ? (String)data : null;
        this.setSelectedThread(thread);
    }

    protected static class KernelMemoryLabelProvider
    extends AbstractTmfTreeViewer.TreeLabelProvider {
        protected KernelMemoryLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            KernelMemoryUsageEntry obj = (KernelMemoryUsageEntry)((Object)element);
            if (columnIndex == 0) {
                return obj.getTid();
            }
            if (columnIndex == 1) {
                return obj.getProcessName();
            }
            return element.toString();
        }
    }
}

