/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.profiling.launch.ui;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.internal.profiling.launch.ProfileLaunchPlugin;
import org.eclipse.linuxtools.profiling.launch.ui.FileSystemElement;
import org.eclipse.linuxtools.profiling.launch.ui.FileSystemSelectionArea;
import org.eclipse.linuxtools.profiling.launch.ui.IRemoteResourceSelectorProxy;
import org.eclipse.linuxtools.profiling.launch.ui.ResourceSelectorWidgetMessages;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ResourceSelectorWidget {
    private static String BROWSE_LABEL = ResourceSelectorWidgetMessages.browseLabelText;
    private ResourceType resourceType;
    private Group mainComp;
    private String sectionLabelText;
    private Label uriLabel;
    private Text uriField;
    private Button browseButton;
    private FileSystemSelectionArea fileSystemSelectionArea;

    private void handleURIBrowseButtonPressed() {
        String selectedResource;
        block8: {
            block7: {
                selectedResource = null;
                String path = this.getURIText().getText();
                FileSystemElement fileSystem = this.fileSystemSelectionArea.getSelectedFileSystem();
                IRemoteResourceSelectorProxy resourceSelector = fileSystem.getSelectorProxy();
                if (resourceSelector == null) break block7;
                switch (this.resourceType) {
                    case FILE: {
                        URI uri = resourceSelector.selectFile(fileSystem.getScheme(), path, String.valueOf(ResourceSelectorWidgetMessages.ResourceSelectorWidget_select) + this.sectionLabelText, this.browseButton.getShell());
                        if (uri != null) {
                            selectedResource = uri.toString();
                        }
                        break block8;
                    }
                    case DIRECTORY: {
                        URI uri = resourceSelector.selectDirectory(fileSystem.getScheme(), path, String.valueOf(ResourceSelectorWidgetMessages.ResourceSelectorWidget_select) + this.sectionLabelText, this.browseButton.getShell());
                        if (uri != null) {
                            selectedResource = uri.toString();
                        }
                        break block8;
                    }
                    default: {
                        ProfileLaunchPlugin.log(4, ResourceSelectorWidgetMessages.ResourceSelectorWidget_unrecognized_resourceType);
                        return;
                    }
                }
            }
            ProfileLaunchPlugin.log(4, ResourceSelectorWidgetMessages.ResourceSelectorWidget_getSelectorProxy_returned_null);
        }
        if (selectedResource != null) {
            this.updateURIField(selectedResource);
        }
    }

    private void updateFilesystemSelector(String newPath) {
        block5: {
            try {
                URI selectedURI = new URI(newPath);
                String scheme = selectedURI.getScheme();
                try {
                    if (scheme == null) {
                        this.fileSystemSelectionArea.setSelectedFileSystem("local");
                        break block5;
                    }
                    this.fileSystemSelectionArea.setSelectedFileSystem(scheme);
                }
                catch (CoreException coreException) {}
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    private void updateURIField(String selectedPath) {
        this.uriField.setText(TextProcessor.process((String)selectedPath));
        this.updateFilesystemSelector(selectedPath);
    }

    private void createFileSystemSelection(Composite composite) {
        this.fileSystemSelectionArea = new FileSystemSelectionArea();
        this.fileSystemSelectionArea.createContents(composite);
    }

    private void createUserEntryArea(Composite composite, String uriLabelText) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.uriLabel = new Label(composite, 0);
        if (uriLabelText != null) {
            this.uriLabel.setText(uriLabelText);
        } else {
            this.uriLabel.setText(ResourceSelectorWidgetMessages.uriLabelText);
        }
        this.uriField = new Text(composite, 2048);
        GridData data = new GridData(768);
        data.horizontalSpan = 1;
        this.uriField.setLayoutData((Object)data);
        new Label(composite, 0);
        Composite browserComp = new Composite(composite, 0);
        FillLayout browserLayout = new FillLayout(256);
        browserComp.setLayout((Layout)browserLayout);
        this.createFileSystemSelection(browserComp);
        this.browseButton = new Button(browserComp, 8);
        this.browseButton.setText(BROWSE_LABEL);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ResourceSelectorWidget.this.handleURIBrowseButtonPressed();
            }
        });
        this.uriField.addModifyListener(e -> this.updateFilesystemSelector(this.uriField.getText()));
    }

    public ResourceSelectorWidget(Composite parent, ResourceType resourceType, int colSpan, String sectionLabelText, String uriLabelText) {
        this.resourceType = resourceType;
        this.sectionLabelText = sectionLabelText;
        this.mainComp = new Group(parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 5;
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        this.mainComp.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        this.mainComp.setLayoutData((Object)gd);
        this.mainComp.setText(sectionLabelText);
        this.createUserEntryArea((Composite)this.mainComp, uriLabelText);
    }

    public void setEnabled(boolean enabled) {
        if (this.mainComp != null) {
            this.mainComp.setEnabled(enabled);
        }
        if (this.uriLabel != null) {
            this.uriLabel.setEnabled(enabled);
        }
        if (this.browseButton != null) {
            this.browseButton.setEnabled(enabled);
        }
        if (this.uriField != null) {
            this.uriField.setEnabled(enabled);
        }
        if (this.fileSystemSelectionArea != null) {
            this.fileSystemSelectionArea.setEnabled(enabled);
        }
    }

    public Text getURIText() {
        return this.uriField;
    }

    public static enum ResourceType {
        FILE,
        DIRECTORY;

    }
}

